/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.X_MP_OT_ResourceOrder;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateResourceOrder
extends SvrProcess {
    private int p_Order_ID;
    private int cantOT;

    protected void prepare() {
        this.p_Order_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.p_Order_ID, this.get_TrxName());
        MOrderLine[] lines = order.getLines(false, null);
        this.cantOT = 0;
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            this.log.config("ID de linea: " + line.get_ID());
            if (line.get_ValueAsInt("MP_JobStandar_ID") > 0) {
                this.createNVResourceDetail(line, line.get_ValueAsInt("MP_JobStandar_ID"));
            } else {
                line.setDescription("No Existe Estandar de Trabajo asociado");
                line.save();
            }
            ++i;
        }
        return "Se han generado " + this.cantOT + " lineas de recursos";
    }

    public boolean createNVResourceDetail(MOrderLine oLine, int ID_JobStandar) {
        this.log.config("ID linea antes de sql: " + oLine.get_ID());
        String sql = "SELECT jsr.AD_Org_ID,jsr.CostAmt,jsr.S_Resource_ID,jsr.M_BOM_ID,jsr.RESOURCEQTY,jsr.RESOURCETYPE,  jsr.M_Product_ID,jsr.MP_JobStandar_Task_ID,jsr.MP_JobStandar_Task_ID  FROM MP_JobStandar_Task jst  INNER JOIN MP_JobStandar_Resource jsr ON (jst.MP_JobStandar_Task_ID = jsr.MP_JobStandar_Task_ID)  WHERE MP_JobStandar_ID = ?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ID_JobStandar);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_ResourceOrder re = new X_MP_OT_ResourceOrder(Env.getCtx(), 0, null);
                re.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                re.setMP_OT_Task_ID(rs.getInt("MP_JobStandar_Task_ID"));
                re.setCostAmt(rs.getBigDecimal("CostAmt"));
                re.setS_Resource_ID(rs.getInt("S_Resource_ID"));
                re.setM_BOM_ID(rs.getInt("M_BOM_ID"));
                re.setResourceQty(rs.getBigDecimal("RESOURCEQTY").multiply(oLine.getQtyEntered()));
                re.setResourceType(rs.getString("RESOURCETYPE"));
                re.set_ValueOfColumn("M_Product_ID", (Object)rs.getInt("M_Product_ID"));
                re.set_CustomColumn("C_Order_ID", this.p_Order_ID);
                this.log.config("ID Linea dentro de metodo:" + oLine.get_ID());
                re.set_CustomColumn("C_OrderLine_ID", oLine.get_ID());
                re.saveEx();
                ++this.cantOT;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }
}

