/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutOrderLineWINDSOR
extends CalloutEngine {
    public String OrderLineWH(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int ID_Product = (Integer)value;
        if (ID_Product > 0) {
            MProduct prod = new MProduct(ctx, ID_Product, null);
            if (prod.get_Value("WinHeight") != null) {
                mTab.setValue("WinHeight", prod.get_Value("WinHeight"));
            }
            if (prod.get_Value("WinWidth") != null) {
                mTab.setValue("WinWidth", prod.get_Value("WinWidth"));
            }
        }
        return "";
    }

    public String qtyDisponible(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (mTab.getValue("M_RequisitionLine_ID") == null) {
            CPreparedStatement pstmt = null;
            Integer client_id = (Integer)mTab.getValue("AD_Client_ID");
            Integer product_id = (Integer)mTab.getValue("M_Product_ID");
            Integer disponible = 0;
            String resultStr = "";
            if (client_id == 1000000 && product_id != null && product_id != 0) {
                String sql = "SELECT qtyavailableofb(?,1000001)+qtyavailableofb(?,1000010) as suma FROM dual";
                resultStr = " Producto:" + product_id;
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, product_id);
                    pstmt.setInt(2, product_id);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        disponible = rs.getInt("suma");
                        resultStr = String.valueOf(resultStr) + " disponible: " + disponible;
                    }
                    BigDecimal qtyBD = (BigDecimal)mTab.getValue("QtyEntered");
                    Integer qty = qtyBD.intValue();
                    mTab.setValue("Disponible", (Object)disponible);
                    if (qty > disponible) {
                        mTab.setValue("SINDISPONIBLE", (Object)Character.valueOf('Y'));
                    }
                    if (qty <= disponible) {
                        mTab.setValue("SINDISPONIBLE", (Object)Character.valueOf('N'));
                    }
                    if (resultStr != null && resultStr.trim().length() > 3) {
                        mTab.fireDataStatusEEvent(resultStr, "Validaci\u00f3n de Stock", true);
                    }
                }
                catch (Exception e) {
                    this.log.config("Error: " + e.toString());
                }
            }
        }
        return "";
    }

    public String qtyW(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        int C_UOM_To_ID;
        BigDecimal QtyEntered;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        BigDecimal QtyOrdered = Env.ZERO;
        if (M_Product_ID == 0) {
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && Env.isSOTrx((Properties)ctx, (int)WindowNo) && QtyOrdered.signum() > 0 && (product = MProduct.get(ctx, M_Product_ID)).isStocked() && product.get_ValueAsBoolean("CheckQty") && product.getAD_Client_ID() != 1000000) {
            int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
            int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_AttributeSetInstance_ID");
            BigDecimal available = Env.ZERO;
            String whereClause = "AD_Client_ID=?";
            List list = new Query(ctx, "M_Warehouse", whereClause, null).setParameters(new Object[]{product.getAD_Client_ID()}).setOnlyActiveRecords(true).setOrderBy("M_Warehouse_ID").list();
            for (MWarehouse wh : list) {
                BigDecimal temp = DB.getSQLValueBD(null, (String)"select  BOMQTYAVAILABLE(M_Product_ID,?,0) from M_Product  Where M_Product_ID=? ", (Object[])new Object[]{wh.getM_Warehouse_ID(), product.getM_Product_ID()});
                available = available.add(temp);
            }
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                String info = "Disponible :" + available.toString();
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + available + "  -  @QtyNotReserved@=" + notReserved + "  =  " + total));
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        return "";
    }
}

