/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_MP_MaintainDetail;
import org.compiere.model.X_MP_OT;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPProcessOT
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_MP_OT OT = new X_MP_OT(Env.getCtx(), this.Record_ID, this.get_TrxName());
        String sql = "Select count(1) from MP_OT_TASK where STATUS ='NS' and MP_OT_ID=" + this.Record_ID;
        if (DB.getSQLValue((String)this.get_TrxName(), (String)sql) > 0 && OT.getDocStatus().equals("DR") && this.P_DocAction.equals("CO")) {
            return "Tasks Not Completed";
        }
        if (this.P_DocAction.equals("CO")) {
            BigDecimal amtLog;
            BigDecimal actualKm = (BigDecimal)OT.get_Value("tsm_km");
            if (actualKm == null) {
                actualKm = Env.ZERO;
            }
            if (actualKm != null && actualKm.compareTo(Env.ZERO) >= 0 && OT.getA_Asset_ID() > 0 && (amtLog = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT MAX(ml.amt)  FROM A_Asset aa  INNER JOIN MP_AssetMeter am ON (aa.A_Asset_ID = am.A_Asset_ID)  INNER JOIN MP_AssetMeter_Log ml ON (am.MP_AssetMeter_ID = ml.MP_AssetMeter_ID) INNER JOIN MP_Meter me ON (me.MP_Meter_ID = am.MP_Meter_ID)  WHERE upper(me.name) like 'KM' AND aa.A_Asset_ID = " + OT.getA_Asset_ID() + " AND aa.IsActive = 'Y' AND ml.IsActive = 'Y'"), (Object[])new Object[0])) != null && amtLog.compareTo(Env.ZERO) > 0 && actualKm.compareTo(amtLog) <= 0) {
                throw new AdempiereException("No se puede completar OT. Ultimo odometro registrado " + amtLog);
            }
        }
        String mysql = "select distinct MP_MAINTAINDetail_ID from MP_OT_TASK where MP_OT_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, this.Record_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_MaintainDetail mp = new X_MP_MaintainDetail(Env.getCtx(), rs.getInt(1), this.get_TrxName());
                if (!OT.getDocStatus().equals("VO") && this.P_DocAction.equals("VO")) {
                    if (mp.isProgrammingType().equals("C")) {
                        mp.setDateNextRun(new Timestamp(mp.getDateNextRun().getTime() - mp.getInterval().longValue() * 86400000L));
                    } else {
                        mp.setnextmp(mp.getnextmp().subtract(mp.getInterval()));
                        mp.setlastmp(mp.getnextmp().subtract(mp.getInterval()));
                    }
                }
                if ((OT.getDocStatus().equals("DR") || OT.getDocStatus().equals("PR")) && this.P_DocAction.equals("CO")) {
                    mp.setDateLastOT(OT.getDateTrx());
                    mp.set_CustomColumn("MP_OT_ID", OT.getMP_OT_ID());
                }
                mp.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (OT.getDocStatus().equals("DR") && this.P_DocAction.equals("PR")) {
            OT.setDocStatus("PR");
            OT.setDocAction("CO");
            OT.save();
            return "OT Processed";
        }
        if ((OT.getDocStatus().equals("DR") || OT.getDocStatus().equals("PR")) && this.P_DocAction.equals("CO")) {
            DB.executeUpdate((String)("Update MP_OT_RESOURCE set Processed='Y' where MP_OT_TASK_ID IN (select MP_OT_TASK_ID from MP_OT_TASK where MP_OT_ID=" + OT.getMP_OT_ID() + ")"), (String)this.get_TrxName());
            DB.executeUpdate((String)("Update MP_OT_TASK set Processed='Y' where MP_OT_ID=" + OT.getMP_OT_ID()), (String)this.get_TrxName());
            OT.setDocStatus("CO");
            OT.setDocAction("--");
            OT.setProcessed(true);
            OT.save();
            return "OT Completed";
        }
        if (!OT.getDocStatus().equals("VO") && this.P_DocAction.equals("VO")) {
            DB.executeUpdate((String)("Update MP_OT_RESOURCE set Processed='Y' where MP_OT_TASK_ID IN (select MP_OT_TASK_ID from MP_OT_TASK where MP_OT_ID=" + OT.getMP_OT_ID() + ")"), (String)this.get_TrxName());
            DB.executeUpdate((String)("Update MP_OT_TASK set Processed='Y' where MP_OT_ID=" + OT.getMP_OT_ID()), (String)this.get_TrxName());
            OT.setDocStatus("VO");
            OT.setDocAction("--");
            OT.setProcessed(true);
            OT.save();
            return "OT Voided";
        }
        return "";
    }
}

