/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModTSMUpdateDueDateXML
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMUpdateDueDateXML.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoice invoice;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoice.Table_ID && (invoice = (MInvoice)((Object)po)).isSOTrx()) {
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS((String)invoice.get_TrxName(), (String)"SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", (Object[])new Object[]{invoice.get_ID()});
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID()));
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            invoice.set_CustomColumn("DateExpiration", fchVencCal);
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

