/*
 * Decompiled with CFR 0.152.
 */
package org.safeenergy.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.OFBProductCost;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModSEUpdateCost
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModSEUpdateCost.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID) {
            MInOut receipt = (MInOut)((Object)po);
            MAcctSchema ass = MAcctSchema.getClientAcctSchema((Properties)po.getCtx(), (int)Env.getAD_Client_ID((Properties)po.getCtx()))[0];
            if (!receipt.isSOTrx() && receipt.getC_Order_ID() > 0) {
                BigDecimal totalCost = DB.getSQLValueBD((String)po.get_TrxName(), (String)"SELECT (SUM(cost1)+SUM(cost2)+SUM(cost3)+SUM(cost4)+SUM(cost5)+SUM(cost6)+SUM(cost7)+SUM(cost8)) as cost FROM POI_ImportCost WHERE M_InOut_ID = ?", (int)receipt.get_ID());
                MInOutLine[] receiptLines = receipt.getLines(false);
                int i = 0;
                while (i < receiptLines.length) {
                    MInOutLine line = receiptLines[i];
                    if (line.getM_Product_ID() > 0) {
                        MCost cost = null;
                        cost = OFBProductCost.getMCost(line.getM_Product_ID(), 0, 0, ass.getC_AcctSchema_ID(), ass.getM_CostType_ID(), po.get_TrxName(), po.getCtx());
                        BigDecimal acumulatedAmt = (BigDecimal)cost.get_Value("managementAmt");
                        BigDecimal acumulatedQty = (BigDecimal)cost.get_Value("managementQty");
                        BigDecimal productCost = (BigDecimal)cost.get_Value("managementCost");
                        if (acumulatedAmt == null) {
                            acumulatedAmt = Env.ZERO;
                        }
                        if (acumulatedQty == null) {
                            acumulatedQty = Env.ZERO;
                        }
                        if (productCost == null) {
                            productCost = Env.ZERO;
                        }
                        if (line.getC_OrderLine_ID() > 0) {
                            MOrderLine oLine = new MOrderLine(po.getCtx(), line.getC_OrderLine_ID(), po.get_TrxName());
                            MOrder order = new MOrder(po.getCtx(), oLine.getC_Order_ID(), po.get_TrxName());
                            String sqlSchema = "SELECT MAX(C_AcctSchema1_ID) as C_AcctSchema1_ID FROM AD_ClientInfo WHERE AD_Client_ID = " + order.getAD_Client_ID();
                            int id_Schema = DB.getSQLValue((String)po.get_TrxName(), (String)sqlSchema);
                            MAcctSchema as = new MAcctSchema(po.getCtx(), id_Schema, po.get_TrxName());
                            BigDecimal amt = oLine.getLineNetAmt();
                            MTax imp = new MTax(po.getCtx(), oLine.getC_Tax_ID(), po.get_TrxName());
                            if (amt != null) {
                                BigDecimal amtImp = amt.multiply(imp.getRate());
                                amtImp = amtImp.divide(Env.ONEHUNDRED, 6, RoundingMode.HALF_EVEN);
                                amt = amt.add(amtImp);
                                BigDecimal ponderado = new BigDecimal("0.0");
                                if (totalCost != null) {
                                    ponderado = amt.divide(order.getGrandTotal(), 6, RoundingMode.HALF_EVEN).multiply(totalCost);
                                }
                                BigDecimal costBase = amt.add(ponderado);
                                BigDecimal amtConvert = null;
                                if (order.getC_Currency_ID() != as.getC_Currency_ID()) {
                                    amtConvert = MConversionRate.convert(po.getCtx(), costBase.divide(line.getQtyEntered(), 6, RoundingMode.HALF_EVEN), order.getC_Currency_ID(), as.getC_Currency_ID(), order.getDateOrdered(), order.getC_ConversionType_ID(), order.getAD_Client_ID(), order.getAD_Org_ID());
                                    log.config("monto dentro de if: " + amtConvert);
                                } else {
                                    amtConvert = oLine.getLineNetAmt();
                                }
                                acumulatedAmt = acumulatedAmt.add(amtConvert.multiply(line.getQtyEntered()));
                                acumulatedQty = acumulatedQty.add(line.getQtyEntered());
                                productCost = productCost == null ? amtConvert : (productCost.compareTo(Env.ZERO) == 0 ? productCost.add(amtConvert).divide(Env.ONE) : productCost.add(amtConvert).divide(new BigDecimal("2.0"), 6, RoundingMode.HALF_EVEN));
                                cost.set_CustomColumn("managementAmt", acumulatedAmt);
                                cost.set_CustomColumn("managementQty", acumulatedQty);
                                cost.set_CustomColumn("managementCost", productCost);
                                cost.save();
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

