/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateCommissionSalesRep
extends SvrProcess {
    private int p_CommissionR_ID;

    protected void prepare() {
        this.p_CommissionR_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MCommissionRun commisR;
        block23: {
            commisR = new MCommissionRun(this.getCtx(), this.p_CommissionR_ID, this.get_TrxName());
            String sqlPList = "SELECT ci.C_Invoice_ID,bp.SalesRep_ID  FROM C_Invoice ci  INNER JOIN C_DocType dt ON (ci.C_DocTypeTarget_ID = dt.C_DocType_ID)  INNER JOIN C_Bpartner bp ON (ci.C_Bpartner_ID = bp.C_Bpartner_ID) WHERE ci.IsSOTrx = 'Y' AND dt.DocBaseType IN ('ARI','ARC')  AND ci.IsActive = 'Y' AND ci.DocStatus IN ('CO','CL') AND ci.AD_Client_ID = " + commisR.getAD_Client_ID() + " AND ci.DateInvoiced BETWEEN ? AND ? " + " AND ci.C_DocType_ID NOT IN (1000077,1000003)" + " AND ci.C_Invoice_ID NOT IN (SELECT C_Invoice_ID FROM C_CommissionDetail " + " WHERE C_Invoice_ID IS NOT NULL AND IsActive = 'Y') ORDER BY bp.SalesRep_ID DESC";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlPList, (String)this.get_TrxName());
                    pstmt.setTimestamp(1, commisR.getStartDate());
                    pstmt.setTimestamp(2, (Timestamp)commisR.get_Value("EndDate"));
                    rs = pstmt.executeQuery();
                    BigDecimal amtInv = null;
                    MCommissionAmt comAmt = null;
                    int ID_UserOld = 0;
                    while (rs.next()) {
                        BigDecimal qtyCostOld;
                        int M_PriceList_Version_ID;
                        amtInv = new BigDecimal("0.0");
                        MInvoice inv = new MInvoice(this.getCtx(), rs.getInt("C_Invoice_ID"), this.get_TrxName());
                        MBPartnerLocation iloc = new MBPartnerLocation(this.getCtx(), inv.getC_BPartner_Location_ID(), this.get_TrxName());
                        BigDecimal qtyCost = (BigDecimal)iloc.get_Value("totalCost");
                        if (qtyCost == null) {
                            qtyCost = Env.ZERO;
                        }
                        if ((M_PriceList_Version_ID = 0) == 0 && inv.getM_PriceList_ID() > 0) {
                            String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                            M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)sql, (Object[])new Object[]{inv.getM_PriceList_ID(), inv.getDateInvoiced()});
                        }
                        if (M_PriceList_Version_ID > 0 && (qtyCostOld = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT MAX(PriceEntered -(SELECT PriceList FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + M_PriceList_Version_ID + " AND M_Product_ID = cil.M_Product_ID))" + " FROM C_InvoiceLine cil WHERE M_Product_ID > 0 AND IsActive = 'Y' AND C_Invoice_ID = " + inv.get_ID()), (Object[])new Object[0])) != null) {
                            qtyCost = qtyCostOld;
                        }
                        int ID_ref = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Commission_ID) FROM C_Commission WHERE LOWER(NAME) LIKE '%escala comisi%'");
                        BigDecimal amtCost = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT MAX(AmtSubtract) FROM C_CommissionLine  WHERE C_Commission_ID = " + ID_ref + " AND qtySubtract = ?"), (Object[])new Object[]{qtyCost.setScale(0, RoundingMode.HALF_EVEN)});
                        if (amtCost == null) {
                            amtCost = Env.ZERO;
                        }
                        if (ID_UserOld != rs.getInt("SalesRep_ID")) {
                            int ID_CommAmt = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT C_CommissionAmt_ID FROM C_CommissionAmt  WHERE IsActive = 'Y' AND SalesRep_ID=" + rs.getInt("SalesRep_ID") + " AND C_CommissionRun_ID = " + commisR.get_ID()));
                            if (ID_CommAmt > 0) {
                                comAmt = new MCommissionAmt(this.getCtx(), ID_CommAmt, this.get_TrxName());
                            } else {
                                comAmt = new MCommissionAmt(this.getCtx(), 0, this.get_TrxName());
                                comAmt.setC_CommissionRun_ID(this.p_CommissionR_ID);
                                comAmt.setAD_Org_ID(commisR.getAD_Org_ID());
                                comAmt.set_CustomColumn("SalesRep_ID", (Object)rs.getInt("SalesRep_ID"));
                                comAmt.save();
                            }
                        }
                        ID_UserOld = rs.getInt("SalesRep_ID");
                        MInvoiceLine[] lines = inv.getLines(false);
                        int i = 0;
                        while (i < lines.length) {
                            MInvoiceLine iline = lines[i];
                            iline.set_CustomColumn("CommissionAmt", amtCost.multiply(iline.getQtyInvoiced()));
                            iline.set_CustomColumn("CommissionCost", qtyCost);
                            iline.save();
                            amtInv = amtInv.add(amtCost.multiply(iline.getQtyInvoiced()));
                            ++i;
                        }
                        MCommissionDetail comDet = new MCommissionDetail(this.getCtx(), 0, this.get_TrxName());
                        comDet.setC_CommissionAmt_ID(comAmt.get_ID());
                        if (inv.getC_DocType().getDocBaseType().compareTo("ARC") == 0) {
                            amtInv = amtInv.negate();
                        }
                        comDet.setActualAmt(amtInv);
                        comDet.setC_Currency_ID(inv.getC_Currency_ID());
                        comDet.set_CustomColumn("C_Invoice_ID", inv.get_ID());
                        comDet.setAD_Org_ID(inv.getAD_Org_ID());
                        comDet.save();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        this.commitEx();
        String sqlRev = "SELECT ca.C_Invoice_ID,extract(day from (cp.datetrx - i.duedate)) as days,cp.C_Payment_ID,bp.SalesRep_ID FROM C_Payment cp  INNER JOIN C_AllocationLine ca ON (cp.C_Payment_ID = ca.C_Payment_ID) INNER JOIN C_AllocationHdr a ON (a.C_AllocationHdr_ID = ca.C_AllocationHdr_ID)  INNER JOIN C_Invoice_v i ON (ca.C_Invoice_ID = i.C_Invoice_ID)  INNER JOIN C_BPartner bp ON (i.C_BPartner_ID = bp.C_BPartner_ID)  WHERE i.IsSOTrx = 'Y'  AND cp.IsActive = 'Y' AND a.DocStatus IN ('CO','CL') AND i.AD_Client_ID = " + commisR.getAD_Client_ID() + " AND cp.DateTrx BETWEEN ? AND ? " + " AND (select count(1) FROM C_CommissionDetail cm WHERE cm.isactive = 'Y' AND cm.C_Invoice_ID = i.C_Invoice_ID) = 1 " + " AND invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID) <= 0 AND extract(day from (cp.datetrx - i.duedate)) > 7 " + " ORDER BY bp.SalesRep_ID DESC";
        Statement pstmtRev = null;
        ResultSet rsRev = null;
        try {
            try {
                pstmtRev = DB.prepareStatement((String)sqlRev, (String)this.get_TrxName());
                pstmtRev.setTimestamp(1, commisR.getStartDate());
                pstmtRev.setTimestamp(2, (Timestamp)commisR.get_Value("EndDate"));
                rsRev = pstmtRev.executeQuery();
                BigDecimal amtRev = null;
                while (rsRev.next()) {
                    int ID_CommDetOld;
                    amtRev = new BigDecimal("0.0");
                    BigDecimal days = rsRev.getBigDecimal("days");
                    int ID_Comm = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Commission_ID) FROM C_Commission WHERE LOWER(NAME) LIKE '%reverso de comisi%'");
                    BigDecimal pDiscount = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT MAX(AmtSubtract) FROM C_CommissionLine  WHERE C_Commission_ID = " + ID_Comm + " AND ? BETWEEN QtySubTract AND QtyMultiplier"), (Object[])new Object[]{days.setScale(0, RoundingMode.HALF_EVEN)});
                    if (pDiscount == null) {
                        pDiscount = Env.ZERO;
                    }
                    if ((ID_CommDetOld = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT C_CommissionDetail_ID FROM C_CommissionDetail  WHERE IsActive = 'Y' AND C_Invoice_ID = " + rsRev.getInt("C_Invoice_ID")))) <= 0 || pDiscount.compareTo(Env.ZERO) == 0) continue;
                    MCommissionDetail comDetOld = new MCommissionDetail(this.getCtx(), ID_CommDetOld, this.get_TrxName());
                    int ID_ComAmtOld = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_CommissionAmt_ID) FROM C_CommissionAmt WHERE  C_CommissionRun_ID = " + commisR.get_ID() + " AND SalesRep_ID = " + rsRev.getInt("SalesRep_ID")));
                    if (ID_ComAmtOld <= 0) {
                        MCommissionAmt comAmtNew = new MCommissionAmt(this.getCtx(), 0, this.get_TrxName());
                        comAmtNew.setAD_Org_ID(commisR.getAD_Org_ID());
                        comAmtNew.setC_CommissionRun_ID(commisR.get_ID());
                        comAmtNew.set_CustomColumn("SalesRep_ID", (Object)rsRev.getInt("SalesRep_ID"));
                        comAmtNew.save();
                        ID_ComAmtOld = comAmtNew.get_ID();
                    }
                    MCommissionDetail comDetnew = new MCommissionDetail(this.getCtx(), 0, this.get_TrxName());
                    comDetnew.setC_CommissionAmt_ID(ID_ComAmtOld);
                    comDetnew.setC_Currency_ID(comDetOld.getC_Currency_ID());
                    comDetnew.set_CustomColumn("C_Invoice_ID", comDetOld.get_ValueAsInt("C_Invoice_ID"));
                    comDetnew.set_CustomColumn("C_Payment_ID", rsRev.getInt("C_Payment_ID"));
                    amtRev = comDetOld.getActualAmt().multiply(pDiscount);
                    amtRev = amtRev.divide(Env.ONEHUNDRED).negate();
                    comDetnew.setActualAmt(amtRev);
                    comDetnew.setAD_Org_ID(comDetOld.getAD_Org_ID());
                    comDetnew.save();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                pstmtRev.close();
                rsRev.close();
                pstmtRev = null;
                rsRev = null;
            }
        }
        finally {
            pstmtRev.close();
            rsRev.close();
            pstmtRev = null;
            rsRev = null;
        }
        return "OK";
    }
}

