/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CompleteOrderInvalid
extends SvrProcess {
    private Timestamp p_DateTrx;
    private Timestamp p_DateTrxTo;
    private int p_Org_ID;
    private String p_Hora;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTrx")) {
                this.p_DateTrx = (Timestamp)para[i].getParameter();
                this.p_DateTrxTo = (Timestamp)para[i].getParameter_To();
            } else if (name.equals("AD_Org_ID")) {
                this.p_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("HourEnd")) {
                this.p_Hora = para[i].getParameter().toString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int cant;
        block9: {
            String sql = "SELECT C_Order_ID FROM C_Order WHERE IsActive = 'Y'  AND IssoTrx = 'Y' AND DocStatus IN ('IN') AND IsInValidation <> 'Y'  AND Created BETWEEN ? AND ? AND AD_Client_ID = " + Env.getAD_Client_ID((Properties)this.getCtx());
            if (this.p_Org_ID > 0) {
                sql = String.valueOf(sql) + " AND AD_Org_ID = " + this.p_Org_ID;
            }
            cant = 0;
            this.p_DateTrxTo.setHours(Integer.parseInt(this.p_Hora.substring(0, 2)));
            this.p_DateTrxTo.setMinutes(Integer.parseInt(this.p_Hora.substring(3, 5)));
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_DateTrx);
                    pstmt.setTimestamp(2, this.p_DateTrxTo);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MOrder order = new MOrder(this.getCtx(), rs.getInt("C_Order_ID"), this.get_TrxName());
                        order.set_CustomColumn("Override", true);
                        if (order.getDescription() != null) {
                            order.setDescription(String.valueOf(order.getDescription()) + ". Orden completada automaticamente.");
                        } else {
                            order.setDescription("Orden completada automaticamente.");
                        }
                        order.setDocStatus("DR");
                        order.processIt("CO");
                        if (!order.save(this.get_TrxName())) continue;
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "Se Han completado " + cant + " ordenes";
    }
}

