/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAValidOrderBP
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAValidOrderBP.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            MBPartnerLocation bLoc;
            int flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM C_DocType WHERE C_DocType_ID = " + order.getC_DocType_ID() + " AND C_DocType_ID IN ( SELECT dt.C_DocType_ID FROM C_DocType dt " + " INNER JOIN C_DocType dt2 ON (dt.C_DocTypeInvoice_ID = dt2.C_DocType_ID)" + " WHERE dt2.DocBaseType = 'ARC')"));
            String sqlAmt = "select qty from rvofb_authorization where C_BPartner_ID = " + order.getC_BPartner_ID();
            BigDecimal amt = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlAmt, (Object[])new Object[0]);
            if (amt == null) {
                amt = Env.ZERO;
            }
            int days = 0;
            String sqlAmtTotal = "select coalesce(dueAmt,0) from rvofb_authorization where C_BPartner_ID = " + order.getC_BPartner_ID();
            BigDecimal amtTotal = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlAmtTotal, (Object[])new Object[0]);
            if (amtTotal == null) {
                amtTotal = Env.ZERO;
            }
            if (flag < 1) {
                boolean isGG = false;
                boolean isGV = false;
                MRole rol = new MRole(po.getCtx(), Env.getAD_Role_ID((Properties)po.getCtx()), po.get_TrxName());
                if (rol.getDescription() != null && rol.getDescription().toLowerCase().contains("gerente general")) {
                    isGG = true;
                } else if (rol.getDescription() != null && rol.getDescription().toLowerCase().contains("gerente de venta")) {
                    isGV = true;
                }
                int DiasMora = 0;
                BigDecimal MontoMora = new BigDecimal("5000000.00");
                MBPartner part = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
                if (part.get_ValueAsString("CreditGroup").compareTo("01") == 0) {
                    DiasMora = 7;
                } else if (part.get_ValueAsString("CreditGroup").compareTo("02") == 0 || part.get_ValueAsString("CreditGroup").compareTo("03") == 0) {
                    DiasMora = 7;
                    MontoMora = new BigDecimal("3000000.00");
                }
                if (!(isGV || isGG || amt.compareTo(Env.ONE) < 0 && amtTotal.compareTo(Env.ONE) < 0)) {
                    return "Orden necesita autorizacion: Cant doc vencidos: " + amt.intValue() + ", Dias de atraso: " + days;
                }
                if (!isGV && !isGG && days > 0) {
                    return "Orden necesita autorizacion: Cant doc vencidos: " + amt.intValue() + ", Dias de atraso: " + days;
                }
                if (isGV && amtTotal.compareTo(MontoMora) > 0) {
                    return "Orden necesita autorizacion: Cant doc vencidos: " + amt.intValue() + ", Dias de atraso: " + days + ", Monto Total mora: " + amtTotal.intValue();
                }
                if (isGV && days > DiasMora) {
                    return "Orden necesita autorizacion: Cant doc vencidos: " + amt.intValue() + ", Dias de atraso: " + days;
                }
            }
            if (!(bLoc = new MBPartnerLocation(po.getCtx(), order.getC_BPartner_Location_ID(), po.get_TrxName())).get_ValueAsBoolean("IsValid")) {
                return "Error: Direcci\u00f3n No V\u00e1lida";
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

