/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModPARoundInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPARoundInvoice.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)((Object)po)).isSOTrx() && inv.getDocStatus().compareToIgnoreCase("CO") != 0 && inv.getDocStatus().compareToIgnoreCase("CL") != 0 && inv.getDocStatus().compareToIgnoreCase("VO") != 0) {
            BigDecimal newAmt = inv.getGrandTotal().setScale(0, RoundingMode.HALF_EVEN);
            if (inv.getGrandTotal().compareTo(newAmt) != 0) {
                inv.setGrandTotal(newAmt);
                inv.save();
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

