/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_PA_Authorization;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ModPACreateAuthorization
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPACreateAuthorization.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            X_PA_Authorization au = new X_PA_Authorization(po.getCtx(), 0, po.get_TrxName());
            String sql = "SELECT * FROM rvofb_authorization WHERE C_BPartner_ID = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                pstmt.setInt(1, order.getC_BPartner_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    au.setAD_Org_ID(order.getAD_Org_ID());
                    au.setIsActive(true);
                    au.set_CustomColumn("C_Order_ID", order.get_ID());
                    au.setC_BPartner_ID(order.getC_BPartner_ID());
                    au.setSalesRep_ID(rs.getInt("SalesRep_ID"));
                    au.setAmount(rs.getBigDecimal("Amount"));
                    au.setQty(rs.getBigDecimal("Qty"));
                    au.setday(rs.getBigDecimal("day"));
                    au.setDueAmt(rs.getBigDecimal("DueAmt"));
                    au.setoverdraft(rs.getBigDecimal("overdraft"));
                    au.setgiro_estimado(rs.getBigDecimal("giro_estimado"));
                    au.setDescription(rs.getString("Description"));
                    au.set_CustomColumn("day2", rs.getBigDecimal("day2"));
                    au.save(po.get_TrxName());
                }
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

