/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import org.compiere.acct.FactLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAAcctCustomTax
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAAcctCustomTax.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        FactLine fLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (!(type != 5 && type != 4 || po.get_Table_ID() != FactLine.Table_ID || (fLine = (FactLine)po).getAD_Table_ID() != MInvoice.Table_ID || (inv = new MInvoice(po.getCtx(), fLine.getRecord_ID(), po.get_TrxName())).getC_DocType().getDocBaseType().compareTo("API") != 0 && inv.getC_DocType().getDocBaseType().compareTo("ARI") != 0 && inv.getC_DocType().getDocBaseType().compareTo("APC") != 0 && inv.getC_DocType().getDocBaseType().compareTo("ARC") != 0)) {
            BigDecimal amtIVA = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT ROUND(COALESCE(SUM(IVATaxAmt),0)) FROM C_InvoiceLine WHERE IsActive = 'Y' AND C_Invoice_ID = " + fLine.getRecord_ID()), (Object[])new Object[0]);
            if (amtIVA == null) {
                amtIVA = Env.ZERO;
            }
            if (fLine.getLine_ID() <= 0 && fLine.getC_Tax_ID() > 0 && fLine.getQty().compareTo(Env.ZERO) <= 0 && fLine.getM_Product_ID() <= 0) {
                if (inv.getC_DocType().getDocBaseType().compareTo("API") == 0) {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctDr=" + amtIVA + ",AmtAcctCr=0,AmtSourceDr=" + amtIVA + ",AmtSourceCr=0 WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else if (inv.getC_DocType().getDocBaseType().compareTo("ARI") == 0) {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctCr=" + amtIVA + ",AmtAcctDr=0,AmtSourceCr=" + amtIVA + ",AmtSourceDr=0 WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else if (fLine.getAmtAcctCr().compareTo(Env.ZERO) > 0) {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctCr =" + amtIVA + ", AmtSourceCr = " + amtIVA + "  WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else if (fLine.getAmtAcctCr().compareTo(Env.ZERO) < 0) {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctDr =" + amtIVA + ", AmtSourceDr = " + amtIVA + "  WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else if (fLine.getAmtAcctDr().compareTo(Env.ZERO) > 0) {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctDr =" + amtIVA + ", AmtSourceDr = " + amtIVA + "  WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else if (fLine.getAmtAcctDr().compareTo(Env.ZERO) < 0) {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctCr =" + amtIVA + ", AmtSourceCr = " + amtIVA + "  WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else {
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctCr =" + amtIVA + ", AmtSourceCr = " + amtIVA + "  WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                }
            } else {
                String sqlAcctTax = "SELECT MAX(SuspenseBalancing_Acct) FROM C_AcctSchema_GL WHERE AD_Client_ID = " + inv.getAD_Client_ID();
                int id_vCombination = DB.getSQLValue((String)po.get_TrxName(), (String)sqlAcctTax);
                if (id_vCombination > 0) {
                    int id_acct = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT account_id FROM c_validcombination where c_validcombination_id = " + id_vCombination));
                    if (fLine.getAccount_ID() == id_acct) {
                        DB.executeUpdateEx((String)("DELETE FROM fact_acct WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                    }
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

