/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPDVDepositoBancario
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVDepositoBancario.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)((Object)po)).getC_DocType_ID() == 1000102) {
            MPayment pay = new MPayment(Env.getCtx(), 0, inv.get_TrxName());
            pay.setIsReceipt(true);
            pay.setAD_Org_ID(inv.getAD_Org_ID());
            pay.setC_BPartner_ID(inv.getC_BPartner_ID());
            pay.setC_BankAccount_ID(inv.get_ValueAsInt("C_BankAccount_ID"));
            pay.setDateTrx(inv.getDateInvoiced());
            pay.setDateAcct(inv.getDateAcct());
            pay.setC_Currency_ID(inv.getC_Currency_ID());
            pay.setTenderType("T");
            pay.setPayAmt(inv.getGrandTotal());
            pay.setC_Invoice_ID(inv.getC_Invoice_ID());
            pay.setDocumentNo(inv.getDocumentNo());
            pay.setIsAllocated(true);
            String description = "";
            String sqlType = "SELECT name FROM AD_Ref_List WHERE AD_Reference_ID=1000067 AND value = '" + pay.get_ValueOldAsInt("DepositType") + "' ";
            description = DB.getSQLValueString((String)inv.get_TrxName(), (String)sqlType, (Object[])new Object[0]);
            if (description == null) {
                pay.setDescription("Generado Automaticamente Deposito Bancario N\u00b0:" + inv.getDocumentNo());
            }
            if (!pay.save()) {
                log.log(Level.SEVERE, "Payment not save");
                return "Payment not save ";
            }
            pay.setDocStatus(pay.completeIt());
            pay.save();
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

