/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateReqFromInventory
extends SvrProcess {
    protected void prepare() {
    }

    protected String doIt() throws Exception {
        int id_role = Env.getAD_Role_ID((Properties)this.getCtx());
        String msg = "";
        int M_Inventory_ID = this.getRecord_ID();
        MInventory inv = new MInventory(this.getCtx(), M_Inventory_ID, this.get_TrxName());
        if (inv.getDocStatus().compareToIgnoreCase("DR") == 0) {
            inv.setDocStatus("L1");
            msg = "Procesado";
        } else if (inv.getDocStatus().compareToIgnoreCase("L1") == 0) {
            if (id_role != 1000022 && id_role != 1000021 && id_role != 1000012) {
                throw new AdempiereUserError("Rol sin privilegios suficientes");
            }
            inv.setDocStatus("L2");
            msg = "Procesado";
        } else if (inv.getDocStatus().compareToIgnoreCase("L2") == 0) {
            if (id_role != 1000021 && id_role != 1000012) {
                throw new AdempiereUserError("Rol sin privilegios suficientes");
            }
            inv.setDocStatus("L3");
            msg = "Procesado";
        } else if (inv.getDocStatus().compareToIgnoreCase("L3") == 0) {
            if (id_role != 1000012) {
                throw new AdempiereUserError("Rol sin privilegios suficientes");
            }
            int idReqRe = 0;
            try {
                idReqRe = inv.get_ValueAsInt("M_Requisition_ID");
            }
            catch (Exception e) {
                this.log.severe("No se pudo setear campo M_Requisition_ID");
                idReqRe = 0;
            }
            if (idReqRe > 0) {
                msg = "Procesado. Solicitud ya relacionada ";
            } else {
                MRequisition req = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                int idDocType = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_DocType_ID) FROM C_DocType WHERE docbasetype = 'POR'  AND IsActive = 'Y' AND AD_Client_ID = " + inv.getAD_Client_ID()));
                if (idDocType > 0) {
                    req.setC_DocType_ID(idDocType);
                } else {
                    req.setC_DocType_ID(1000018);
                }
                req.setAD_Org_ID(inv.getAD_Org_ID());
                int idPriceList = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(M_PriceList_ID) FROM M_PriceList WHERE IsActive = 'Y' AND issopricelist = 'N' AND isdefault = 'Y' AND AD_Client_ID = " + inv.getAD_Client_ID()));
                if (idPriceList > 0) {
                    req.setM_PriceList_ID(idPriceList);
                } else {
                    req.setC_DocType_ID(1000001);
                }
                int idUser = 0;
                try {
                    idUser = inv.get_ValueAsInt("AD_User_ID");
                }
                catch (Exception e) {
                    this.log.severe("No se pudo setear variable AD_User_ID");
                    idUser = 0;
                }
                if (idUser > 0) {
                    req.setAD_User_ID(idUser);
                } else {
                    req.setAD_User_ID(100);
                }
                req.setM_Warehouse_ID(inv.getM_Warehouse_ID());
                req.save();
                MInventoryLine[] invLines = inv.getLines(false);
                int i = 0;
                while (i < invLines.length) {
                    MInventoryLine iLine = invLines[i];
                    MRequisitionLine reqLine = new MRequisitionLine(req);
                    reqLine.setAD_Org_ID(req.getAD_Org_ID());
                    reqLine.setM_Product_ID(iLine.getM_Product_ID());
                    BigDecimal qtyReal = (BigDecimal)iLine.get_Value("qtyReal");
                    reqLine.setQty(qtyReal);
                    reqLine.save();
                    try {
                        reqLine.set_CustomColumn("M_InventoryLine_ID", iLine.get_ID());
                        reqLine.save();
                    }
                    catch (Exception e) {
                        this.log.severe("No se pudo setear campo M_InventoryLine_ID");
                    }
                    ++i;
                }
                inv.set_CustomColumn("M_requisition_ID", req.get_ID());
                msg = "Procesado. Solicitud Creada";
            }
            inv.setDocStatus("CO");
            inv.setProcessed(true);
        }
        inv.save();
        return msg;
    }
}

