/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.process.DocAction;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEInvoiceProvEXP
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = this.CreateXML(inv);
        return msg;
    }

    public String CreateXML(MInvoice inv) {
        MDocType doc = new MDocType(this.getCtx(), inv.getC_DocTypeTarget_ID(), this.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocAction refdoc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento);
            Documento.setAttribute("ID", "DTE-" + inv.getDocumentNo());
            Element Encabezado = document.createElement("Encabezado");
            Documento.appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(inv.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(inv.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            Element FchCancel = document.createElement("FchCancel");
            Text cancel = document.createTextNode(inv.getDateInvoiced().toString().substring(0, 10));
            FchCancel.appendChild(cancel);
            IdDoc.appendChild(FchCancel);
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(inv.getDateInvoiced().toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc.appendChild(FchVenc);
            MPaymentTerm pterm = new MPaymentTerm(this.getCtx(), inv.getC_PaymentTerm_ID(), this.get_TrxName());
            Element PayTerm = document.createElement("PayTerm");
            Text term = document.createTextNode(pterm.getName());
            PayTerm.appendChild(term);
            IdDoc.appendChild(PayTerm);
            MUser salesUser = new MUser(this.getCtx(), inv.getSalesRep_ID(), this.get_TrxName());
            Element SalesRep = document.createElement("SalesRep");
            Text sales = document.createTextNode(salesUser.getName());
            SalesRep.appendChild(sales);
            IdDoc.appendChild(SalesRep);
            Element HDescription = document.createElement("HeaderDescription");
            Text Hdesc = document.createTextNode(inv.getDescription() == null ? " " : inv.getDescription());
            HDescription.appendChild(Hdesc);
            IdDoc.appendChild(HDescription);
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get((Properties)this.getCtx(), (int)inv.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(this.getCtx(), inv.getC_BPartner_ID(), this.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(this.getCtx(), inv.getC_BPartner_Location_ID(), this.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(this.getAD_User_ID() > 0 ? inv.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(inv.getAD_User().getEMail() == null ? " " : inv.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            if (bloc.getLocation(true).getAddress2() != null && bloc.getLocation(true).getAddress2().length() > 0) {
                Element CmnaRecep = document.createElement("CmnaRecep");
                Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress2());
                CmnaRecep.appendChild(Cmna);
                Receptor.appendChild(CmnaRecep);
            }
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(this.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountex = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + inv.getC_Invoice_ID()), (Object[])new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + inv.getC_Invoice_ID()), (Object[])new Object[0]);
            String moneda = inv.getC_Currency().getDescription();
            if (moneda != null && moneda.compareToIgnoreCase("US Dollar") == 0) {
                moneda = "DOLAR USA";
            }
            Element TpoMoneda = document.createElement("TpoMoneda");
            Text tpoMonedaTxt = document.createTextNode(moneda);
            TpoMoneda.appendChild(tpoMonedaTxt);
            Totales.appendChild(TpoMoneda);
            if (amountNeto != null && amountNeto.compareTo(Env.ZERO) > 0) {
                Element MntNeto = document.createElement("MntNeto");
                Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
                MntNeto.appendChild(neto);
                Totales.appendChild(MntNeto);
            }
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales.appendChild(MntExe);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(inv.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            Element OtraMoneda = document.createElement("OtraMoneda");
            Encabezado.appendChild(OtraMoneda);
            Element TpoMonedaOM = document.createElement("TpoMoneda");
            Text tpoMonedaTxtOM = document.createTextNode("PESO CL");
            TpoMonedaOM.appendChild(tpoMonedaTxtOM);
            OtraMoneda.appendChild(TpoMonedaOM);
            BigDecimal amtTC = (BigDecimal)inv.get_Value("MultiplyRate");
            if (amtTC == null) {
                amtTC = Env.ONE;
            }
            Element TpoCambio = document.createElement("TpoCambio");
            Text tpoCambioTxt = document.createTextNode(amtTC.setScale(0, 4).toString());
            TpoCambio.appendChild(tpoCambioTxt);
            OtraMoneda.appendChild(TpoCambio);
            Element MntExeOtrMnda = document.createElement("MntExeOtrMnda");
            Text mntExeOtrMndaTxt = document.createTextNode(amountex != null ? amountex.multiply(amtTC).setScale(0, RoundingMode.HALF_EVEN).toString() : "0");
            MntExeOtrMnda.appendChild(mntExeOtrMndaTxt);
            OtraMoneda.appendChild(MntExeOtrMnda);
            Element MntTotOtrMnda = document.createElement("MntTotOtrMnda");
            Text mntTotOtrMndaTxt = document.createTextNode(inv.getGrandTotal() != null ? inv.getGrandTotal().multiply(amtTC).setScale(0, RoundingMode.HALF_EVEN).toString() : "0");
            MntTotOtrMnda.appendChild(mntTotOtrMndaTxt);
            OtraMoneda.appendChild(MntTotOtrMnda);
            mylog = "detalle";
            MInvoiceLine[] iLines = inv.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle = document.createElement("Detalle");
                    Documento.appendChild(Detalle);
                    MTax tax = new MTax(this.getCtx(), iLine.getC_Tax_ID(), this.get_TrxName());
                    if (tax.isTaxExempt()) {
                        Element IndEx = document.createElement("IndExe");
                        Text lineE = document.createTextNode("1");
                        IndEx.appendChild(lineE);
                        Detalle.appendChild(IndEx);
                    }
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(iLine.getLine() / 10));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().setScale(4).toString());
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(iLine.getPriceActual().multiply(amtTC).setScale(0, RoundingMode.HALF_EVEN).toString());
                    PrcItem.appendChild(pa);
                    Detalle.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(iLine.getLineNetAmt().multiply(amtTC).setScale(0, RoundingMode.HALF_EVEN).toString());
                    MontoItem.appendChild(tl);
                    Detalle.appendChild(MontoItem);
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            int nroref = 0;
            if (inv.get_Value("C_RefDoc_ID") != null && (Integer)inv.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(this.getCtx(), (int)((Integer)inv.get_Value("C_RefDoc_ID")), this.get_TrxName());
                MDocType Refdoctype = new MDocType(this.getCtx(), refdoc.getC_DocType_ID(), this.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = refdoc.getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (inv.getPOReference() != null && inv.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = inv.getPOReference();
                fechareferencia = inv.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (inv.get_Value("C_RefInOut_ID") != null && (Integer)inv.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(this.getCtx(), (int)((Integer)inv.get_Value("C_RefInOut_ID")), this.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = refdoc.getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            if (tipo_Ref > 0) {
                Element Referencia = document.createElement("Referencia");
                Documento.appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode(Integer.toString(++nroref));
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                if (fechareferencia == null) {
                    fechareferencia = inv.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.compareTo(" ") == 0 || fechareferencia.compareTo("") == 0) {
                    fechareferencia = inv.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.length() < 2) {
                    fechareferencia = inv.getDateInvoiced().toString().substring(0, 10);
                }
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element CodRef = document.createElement("CodRef");
                Text codref = document.createTextNode(inv.get_ValueAsString("CodRef"));
                CodRef.appendChild(codref);
                Referencia.appendChild(CodRef);
            }
            if (inv.get_ValueAsString("POReference2") != null && inv.get_ValueAsString("POReference2").length() > 0) {
                ++nroref;
                mylog = "referencia:802";
                fechareferencia = inv.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 4;
                Element Referencia2 = document.createElement("Referencia");
                Documento.appendChild(Referencia2);
                Element NroLinRef2 = document.createElement("NroLinRef");
                Text Nro2 = document.createTextNode(Integer.toString(++nroref));
                NroLinRef2.appendChild(Nro2);
                Referencia2.appendChild(NroLinRef2);
                Element TpoDocRef2 = document.createElement("TpoDocRef");
                Text tpo2 = document.createTextNode("802");
                TpoDocRef2.appendChild(tpo2);
                Referencia2.appendChild(TpoDocRef2);
                Element FolioRef2 = document.createElement("FolioRef");
                Text ref2 = document.createTextNode(inv.get_ValueAsString("POReference2"));
                FolioRef2.appendChild(ref2);
                Referencia2.appendChild(FolioRef2);
                if (fechareferencia == null) {
                    fechareferencia = inv.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.compareTo(" ") == 0 || fechareferencia.compareTo("") == 0) {
                    fechareferencia = inv.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.length() < 2) {
                    fechareferencia = inv.getDateInvoiced().toString().substring(0, 10);
                }
                Element FchRef2 = document.createElement("FchRef");
                Text fchref2 = document.createTextNode(fechareferencia);
                FchRef2.appendChild(fchref2);
                Referencia2.appendChild(FchRef2);
                String CodRefTxt = null;
                try {
                    CodRefTxt = inv.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef2 = document.createElement("CodRef");
                    Text codref2 = document.createTextNode(inv.get_ValueAsString("CodRef") == null ? "0" : inv.get_ValueAsString("CodRef"));
                    CodRef2.appendChild(codref2);
                    Referencia2.appendChild(CodRef2);
                }
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento.appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, inv.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Generated";
    }
}

