/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CreateResolutionsOther
extends SvrProcess {
    private Timestamp p_DateTrx_To;
    private Timestamp p_DateTrx_From;
    private int p_Document_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        this.p_Document_ID = this.getRecord_ID();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrx_From = (Timestamp)para[i].getParameter();
                    this.p_DateTrx_To = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        X_DM_Document dc = new X_DM_Document(this.getCtx(), this.p_Document_ID, this.get_TrxName());
        String sqldoc = null;
        String desc = null;
        String descL = null;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.p_DateTrx_From.getTime());
        cal.add(5, -1);
        Timestamp p_DateTrx_FromM = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(this.p_DateTrx_To.getTime());
        cal.add(5, 1);
        Timestamp p_DateTrx_ToM = new Timestamp(cal.getTimeInMillis());
        CPreparedStatement pstmt = null;
        if (dc.getDM_DocumentType().equalsIgnoreCase("RF")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'SVC' and docstatus like 'CO' and signature3 = 'Y' and isactive = 'Y' and datestartrequest > ? and datestartrequest < ? ";
            desc = "Resoluci\u00f3n de Feriado Legal entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resoluci\u00f3n de Feriado Legal";
        } else if (dc.getDM_DocumentType().equalsIgnoreCase("RP")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'PAD' and docstatus like 'CO' and signature3 = 'Y' and isactive = 'Y' and rh_administrativerequests_id in (select rh_administrativerequests_id from rh_administrativerequestsline where datestartrequest > ? and datestartrequest < ?)";
            desc = "Resoluci\u00f3n Permisos Administrativos entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resoluci\u00f3n Permisos Administrativos";
        } else {
            return "Tipo de Resolucion no valido";
        }
        dc.setDescription(desc);
        dc.save();
        int cantC = 0;
        try {
            pstmt = DB.prepareStatement((String)sqldoc, (String)this.get_TrxName());
            pstmt.setTimestamp(1, p_DateTrx_FromM);
            pstmt.setTimestamp(2, p_DateTrx_ToM);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_DM_DocumentLine dl = new X_DM_DocumentLine(this.getCtx(), 0, this.get_TrxName());
                dl.setDM_Document_ID(dc.get_ID());
                dl.set_CustomColumn("RH_AdministrativeRequests_ID", rs.getInt(1));
                dl.setDescription(descL);
                dl.setIsActive(true);
                dl.setAmt(new BigDecimal(0.0));
                dl.save();
                ++cantC;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return "Se han agregado " + cantC + " Lineas de Cometidos";
    }
}

