/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CreateResolutions
extends SvrProcess {
    private String p_Type = null;
    private Timestamp p_DateTrx_To;
    private Timestamp p_DateTrx_From;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Type")) {
                    this.p_Type = (String)para[i].getParameter();
                } else if (name.equals("DateTrx")) {
                    this.p_DateTrx_From = (Timestamp)para[i].getParameter();
                    this.p_DateTrx_To = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        X_DM_Document dc = new X_DM_Document(this.getCtx(), 0, this.get_TrxName());
        String sqldoc = null;
        String desc = null;
        String descL = null;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.p_DateTrx_From.getTime());
        cal.add(5, -1);
        Timestamp p_DateTrx_FromM = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(this.p_DateTrx_To.getTime());
        cal.add(5, 1);
        Timestamp p_DateTrx_ToM = new Timestamp(cal.getTimeInMillis());
        CPreparedStatement pstmt = null;
        if (this.p_Type.equalsIgnoreCase("RTC")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'TCP' and docstatus like 'CO' and signature3 = 'Y' and rh_administrativerequests_id in (select rh_administrativerequests_id from rh_administrativerequestsline where datestartrequest > ? and datestartrequest < ?)";
            desc = "Resolucion Tiempo compensado entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Tiempo Compensado";
        } else if (this.p_Type.equalsIgnoreCase("HTC")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'SHE' and typeshe like 'TC' and docstatus like 'CO' and signature3 = 'Y' and (datestartrequest > ? and datestartrequest < ?)";
            desc = "Resolucion hora extra Tiempo compensado entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Hora extra Tiempo Compensado";
        } else if (this.p_Type.equalsIgnoreCase("HAP")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'SHE' and typeshe like 'PG' and docstatus like 'CO' and signature3 = 'Y' and (datestartrequest > ? and datestartrequest < ?)";
            desc = "Resolucion hora extra A Pago entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Hora extra A Pago";
        } else if (dc.getDM_DocumentType().equalsIgnoreCase("RF")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'SVC' and docstatus like 'CO' and signature3 = 'Y' and isactive = 'Y' and datestartrequest > ? and datestartrequest < ? ";
            desc = "Resolucion hora extra A Pago entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Hora extra A Pago";
        } else if (dc.getDM_DocumentType().equalsIgnoreCase("RF")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests where requesttype like 'PAD' and docstatus like 'CO' and signature3 = 'Y' and isactive = 'Y' and rh_administrativerequests_id in (select rh_administrativerequests_id from rh_administrativerequestsline where datestartrequest > ? and datestartrequest < ?)";
            desc = "Resolucion hora extra A Pago entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Hora extra A Pago";
        }
        dc.setDescription(desc);
        dc.setDateTrx(this.p_DateTrx_From);
        dc.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.getCtx()));
        dc.set_CustomColumn("AD_Client_ID", Env.getAD_Client_ID((Properties)this.getCtx()));
        dc.setDM_DocumentType("RD");
        dc.setDocStatus("DR");
        dc.set_CustomColumn("C_DocType_ID", 1000063);
        dc.save();
        try {
            pstmt = DB.prepareStatement((String)sqldoc, (String)this.get_TrxName());
            pstmt.setTimestamp(1, p_DateTrx_FromM);
            pstmt.setTimestamp(2, p_DateTrx_ToM);
            ResultSet rs = pstmt.executeQuery();
            int IDline = 0;
            boolean IDDoc = false;
            while (rs.next()) {
                ++IDline;
                X_DM_DocumentLine dl = new X_DM_DocumentLine(this.getCtx(), 0, this.get_TrxName());
                dl.setDM_Document_ID(dc.get_ID());
                dl.set_CustomColumn("RH_AdministrativeRequests_ID", rs.getInt(1));
                dl.setDescription(descL);
                dl.setAmt(new BigDecimal(0.0));
                dl.setIsActive(true);
                dl.save();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return "Resolucion Generada N\u00b0: " + dc.getDocumentNo();
    }
}

