/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CreateFieldAD
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int C_Order_ID = this.getRecord_ID();
        this.log.info("C_Order_ID=" + C_Order_ID);
        if (C_Order_ID == 0) {
            throw new IllegalArgumentException("Target C_Order_ID == 0");
        }
        MOrder order = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
        int cantIB = 0;
        String helpInfo = "";
        Timestamp dateOrder = order.getDateOrdered();
        Calendar datePO = Calendar.getInstance();
        datePO.setTime(dateOrder);
        int ahno = datePO.get(1);
        int mes = datePO.get(2);
        ++mes;
        MOrderLine[] lines = order.getLines(false, null);
        int i = 0;
        while (i < lines.length) {
            int tipoCuenta;
            MOrderLine line = new MOrderLine(this.getCtx(), lines[i].getC_OrderLine_ID(), this.get_TrxName());
            int CCosto = line.get_ValueAsInt("C_ProjectOFB_ID");
            BigDecimal qpresupuesto = new BigDecimal("0.0");
            BigDecimal qpresupuestoPM = new BigDecimal("0.0");
            BigDecimal qpresupuestoA = new BigDecimal("0.0");
            BigDecimal qpresupuestoPMA = new BigDecimal("0.0");
            if (line.getM_Product_ID() > 0) {
                MProduct prod = new MProduct(this.getCtx(), line.getM_Product_ID(), this.get_TrxName());
                MProductCategory catProd = new MProductCategory(this.getCtx(), prod.getM_Product_Category_ID(), this.get_TrxName());
                tipoCuenta = catProd.get_ValueAsInt("erpg_tipo_cuenta");
            } else if (line.getC_Charge_ID() > 0) {
                MCharge charge = new MCharge(this.getCtx(), line.getC_Charge_ID(), this.get_TrxName());
                tipoCuenta = charge.get_ValueAsInt("erpg_tipo_cuenta");
            } else {
                tipoCuenta = 0;
            }
            CPreparedStatement pstmt = null;
            String mysql = "select abs(qpresupuesto) as qpresupuesto, abs(qpresupuesto_prog_manual) qpresupuesto_prog_manual from erpg_programa_flujo_anual where erpg_tipo_cuenta = ? and c_projectofb_id = ? and extract(year from fmes_anio) = ? and extract(month from fmes_anio) = ? and isactive like 'Y'";
            try {
                pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
                pstmt.setInt(1, tipoCuenta);
                pstmt.setInt(2, CCosto);
                pstmt.setString(3, Integer.toString(ahno));
                pstmt.setInt(4, mes);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    qpresupuesto = rs.getBigDecimal(1) == null ? new BigDecimal("0.0") : rs.getBigDecimal(1);
                    qpresupuestoPM = rs.getBigDecimal(2) == null ? new BigDecimal("0.0") : rs.getBigDecimal(2);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            BigDecimal saldoMes = qpresupuestoPM.subtract(qpresupuesto);
            CPreparedStatement pstmtA = null;
            String mysqlA = "select abs(sum(qpresupuesto)) as qpresupuesto, abs(sum(qpresupuesto_prog_manual)) as qpresupuesto_prog_manual from erpg_programa_flujo_anual where erpg_tipo_cuenta =  ? and c_projectofb_id = ? and extract(year from fmes_anio) = ? and isactive like 'Y' ";
            try {
                pstmtA = DB.prepareStatement((String)mysqlA, (String)this.get_TrxName());
                pstmtA.setInt(1, tipoCuenta);
                pstmtA.setInt(2, CCosto);
                pstmtA.setString(3, Integer.toString(ahno));
                ResultSet rsA = pstmtA.executeQuery();
                if (rsA.next()) {
                    qpresupuestoA = rsA.getBigDecimal(1) == null ? new BigDecimal("0.0") : rsA.getBigDecimal(1);
                    qpresupuestoPMA = rsA.getBigDecimal(2) == null ? new BigDecimal("0.0") : rsA.getBigDecimal(2);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            BigDecimal saldoAnual = qpresupuestoPMA.subtract(qpresupuestoA);
            if (line.getLineNetAmt().compareTo(saldoMes) <= 0) {
                cantIB += 0;
                helpInfo = "Presupuesto Correcto - Presupuesto mes:" + qpresupuestoPM + " Disponible mes:" + saldoMes + " a Consumir:" + line.getLineNetAmt();
                line.set_CustomColumn("BudgetInfo", 1);
            } else if (line.getLineNetAmt().compareTo(saldoAnual) <= 0) {
                cantIB += 0;
                helpInfo = "Presupuesto mensual sobrepasado. Uso presupuesto anual - Presupuesto mes:" + qpresupuestoPM + " Disponible mes:" + saldoMes + " a Consumir:" + line.getLineNetAmt() + " Saldo anual:" + saldoAnual;
                line.set_CustomColumn("BudgetInfo", 2);
            } else {
                ++cantIB;
                helpInfo = "Presupuesto mensual y anual sobrepasado - Presupuesto mes:" + qpresupuestoPM + " Disponible mes:" + saldoMes + " a Consumir:" + line.getLineNetAmt() + " Saldo anual:" + saldoAnual;
                line.set_CustomColumn("BudgetInfo", 3);
            }
            line.set_CustomColumn("HelpBudget", helpInfo);
            line.save();
            ++i;
        }
        if (cantIB > 0) {
            order.set_CustomColumn("BudgetStatus", false);
        } else {
            order.set_CustomColumn("BudgetStatus", true);
        }
        order.save();
        return "";
    }
}

