/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.TimeUtil;

public class ModelPOINV
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelPOINV.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && !(order = (MOrder)((Object)po)).isSOTrx() && order.getC_DocType().getDocBaseType().equals("POO")) {
            MInvoice invoice = new MInvoice(order, 0, TimeUtil.getDay((long)0L));
            if (!invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (o)");
            }
            MOrderLine[] mOrderLineArray = order.getLines();
            int n = mOrderLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MOrderLine oline = mOrderLineArray[n2];
                MInvoiceLine line = new MInvoiceLine(invoice);
                line.setOrderLine(oline);
                line.setQtyInvoiced(oline.getQtyOrdered());
                line.setQtyEntered(oline.getQtyOrdered());
                line.setLine(oline.getLine());
                if (!line.save()) {
                    throw new IllegalStateException("Could not create Invoice Line (o)");
                }
                ++n2;
            }
            invoice.processIt("CO");
            invoice.save();
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

