/*
 * Decompiled with CFR 0.152.
 */
package org.metlife.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.X_C_CampaignActivities;
import org.compiere.model.X_C_CampaignFollow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateLeadMass
extends SvrProcess {
    private int p_ID_User = 0;
    private String p_Description = "";
    private String p_FinalStatus = "";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_User_ID")) {
                    this.p_ID_User = para[i].getParameterAsInt();
                } else if (name.equals("Description")) {
                    this.p_Description = (String)para[i].getParameter();
                } else if (name.equals("FinalStatus")) {
                    this.p_FinalStatus = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sql = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE IsUseUpdate = 'Y' and AD_UserRefUp_ID = " + Env.getAD_User_ID((Properties)this.getCtx());
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rs.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    X_C_CampaignActivities cAct = new X_C_CampaignActivities(this.getCtx(), 0, this.get_TrxName());
                    cAct.setC_CampaignFollow_ID(cFollow.get_ID());
                    cAct.setAD_Org_ID(cFollow.getAD_Org_ID());
                    cAct.set_CustomColumn("AD_User_ID", Env.getAD_User_ID((Properties)this.getCtx()));
                    cAct.setDescription("Lead Derivado");
                    GregorianCalendar cal = new GregorianCalendar();
                    String fecha = String.valueOf(Integer.toString(cal.get(5))) + "-" + Integer.toString(cal.get(2) + 1) + "-" + Integer.toString(cal.get(1));
                    if (this.p_Description != null) {
                        cAct.setDescription(String.valueOf(cAct.getDescription()) + ". Comentario:" + this.p_Description + ". Fecha:" + fecha);
                    } else {
                        cAct.setDescription(String.valueOf(cAct.getDescription()) + ". Fecha:" + fecha);
                    }
                    cAct.save();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        String sqlUpdate = "UPDATE C_CampaignFollow SET ";
        if (this.p_ID_User > 0) {
            sqlUpdate = String.valueOf(sqlUpdate) + " AD_User_ID = " + this.p_ID_User + ", ";
        }
        if (this.p_FinalStatus != null) {
            sqlUpdate = String.valueOf(sqlUpdate) + " FinalStatus = '" + this.p_FinalStatus + "', ";
        }
        sqlUpdate = String.valueOf(sqlUpdate) + " IsUseUpdate = 'N', AD_UserRefUp_ID = null WHERE IsUseUpdate = 'Y' and AD_UserRefUp_ID = " + Env.getAD_User_ID((Properties)this.getCtx());
        int cant = DB.executeUpdate((String)sqlUpdate, (String)this.get_TrxName());
        return "Se han actualizado " + cant + " registros";
    }
}

