/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CreateOCFromRequisitionDPP
extends SvrProcess {
    private int p_M_Requisition_ID = 0;
    private String p_DocumentNo;
    private int p_C_BPartner_ID = 0;
    private int p_C_DocType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Requisition_ID")) {
                    this.p_M_Requisition_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocumentNo")) {
                    this.p_DocumentNo = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MRequisition req = new MRequisition(this.getCtx(), this.p_M_Requisition_ID, this.get_TrxName());
        MOrder ord = new MOrder(this.getCtx(), 0, this.get_TrxName());
        if (this.p_C_BPartner_ID <= 0) {
            throw new AdempiereException("ERROR: No ha ingresado al proveedor");
        }
        if (this.p_DocumentNo == null) {
            throw new AdempiereException("ERROR: No ha ingresado el correlativo");
        }
        if (this.p_C_DocType_ID <= 0) {
            throw new AdempiereException("ERROR: No ha ingresado el tipo de documento");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
        ord.setC_BPartner_ID(bp.get_ID());
        ord.setDocStatus("DR");
        ord.setAD_Org_ID(req.getAD_Org_ID());
        ord.setDocumentNo(this.p_DocumentNo);
        ord.setDateOrdered(req.getDateDoc());
        ord.setDateAcct(req.getDateDoc());
        ord.setDatePromised(req.getDateDoc());
        ord.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        ord.setIsSOTrx(false);
        ord.setM_Warehouse_ID(req.getM_Warehouse_ID());
        ord.setM_PriceList_ID(req.getM_PriceList_ID());
        ord.setDescription(req.getDescription());
        ord.setSalesRep_ID(req.get_ValueAsInt("AD_User_ID"));
        ord.setDocAction("CO");
        ord.saveEx();
        String sql = "SELECT m_requisitionline_id from m_requisitionline where  isactive='Y'  AND m_Requisition_id = " + req.get_ID();
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            MRequisitionLine reql = new MRequisitionLine(this.getCtx(), rs.getInt("m_requisitionline_id"), this.get_TrxName());
            MOrderLine ordl = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
            if (reql.getM_Product_ID() > 0) {
                ordl.setM_Product_ID(reql.getM_Product_ID());
                ordl.setM_AttributeSetInstance_ID(reql.getM_AttributeSetInstance_ID());
                ordl.setPriceActual(reql.getPriceActual());
                ordl.setPriceEntered(reql.getPriceActual());
            } else {
                ordl.setC_Charge_ID(reql.getC_Charge_ID());
                ordl.setPriceActual(reql.getPriceActual());
                ordl.setPriceEntered(reql.getPriceActual());
            }
            if (reql.getDescription() != null) {
                ordl.setDescription(reql.getDescription());
            }
            ordl.setQtyEntered(reql.getQty());
            ordl.setQtyOrdered(reql.getQty());
            ordl.setAD_Org_ID(reql.getAD_Org_ID());
            this.log.config("loc " + ord.getC_BPartner_Location_ID());
            ordl.setC_Order_ID(ord.getC_Order_ID());
            int tax = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT max(c_tax_id) from c_tax where isdefault='Y'");
            if (tax > 0) {
                ordl.setC_Tax_ID(tax);
            }
            ordl.saveEx();
        }
        return "Orden Generada: " + ord.getDocumentNo();
    }
}

