/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModDPPUpdateAssetInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPUpdateAssetInvoice.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MDocType docType;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID && !(inv = (MInvoice)((Object)po)).isSOTrx() && (docType = new MDocType(po.getCtx(), inv.getC_DocTypeTarget_ID(), po.get_TrxName())).get_ValueAsString("Lot") != null && docType.get_ValueAsString("Lot").compareTo("SIN") != 0) {
            log.config("CONFIGURA: " + docType.get_ValueAsString("Lot") + "  :CONFIGURA");
            MInvoiceLine[] lines = inv.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                if (line.getA_Asset_ID() > 0) {
                    MAsset asset = new MAsset(po.getCtx(), line.getA_Asset_ID());
                    asset.setLot(docType.get_ValueAsString("Lot"));
                    asset.save();
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

