/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import java.math.BigDecimal;
import org.compiere.FA.CreateAssetForecast;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Addition;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModDPPUpdateAssetAmt
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPUpdateAssetAmt.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            MInvoiceLine line = (MInvoiceLine)po;
            MInvoice inv = new MInvoice(po.getCtx(), line.getC_Invoice_ID(), po.get_TrxName());
            MCurrency curr = new MCurrency(po.getCtx(), inv.getC_Currency_ID(), po.get_TrxName());
            if (!inv.isSOTrx()) {
                line.setPrice(line.getPriceEntered().setScale(curr.getStdPrecision(), 6));
                line.setTaxAmt(line.getTaxAmt().setScale(curr.getStdPrecision(), 6));
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)((Object)po);
            MCurrency curr = new MCurrency(po.getCtx(), inv.getC_Currency_ID(), po.get_TrxName());
            if (!inv.isSOTrx()) {
                MInvoiceLine[] lines = inv.getLines(false);
                int i = 0;
                while (i < lines.length) {
                    MInvoiceLine line = lines[i];
                    if (line.getA_Asset_ID() > 0) {
                        MAsset asset;
                        if (line.get_ValueAsInt("A_Asset_Group_ID") > 0 && line.get_ValueAsString("A_CapvsExp").equals("Cap")) {
                            asset = new MAsset(po.getCtx(), line.getA_Asset_ID());
                            BigDecimal tax = Env.ZERO;
                            if (line.getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                                tax = line.getTaxAmt();
                            }
                            int acct_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Asset_Acct_ID from A_Asset_Acct where A_Asset_ID=" + asset.getA_Asset_ID()));
                            MAssetAcct assetacct = new MAssetAcct(po.getCtx(), acct_id, po.get_TrxName());
                            BigDecimal amt = line.getLineNetAmt().add(tax).divide(line.getQtyEntered(), 6);
                            amt = amt.setScale(curr.getStdPrecision(), 6);
                            log.config("MAssetChange change");
                            int change_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Asset_Change_ID from A_Asset_Change where A_Asset_ID=" + asset.getA_Asset_ID()));
                            MAssetChange change = new MAssetChange(po.getCtx(), change_id, po.get_TrxName());
                            change.setAssetValueAmt(amt);
                            change.save();
                            log.config("X_A_Depreciation_Workfile");
                            int Workfile_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Depreciation_Workfile_ID from A_Depreciation_Workfile where A_Asset_ID=" + asset.getA_Asset_ID()));
                            X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(po.getCtx(), Workfile_id, po.get_TrxName());
                            assetwk.setA_Asset_Cost(amt);
                            assetwk.save();
                            log.config("X_A_Asset_Addition");
                            int Addition_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Asset_Addition_ID from A_Asset_Addition where A_Asset_ID=" + asset.getA_Asset_ID()));
                            if (Addition_id > 0) {
                                X_A_Asset_Addition assetadd = new X_A_Asset_Addition(po.getCtx(), Addition_id, po.get_TrxName());
                                assetadd.setAssetValueAmt(amt);
                                assetadd.save();
                            }
                            DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)po.get_TrxName());
                            CreateAssetForecast.createForecast(asset, change, assetacct, po.get_TrxName());
                        }
                        if (line.getA_Asset_ID() > 0 && line.get_ValueAsString("A_CapvsExp").equals("Exp")) {
                            asset = new MAsset(po.getCtx(), line.getA_Asset_ID(), po.get_TrxName());
                            BigDecimal monto = line.getTaxAmt();
                            monto = monto.setScale(curr.getStdPrecision(), 6);
                            int change_id = DB.getSQLValue((String)po.get_TableName(), (String)("select A_Asset_Change_ID from A_Asset_Change where A_Asset_ID=" + asset.getA_Asset_ID()));
                            MAssetChange change = new MAssetChange(po.getCtx(), change_id, po.get_TrxName());
                            change.setAssetValueAmt(change.getAssetValueAmt().add(monto));
                            change.save();
                            int Workfile_id = DB.getSQLValue((String)po.get_TableName(), (String)("select A_Depreciation_Workfile_ID from A_Depreciation_Workfile where A_Asset_ID=" + asset.getA_Asset_ID()));
                            X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(po.getCtx(), Workfile_id, po.get_TrxName());
                            assetwk.setA_Asset_Cost(assetwk.getA_Asset_Cost().add(monto));
                            assetwk.save();
                            int Addition_id = DB.getSQLValue((String)po.get_TableName(), (String)("select MAX(A_Asset_Addition_ID) from A_Asset_Addition where A_Asset_ID=" + asset.getA_Asset_ID()), (String)po.get_TrxName());
                            X_A_Asset_Addition assetadd = new X_A_Asset_Addition(po.getCtx(), Addition_id, po.get_TrxName());
                            assetadd.setAssetValueAmt(assetadd.getAssetValueAmt().add(monto));
                            assetadd.save();
                            int acct_id = DB.getSQLValue((String)po.get_TableName(), (String)("select A_Asset_Acct_ID from A_Asset_Acct where A_Asset_ID=" + asset.getA_Asset_ID()), (String)po.get_TrxName());
                            MAssetAcct assetacct = new MAssetAcct(po.getCtx(), acct_id, po.get_TrxName());
                            DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)po.get_TrxName());
                            CreateAssetForecast.createForecast(asset, change, assetacct, po.get_TrxName());
                        }
                    }
                    ++i;
                }
            }
            BigDecimal amtSumLine = new BigDecimal("0.0");
            BigDecimal amtSumLineNA = new BigDecimal("0.0");
            String sqlSum = "SELECT SUM(LineTotalAmt) FROM C_InvoiceLine WHERE A_Asset_ID IS NOT NULL AND C_Invoice_ID = " + inv.get_ID();
            amtSumLine = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlSum, (Object[])new Object[0]);
            String sqlSumNA = "SELECT SUM(LineTotalAmt) FROM C_InvoiceLine WHERE A_Asset_ID IS NULL AND C_Invoice_ID = " + inv.get_ID();
            amtSumLineNA = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlSumNA, (Object[])new Object[0]);
            if (amtSumLine == null) {
                amtSumLine = Env.ZERO;
            }
            if (amtSumLineNA == null) {
                amtSumLineNA = Env.ZERO;
            }
            if (amtSumLine.add(amtSumLineNA).compareTo(inv.getGrandTotal()) != 0) {
                int ID_LastAsset = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(A_Asset_ID)  FROM C_InvoiceLine WHERE A_Asset_ID IS NOT NULL AND C_Invoice_ID = " + inv.get_ID()));
                BigDecimal diffCurrency = inv.getGrandTotal().subtract(amtSumLine.add(amtSumLineNA));
                MAsset asset = new MAsset(po.getCtx(), ID_LastAsset);
                int acct_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Asset_Acct_ID from A_Asset_Acct where A_Asset_ID=" + asset.getA_Asset_ID()));
                MAssetAcct assetacct = new MAssetAcct(po.getCtx(), acct_id, po.get_TrxName());
                log.config("MAssetChange change");
                int change_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Asset_Change_ID from A_Asset_Change where A_Asset_ID=" + asset.getA_Asset_ID()));
                MAssetChange change = new MAssetChange(po.getCtx(), change_id, po.get_TrxName());
                change.setAssetValueAmt(change.getAssetValueAmt().add(diffCurrency));
                change.save();
                log.config("X_A_Depreciation_Workfile");
                int Workfile_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Depreciation_Workfile_ID from A_Depreciation_Workfile where A_Asset_ID=" + asset.getA_Asset_ID()));
                X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(po.getCtx(), Workfile_id, po.get_TrxName());
                assetwk.setA_Asset_Cost(assetwk.getA_Asset_Cost().add(diffCurrency));
                assetwk.save();
                log.config("X_A_Asset_Addition");
                int Addition_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select A_Asset_Addition_ID from A_Asset_Addition where A_Asset_ID=" + asset.getA_Asset_ID()));
                if (Addition_id > 0) {
                    X_A_Asset_Addition assetadd = new X_A_Asset_Addition(po.getCtx(), Addition_id, po.get_TrxName());
                    assetadd.setAssetValueAmt(assetadd.getAssetValueAmt().add(diffCurrency));
                    assetadd.save();
                }
                DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)po.get_TrxName());
                CreateAssetForecast.createForecast(asset, change, assetacct, po.get_TrxName());
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

