/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.compiere.model.ModelValidationEngine;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.IniDialog;
import org.compiere.util.Language;
import org.compiere.util.SecureEngine;

public final class Ini
implements Serializable {
    private static final long serialVersionUID = 3666529972922769528L;
    public static final String ADEMPIERE_PROPERTY_FILE = "Adempiere.properties";
    public static final String P_UID = "ApplicationUserID";
    private static final String DEFAULT_UID = "GardenAdmin";
    public static final String P_PWD = "ApplicationPassword";
    private static final String DEFAULT_PWD = "GardenAdmin";
    public static final String P_STORE_PWD = "StorePassword";
    private static final boolean DEFAULT_STORE_PWD = true;
    public static final String P_TRACELEVEL = "TraceLevel";
    private static final String DEFAULT_TRACELEVEL = "WARNING";
    public static final String P_TRACEFILE = "TraceFile";
    private static final boolean DEFAULT_TRACEFILE = false;
    public static final String P_LANGUAGE = "Language";
    private static final String DEFAULT_LANGUAGE = Language.getName(String.valueOf(System.getProperty("user.language")) + "_" + System.getProperty("user.country"));
    public static final String P_INI = "FileNameINI";
    private static final String DEFAULT_INI = "";
    public static final String P_CONNECTION = "Connection";
    private static final String DEFAULT_CONNECTION = "";
    public static final String P_CONTEXT = "DataSource";
    private static final String DEFAULT_CONTEXT = "java:adempiereDB";
    public static final String P_UI_LOOK = "UILookFeel";
    private static final String DEFAULT_UI_LOOK = "Adempiere";
    private static final String DEFAULT_UI_THEME = "Adempiere Theme";
    public static final String P_UI_THEME = "UITheme";
    public static final String P_A_COMMIT = "AutoCommit";
    private static final boolean DEFAULT_A_COMMIT = true;
    public static final String P_A_LOGIN = "AutoLogin";
    private static final boolean DEFAULT_A_LOGIN = false;
    public static final String P_A_NEW = "AutoNew";
    private static final boolean DEFAULT_A_NEW = false;
    public static final String P_ADEMPIERESYS = "AdempiereSys";
    private static final boolean DEFAULT_ADEMPIERESYS = false;
    public static final String P_LOGMIGRATIONSCRIPT = "LogMigrationScript";
    private static final boolean DEFAULT_LOGMIGRATIONSCRIPT = false;
    public static final String P_SHOW_ACCT = "ShowAcct";
    private static final boolean DEFAULT_SHOW_ACCT = true;
    public static final String P_SHOW_ADVANCED = "ShowAdvanced";
    private static final boolean DEFAULT_SHOW_ADVANCED = true;
    public static final String P_SHOW_TRL = "ShowTrl";
    private static final boolean DEFAULT_SHOW_TRL = false;
    public static final String P_CACHE_WINDOW = "CacheWindow";
    private static final boolean DEFAULT_CACHE_WINDOW = false;
    public static final String P_TEMP_DIR = "TempDir";
    private static final String DEFAULT_TEMP_DIR = "";
    public static final String P_ROLE = "Role";
    private static final String DEFAULT_ROLE = "";
    public static final String P_CLIENT = "Client";
    private static final String DEFAULT_CLIENT = "";
    public static final String P_ORG = "Organization";
    private static final String DEFAULT_ORG = "";
    public static final String P_PRINTER = "Printer";
    private static final String DEFAULT_PRINTER = "";
    public static final String P_WAREHOUSE = "Warehouse";
    private static final String DEFAULT_WAREHOUSE = "";
    public static final String P_TODAY = "CDate";
    private static final Timestamp DEFAULT_TODAY = new Timestamp(System.currentTimeMillis());
    public static final String P_PRINTPREVIEW = "PrintPreview";
    private static final boolean DEFAULT_PRINTPREVIEW = true;
    public static final String P_VALIDATE_CONNECTION_ON_STARTUP = "ValidateConnectionOnStartup";
    private static final boolean DEFAULT_VALIDATE_CONNECTION_ON_STARTUP = false;
    public static final String P_SINGLE_INSTANCE_PER_WINDOW = "SingleInstancePerWindow";
    public static final boolean DEFAULT_SINGLE_INSTANCE_PER_WINDOW = false;
    public static final String P_OPEN_WINDOW_MAXIMIZED = "OpenWindowMaximized";
    public static final boolean DEFAULT_OPEN_WINDOW_MAXIMIZED = false;
    private static final String P_WARNING = "Warning";
    private static final String DEFAULT_WARNING = "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.";
    private static final String P_WARNING_de = "WarningD";
    private static final String DEFAULT_WARNING_de = "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben.";
    public static final String P_CHARSET = "Charset";
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    public static final String P_LOAD_TAB_META_DATA_BG = "LoadTabMetaDataBackground";
    public static final String DEFAULT_LOAD_TAB_META_DATA_BG = "N";
    private static final String[] PROPERTIES = new String[]{"ApplicationUserID", "ApplicationPassword", "TraceLevel", "TraceFile", "Language", "FileNameINI", "Connection", "StorePassword", "UILookFeel", "UITheme", "AutoCommit", "AutoLogin", "AutoNew", "AdempiereSys", "LogMigrationScript", "ShowAcct", "ShowTrl", "ShowAdvanced", "CacheWindow", "DataSource", "TempDir", "Role", "Client", "Organization", "Printer", "Warehouse", "CDate", "PrintPreview", "ValidateConnectionOnStartup", "SingleInstancePerWindow", "OpenWindowMaximized", "Warning", "WarningD", "Charset", "LoadTabMetaDataBackground"};
    private static final String[] VALUES = new String[]{"GardenAdmin", "GardenAdmin", "WARNING", "N", DEFAULT_LANGUAGE, "", "", "Y", "Adempiere", "Adempiere Theme", "Y", "N", "N", "N", "N", "Y", "N", "Y", "N", "java:adempiereDB", "", "", "", "", "", "", DEFAULT_TODAY.toString(), "Y", "N", "N", "N", "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.", "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben.", DEFAULT_CHARSET, "N"};
    private static Properties s_prop = new Properties();
    private static String s_propertyFileName = null;
    private static Logger log = null;
    public static final String ENV_PREFIX = "env.";
    public static final String ADEMPIERE_HOME = "ADEMPIERE_HOME";
    private static boolean s_client = true;
    private static boolean s_loaded = false;
    private static boolean s_license_dialog = true;

    public static void saveProperties(boolean tryUserHome) {
        if (Ini.isClient() && DB.isConnected()) {
            ModelValidationEngine.get().beforeSaveProperties();
        }
        if (Ini.isWebStartClient()) {
            Ini.saveWebStartProperties();
        } else {
            String fileName = Ini.getFileName(tryUserHome);
            FileOutputStream fos = null;
            try {
                File f = new File(fileName);
                f.getParentFile().mkdirs();
                fos = new FileOutputStream(f);
                s_prop.store(fos, DEFAULT_UI_LOOK);
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot save Properties to " + fileName + " - " + e.toString());
                return;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Cannot save Properties to " + fileName + " - " + t.toString());
                return;
            }
            log.finer(fileName);
        }
    }

    public static void loadProperties(boolean reload) {
        if (reload || s_prop.size() == 0) {
            if (Ini.isWebStartClient()) {
                Ini.loadWebStartProperties();
            } else {
                Ini.loadProperties(Ini.getFileName(s_client));
            }
        }
    }

    private static boolean loadWebStartProperties() {
        PersistenceService ps;
        boolean loadOK = true;
        boolean firstTime = false;
        s_prop = new Properties();
        try {
            ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
        }
        catch (UnavailableServiceException e) {
            Object ps2 = null;
            log.log(Level.SEVERE, e.toString());
            return false;
        }
        FileContents fc = null;
        try {
            fc = ps.get(Ini.getCodeBase());
        }
        catch (MalformedURLException e) {
            log.log(Level.SEVERE, e.toString());
            return false;
        }
        catch (FileNotFoundException e) {
            try {
                ps.create(Ini.getCodeBase(), 16384L);
                ps.setTag(Ini.getCodeBase(), 2);
                fc = ps.get(Ini.getCodeBase());
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.toString());
            return false;
        }
        try {
            InputStream is = fc.getInputStream();
            s_prop.load(is);
            is.close();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.toString());
            loadOK = false;
        }
        if (!loadOK || s_prop.getProperty(P_TODAY, "").equals("")) {
            firstTime = true;
            if (Ini.isShowLicenseDialog() && !IniDialog.accept()) {
                System.exit(-1);
            }
        }
        Ini.checkProperties();
        if (!loadOK || firstTime) {
            Ini.saveWebStartProperties();
        }
        s_loaded = true;
        s_propertyFileName = Ini.getCodeBase().toString();
        return firstTime;
    }

    private static void saveWebStartProperties() {
        PersistenceService ps;
        try {
            ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
        }
        catch (UnavailableServiceException e) {
            Object ps2 = null;
            log.log(Level.SEVERE, e.toString());
            return;
        }
        try {
            OutputStream os = ps.get(Ini.getCodeBase()).getOutputStream(true);
            s_prop.store(os, DEFAULT_UI_LOOK);
            os.flush();
            os.close();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Cannot save Properties to " + Ini.getCodeBase() + " - " + t.toString());
            return;
        }
    }

    public static URL getCodeBase() {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL url = bs.getCodeBase();
            return url;
        }
        catch (UnavailableServiceException ue) {
            return null;
        }
    }

    public static boolean isWebStartClient() {
        return Ini.getCodeBase() != null;
    }

    public static boolean loadProperties(String filename) {
        boolean loadOK = true;
        boolean firstTime = false;
        s_prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            s_prop.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.warning(String.valueOf(filename) + " not found");
            loadOK = false;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.valueOf(filename) + " - " + e.toString());
            loadOK = false;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, String.valueOf(filename) + " - " + t.toString());
            loadOK = false;
        }
        if (!loadOK || s_prop.getProperty(P_TODAY, "").equals("")) {
            log.config(filename);
            firstTime = true;
            if (Ini.isShowLicenseDialog() && !IniDialog.accept()) {
                System.exit(-1);
            }
        }
        Ini.checkProperties();
        if (!loadOK || firstTime) {
            Ini.saveProperties(true);
        }
        s_loaded = true;
        log.info(String.valueOf(filename) + " #" + s_prop.size());
        s_propertyFileName = filename;
        return firstTime;
    }

    private static void checkProperties() {
        int i = 0;
        while (i < PROPERTIES.length) {
            if (VALUES[i].length() > 0) {
                Ini.checkProperty(PROPERTIES[i], VALUES[i]);
            }
            ++i;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            tempDir = Ini.getAdempiereHome();
        }
        if (tempDir == null) {
            tempDir = "";
        }
        Ini.checkProperty(P_TEMP_DIR, tempDir);
    }

    public static void deletePropertyFile() {
        String fileName = Ini.getFileName(s_client);
        File file = new File(fileName);
        if (file.exists()) {
            try {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                s_prop = new Properties();
                log.config(fileName);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Cannot delete Property file", e);
            }
        }
    }

    private static String checkProperty(String key, String defaultValue) {
        String result = null;
        result = key.equals(P_WARNING) || key.equals(P_WARNING_de) ? defaultValue : (!Ini.isClient() ? s_prop.getProperty(key, "xyz" + defaultValue) : s_prop.getProperty(key, SecureEngine.encrypt((String)defaultValue)));
        s_prop.setProperty(key, result);
        return result;
    }

    private static String getFileName(boolean tryUserHome) {
        String home;
        if (System.getProperty("PropertyFile") != null) {
            return System.getProperty("PropertyFile");
        }
        String base = null;
        if (tryUserHome && s_client) {
            base = System.getProperty("user.home");
        }
        if (!(s_client && base != null && base.length() != 0 || (home = Ini.getAdempiereHome()) == null)) {
            base = home;
        }
        if (base != null && !base.endsWith(File.separator)) {
            base = String.valueOf(base) + File.separator;
        }
        if (base == null) {
            base = "";
        }
        return String.valueOf(base) + ADEMPIERE_PROPERTY_FILE;
    }

    public static void setProperty(String key, String value) {
        if (s_prop == null) {
            s_prop = new Properties();
        }
        if (key.equals(P_WARNING) || key.equals(P_WARNING_de)) {
            s_prop.setProperty(key, value);
        } else if (!Ini.isClient()) {
            s_prop.setProperty(key, "xyz" + value);
        } else if (value == null) {
            s_prop.setProperty(key, "");
        } else {
            String eValue = SecureEngine.encrypt((String)value);
            if (eValue == null) {
                s_prop.setProperty(key, "");
            } else {
                s_prop.setProperty(key, eValue);
            }
        }
    }

    public static void setProperty(String key, boolean value) {
        Ini.setProperty(key, value ? "Y" : DEFAULT_LOAD_TAB_META_DATA_BG);
    }

    public static void setProperty(String key, int value) {
        Ini.setProperty(key, String.valueOf(value));
    }

    public static String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String retStr = s_prop.getProperty(key, "");
        if (retStr == null || retStr.length() == 0) {
            return "";
        }
        String value = SecureEngine.decrypt((String)retStr);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static boolean isPropertyBool(String key) {
        return Ini.getProperty(key).equals("Y");
    }

    public static boolean isCacheWindow() {
        return Ini.getProperty(P_CACHE_WINDOW).equals("Y");
    }

    public static Properties getProperties() {
        return s_prop;
    }

    public static String getAsString() {
        StringBuffer buf = new StringBuffer("Ini[");
        Enumeration<Object> e = s_prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buf.append(key).append("=");
            buf.append(Ini.getProperty(key)).append("; ");
        }
        buf.append("]");
        return buf.toString();
    }

    public static boolean isClient() {
        return s_client;
    }

    public static void setClient(boolean client) {
        if (log != null) {
            return;
        }
        s_client = client;
        CLogMgt.initialize((boolean)client);
        log = Logger.getLogger(Ini.class.getName());
    }

    public static void setShowLicenseDialog(boolean b) {
        s_license_dialog = b;
    }

    public static boolean isShowLicenseDialog() {
        return s_license_dialog;
    }

    public static boolean isLoaded() {
        return s_loaded;
    }

    public static String getAdempiereHome() {
        String env = System.getProperty("env.ADEMPIERE_HOME");
        if (env == null) {
            env = System.getProperty(ADEMPIERE_HOME);
        }
        if (env == null && !Ini.isClient()) {
            try {
                InitialContext context = new InitialContext();
                env = (String)context.lookup("java:comp/env/ADEMPIERE_HOME");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (env == null || "".equals(env)) {
            env = String.valueOf(File.separator) + DEFAULT_UI_LOOK;
        }
        return env;
    }

    public static void setAdempiereHome(String AdempiereHome) {
        if (AdempiereHome != null && AdempiereHome.length() > 0) {
            System.setProperty(ADEMPIERE_HOME, AdempiereHome);
        }
    }

    public static String findAdempiereHome() {
        String ch = Ini.getAdempiereHome();
        if (ch != null) {
            return ch;
        }
        File[] roots = File.listRoots();
        int i = 0;
        while (i < roots.length) {
            File[] subs;
            if (!roots[i].getAbsolutePath().startsWith("A:") && (subs = roots[i].listFiles()) != null) {
                int j = 0;
                while (j < subs.length) {
                    String libDir;
                    File lib;
                    String fileName;
                    if (subs[j].isDirectory() && (fileName = subs[j].getAbsolutePath()).indexOf(DEFAULT_UI_LOOK) != -1 && (lib = new File(libDir = String.valueOf(fileName) + File.separator + "lib")).exists() && lib.isDirectory()) {
                        return fileName;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ch;
    }

    public static Dimension getWindowDimension(int AD_Window_ID) {
        String key = "WindowDim" + AD_Window_ID;
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(124);
        if (index == -1) {
            return null;
        }
        try {
            String w = value.substring(0, index);
            String h = value.substring(index + 1);
            return new Dimension(Integer.parseInt(w), Integer.parseInt(h));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setWindowDimension(int AD_Window_ID, Dimension windowDimension) {
        String key = "WindowDim" + AD_Window_ID;
        if (windowDimension != null) {
            String value = String.valueOf(windowDimension.width) + "|" + windowDimension.height;
            s_prop.put(key, value);
        } else {
            s_prop.remove(key);
        }
    }

    public static Point getWindowLocation(int AD_Window_ID) {
        String key = "WindowLoc" + AD_Window_ID;
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(124);
        if (index == -1) {
            return null;
        }
        try {
            String x = value.substring(0, index);
            String y = value.substring(index + 1);
            return new Point(Integer.parseInt(x), Integer.parseInt(y));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setWindowLocation(int AD_Window_ID, Point windowLocation) {
        String key = "WindowLoc" + AD_Window_ID;
        if (windowLocation != null) {
            String value = String.valueOf(windowLocation.x) + "|" + windowLocation.y;
            s_prop.put(key, value);
        } else {
            s_prop.remove(key);
        }
    }

    public static int getDividerLocation() {
        String key = "Divider";
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void setDividerLocation(int dividerLocation) {
        String key = "Divider";
        String value = String.valueOf(dividerLocation);
        s_prop.put(key, value);
    }

    public static Charset[] getAvailableCharsets() {
        Collection<Charset> col = Charset.availableCharsets().values();
        Charset[] arr = new Charset[col.size()];
        col.toArray(arr);
        return arr;
    }

    public static Charset getCharset() {
        String charsetName = Ini.getProperty(P_CHARSET);
        if (charsetName == null || charsetName.length() == 0) {
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception exception) {
            return Charset.defaultCharset();
        }
    }

    public static String getPropertyFileName() {
        return s_propertyFileName;
    }
}

