/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MLocator;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateTrxs
extends SvrProcess {
    private Properties m_ctx;
    private int p_Product_ID = 0;
    protected static final int CMINUS_CO = 1;
    protected static final int CMINUS_VO = 3;
    protected static final int CMINUS_RE = 2;
    protected static final int VPLUS_CO = 4;
    protected static final int VPLUS_VO = 6;
    protected static final int VPLUS_RE = 5;
    protected static final int UPLUS_RE = 8;
    protected static final int UMINUS_CO = 7;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_Product_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        int fixes = 0;
        int errors = 0;
        String mysql = "select * from OFB_Det_Transaction where 1=1 ";
        if (this.p_Product_ID > 0) {
            mysql = String.valueOf(mysql) + " and M_Product_ID=?";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            if (this.p_Product_ID > 0) {
                pstmt.setInt(1, this.p_Product_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            BigDecimal qty = Env.ZERO;
            while (rs.next()) {
                BigDecimal QtyMA;
                MInventoryLineMA ma;
                MInventoryLine line;
                MTransaction mtrx;
                MTransaction[] trans;
                if (rs.getInt("M_InoutLine_ID") > 0) {
                    trans = this.getTransactions(rs.getInt("M_InoutLine_ID"), 0, 0, rs.getInt("M_Product_ID"));
                    int i = 0;
                    while (i < trans.length) {
                        trans[i].deleteEx(true);
                        ++i;
                    }
                    MInOutLine sLine = new MInOutLine(this.m_ctx, rs.getInt("M_InoutLine_ID"), this.get_TrxName());
                    mtrx = null;
                    boolean created = false;
                    if (sLine.getM_AttributeSetInstance_ID() == 0) {
                        MInOutLineMA[] mas = MInOutLineMA.get(this.getCtx(), sLine.getM_InOutLine_ID(), this.get_TrxName());
                        int j = 0;
                        while (j < mas.length) {
                            MInOutLineMA ma2 = mas[j];
                            BigDecimal QtyMA2 = ma2.getMovementQty();
                            if (rs.getString("MovementType").charAt(1) == '-') {
                                QtyMA2 = QtyMA2.negate();
                            }
                            mtrx = new MTransaction(this.getCtx(), sLine.getAD_Org_ID(), rs.getString("MovementType"), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), ma2.getM_AttributeSetInstance_ID(), QtyMA2, sLine.getParent().getMovementDate(), this.get_TrxName());
                            mtrx.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                            if (!mtrx.save()) {
                                ++errors;
                            } else {
                                ++fixes;
                            }
                            created = true;
                            ++j;
                        }
                    }
                    if (!created) {
                        BigDecimal Qty = sLine.getMovementQty();
                        if (rs.getString("MovementType").charAt(1) == '-') {
                            Qty = Qty.negate();
                        }
                        mtrx = new MTransaction(this.getCtx(), sLine.getAD_Org_ID(), rs.getString("MovementType"), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), Qty, sLine.getParent().getMovementDate(), this.get_TrxName());
                        mtrx.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                        if (!mtrx.save()) {
                            ++errors;
                        } else {
                            ++fixes;
                        }
                    }
                }
                if (rs.getInt("m_inventoryline_id") > 0 && (rs.getInt("tipo") == 7 || rs.getInt("tipo") == 8)) {
                    trans = this.getTransactions(0, 0, rs.getInt("m_inventoryline_id"), rs.getInt("M_Product_ID"));
                    int i = 0;
                    while (i < trans.length) {
                        trans[i].deleteEx(true);
                        ++i;
                    }
                    line = new MInventoryLine(this.m_ctx, rs.getInt("m_inventoryline_id"), this.get_TrxName());
                    mtrx = null;
                    String movementType = line.getQtyInternalUse().signum() > 0 ? "I-" : "I+";
                    boolean created = false;
                    if (line.getM_AttributeSetInstance_ID() == 0) {
                        MInventoryLineMA[] mas = MInventoryLineMA.get((Properties)this.getCtx(), (int)line.getM_InventoryLine_ID(), (String)this.get_TrxName());
                        int j = 0;
                        while (j < mas.length) {
                            ma = mas[j];
                            QtyMA = ma.getMovementQty().abs();
                            if (movementType.charAt(1) == '-') {
                                QtyMA = QtyMA.negate();
                            }
                            mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), movementType, line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA, line.getParent().getMovementDate(), this.get_TrxName());
                            mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                            if (!mtrx.save()) {
                                ++errors;
                            } else {
                                ++fixes;
                            }
                            created = true;
                            ++j;
                        }
                    }
                    if (!created) {
                        BigDecimal Qty = line.getQtyInternalUse().abs();
                        if (movementType.charAt(1) == '-') {
                            Qty = Qty.negate();
                        }
                        mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), movementType, line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), Qty, line.getParent().getMovementDate(), this.get_TrxName());
                        mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                        if (!mtrx.save()) {
                            ++errors;
                        } else {
                            ++fixes;
                        }
                    }
                }
                if (rs.getInt("m_inventoryline_id") <= 0 || rs.getInt("tipo") != 9 && rs.getInt("tipo") != 10) continue;
                trans = this.getTransactions(0, 0, rs.getInt("m_inventoryline_id"), rs.getInt("M_Product_ID"));
                int i = 0;
                while (i < trans.length) {
                    trans[i].deleteEx(true);
                    ++i;
                }
                line = new MInventoryLine(this.m_ctx, rs.getInt("m_inventoryline_id"), this.get_TrxName());
                mtrx = null;
                String movementType = line.getQtyCount().compareTo(line.getQtyBook()) >= 0 ? "I+" : "I-";
                boolean created = false;
                if (line.getM_AttributeSetInstance_ID() == 0) {
                    MInventoryLineMA[] mas = MInventoryLineMA.get((Properties)this.getCtx(), (int)line.getM_InventoryLine_ID(), (String)this.get_TrxName());
                    int j = 0;
                    while (j < mas.length) {
                        ma = mas[j];
                        QtyMA = ma.getMovementQty().abs();
                        if (movementType.charAt(1) == '-') {
                            QtyMA = QtyMA.negate();
                        }
                        mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), movementType, line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA, line.getParent().getMovementDate(), this.get_TrxName());
                        mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                        if (!mtrx.save()) {
                            ++errors;
                        } else {
                            ++fixes;
                        }
                        created = true;
                        ++j;
                    }
                }
                if (created) continue;
                BigDecimal Qty = line.getQtyCount().subtract(line.getQtyBook());
                mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), movementType, line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), Qty, line.getParent().getMovementDate(), this.get_TrxName());
                mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                if (!mtrx.save()) {
                    ++errors;
                    continue;
                }
                ++fixes;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        pstmt = null;
        try {
            String sql = "select m_product_id,m_locator_id,M_ATTRIBUTESETINSTANCE_ID,qtyonhand,trxqty from ( select s.m_product_id, s.m_locator_id,s.M_ATTRIBUTESETINSTANCE_ID, sum(s.qtyonhand) as qtyonhand, (select sum(t.movementqty) from m_transaction t where t.m_product_id=s.m_product_id and t.m_locator_id=s.m_locator_id and t.M_ATTRIBUTESETINSTANCE_ID=s.M_ATTRIBUTESETINSTANCE_ID) as trxqty from m_storage s group by s.m_product_id, s.m_locator_id,M_ATTRIBUTESETINSTANCE_ID) where qtyonhand<>trxqty ";
            if (this.p_Product_ID > 0) {
                sql = String.valueOf(sql) + " and M_Product_ID=" + this.p_Product_ID;
            }
            int lastProduct_ID = 0;
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MStorage[] storages = this.getStorages(rs.getInt("m_product_id"), rs.getInt("m_locator_id"), rs.getInt("m_attributesetinstance_id"));
                if (lastProduct_ID != rs.getInt("m_product_id")) {
                    int j = 0;
                    while (j < storages.length) {
                        MStorage st = storages[j];
                        st.setQtyOnHand(Env.ZERO);
                        st.saveEx();
                        ++j;
                    }
                    lastProduct_ID = rs.getInt("m_product_id");
                }
                boolean fixed = false;
                int j = 0;
                while (j < storages.length) {
                    MStorage st = storages[j];
                    st.setQtyOnHand(rs.getBigDecimal("trxqty"));
                    st.saveEx();
                    fixed = true;
                }
                if (fixed) continue;
                MStorage.add(this.getCtx(), MLocator.get(this.getCtx(), rs.getInt(2)).getM_Warehouse_ID(), rs.getInt(2), rs.getInt(3), rs.getInt(4), 0, rs.getBigDecimal(1), Env.ZERO, Env.ZERO, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        this.commitEx();
        return " Fixed " + fixes + " Errors " + errors;
    }

    public MTransaction[] getTransactions(int inoutline_id, int movementline_id, int inventoryline_id, int product_id) {
        String mysql = "select * from M_Transaction where  m_product_id=? ";
        if (inventoryline_id > 0) {
            mysql = String.valueOf(mysql) + " and  m_inventoryline_id=? ";
        }
        if (movementline_id > 0) {
            mysql = String.valueOf(mysql) + " and m_movementline_id=?";
        }
        if (inoutline_id > 0) {
            mysql = String.valueOf(mysql) + " and m_inoutline_id=?";
        }
        CPreparedStatement pstmt = null;
        ArrayList<MTransaction> list = new ArrayList<MTransaction>();
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, product_id);
            if (inventoryline_id > 0) {
                pstmt.setInt(2, inventoryline_id);
            }
            if (movementline_id > 0) {
                pstmt.setInt(2, movementline_id);
            }
            if (inoutline_id > 0) {
                pstmt.setInt(2, inoutline_id);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTransaction line = new MTransaction(this.getCtx(), rs, this.get_TrxName());
                list.add(line);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        MTransaction[] lines = new MTransaction[list.size()];
        list.toArray(lines);
        return lines;
    }

    public MStorage[] getStorages(int product_id, int locator_id, int ATTRIBUTESETINSTANCE_ID) {
        String mysql = "select * from m_storage where m_product_id=? and m_locator_id=? and M_ATTRIBUTESETINSTANCE_ID=?";
        CPreparedStatement pstmt = null;
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, product_id);
            pstmt.setInt(2, locator_id);
            pstmt.setInt(3, ATTRIBUTESETINSTANCE_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MStorage line = new MStorage(this.getCtx(), rs, this.get_TrxName());
                list.add(line);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        MStorage[] lines = new MStorage[list.size()];
        list.toArray(lines);
        return lines;
    }
}

