/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Doc_MatchInv;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class PostDocs
extends SvrProcess {
    Timestamp dateFrom = null;
    Timestamp dateTo = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateAcct")) {
                    this.dateFrom = (Timestamp)para[i].getParameter();
                    this.dateTo = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MAcctSchema[] m_ass = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        int count = 0;
        int countError = 0;
        int[] docs = Doc.getDocumentsTableID();
        String[] tables = Doc.getDocumentsTableName();
        StringBuffer sql = new StringBuffer("");
        int docss = 0;
        int i = 0;
        while (i < docs.length) {
            int AD_Table_ID = docs[i];
            String TableName = tables[i];
            String TableField = "DateAcct";
            if (!(TableName.equals("C_DocType") || TableName.equals("PP_Order") || TableName.equals("PP_Cost_Collector") || TableName.equals("DD_Order") || TableName.equals("HR_Process") || TableName.equals("C_BankFactoring") || TableName.equals("HR_Movement"))) {
                if (TableName.equals("C_BankStatement")) {
                    TableField = "StatementDate";
                }
                if (TableName.equals("M_Inventory") || TableName.equals("M_Movement") || TableName.equals("M_Production") || TableName.equals("C_ProjectIssue")) {
                    TableField = "MovementDate";
                }
                if (TableName.equals("M_Requisition")) {
                    TableField = "DateDoc";
                }
                if (TableName.equals("DM_Document")) {
                    TableField = "DateTrx";
                }
                if (AD_Table_ID != 0 && AD_Table_ID != MOrder.Table_ID && AD_Table_ID != MDocType.Table_ID) {
                    if (docss > 0) {
                        sql.append(" UNION ");
                    }
                    sql.append("SELECT ").append(TableName).append("_ID").append(",").append(TableField).append(",").append(AD_Table_ID).append(" FROM ").append(TableName).append(" WHERE AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND Processed='Y' AND Posted IN ('N','E') AND IsActive='Y'");
                    if (this.dateFrom != null && this.dateTo != null) {
                        sql.append(" AND ").append(TableField).append(" Between ? and ?");
                    }
                    ++docss;
                }
            }
            ++i;
        }
        sql.append(" ORDER BY 2");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            if (this.dateFrom != null && this.dateTo != null) {
                int x = 1;
                int i2 = 0;
                while (i2 < docss) {
                    pstmt.setTimestamp(x++, this.dateFrom);
                    pstmt.setTimestamp(x++, this.dateTo);
                    ++i2;
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ++count;
                boolean ok = true;
                try {
                    Doc doc = Doc.get(m_ass, rs.getInt(3), rs.getInt(1), null);
                    if (doc == null) {
                        this.log.severe(String.valueOf(this.getName()) + ": No Doc for " + rs.getInt(3));
                        ok = false;
                    } else {
                        String error;
                        if (doc instanceof Doc_MatchInv) {
                            Doc tdoc;
                            String tmp;
                            MInOut iout;
                            Doc tdoc2;
                            String tmp2;
                            MMatchInv match = new MMatchInv(this.getCtx(), doc.get_ID(), this.get_TrxName());
                            MInvoice iv = MInvoice.get(this.getCtx(), match.getC_InvoiceLine().getC_Invoice_ID());
                            if (!iv.isPosted() && (tmp2 = (tdoc2 = Doc.get(m_ass, iv.get_Table_ID(), iv.getC_Invoice_ID(), null)).post(false, true)) != null && tmp2.length() > 4 || !(iout = new MInOut(this.getCtx(), match.getM_InOutLine().getM_InOut_ID(), this.get_TrxName())).isPosted() && (tmp = (tdoc = Doc.get(m_ass, iout.get_Table_ID(), iout.getM_InOut_ID(), null)).post(false, true)) != null && tmp.length() > 4) continue;
                        }
                        boolean bl = ok = (error = doc.post(false, true)) == null;
                        if (ok) {
                            ++count;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, String.valueOf(this.getName()) + ": " + sql.toString(), (Throwable)e);
                    ok = false;
                }
                if (ok) continue;
                ++countError;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "Posted:" + count + "-Locked:" + countError;
    }
}

