/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CostReset
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MProduct product;
        this.log.info("M_Product_ID=" + this.p_M_Product_ID);
        if (this.p_M_Product_ID == 0 && this.p_M_Product_Category_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @M_Product_ID@ = " + this.p_M_Product_ID);
        }
        if (this.p_M_Product_ID > 0 && (product = MProduct.get(this.getCtx(), this.p_M_Product_ID)).get_ID() != this.p_M_Product_ID) {
            throw new AdempiereUserError("@NotFound@: @M_Product_ID@ = " + this.p_M_Product_ID);
        }
        if (this.p_M_Product_Category_ID > 0) {
            String sql = "SELECT p.M_Product_ID FROM M_Product p Inner Join M_CostDetail d on (p.M_Product_ID=d.M_product_ID) WHERE p.M_Product_Category_ID=? AND p.isactive='Y' ";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.p_M_Product_Category_ID);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    MProduct mProduct = MProduct.get(this.getCtx(), rs.getInt(1));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                return "@OK@";
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
        }
        return "@Error@";
    }
}

