/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.pdf.Document;
import org.adempiere.print.export.PrintDataExcelExporter;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProject;
import org.compiere.model.MQuery;
import org.compiere.model.MRfQResponse;
import org.compiere.model.PrintInfo;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.CPrinter;
import org.compiere.print.DataEngine;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintUtil;
import org.compiere.print.View;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.X_PP_Order;

public class ReportEngine
implements PrintServiceAttributeListener {
    private static CLogger log = CLogger.getCLogger(ReportEngine.class);
    private Properties m_ctx;
    private MPrintFormat m_printFormat;
    private PrintInfo m_info;
    private MQuery m_query;
    private PrintData m_printData;
    private LayoutEngine m_layout = null;
    private String m_printerName = Ini.getProperty("Printer");
    private View m_view = null;
    private String m_trxName = null;
    private String m_whereExtended = null;
    private int m_windowNo = 0;
    private boolean m_summary = false;
    public static final int ORDER = 0;
    public static final int SHIPMENT = 1;
    public static final int INVOICE = 2;
    public static final int PROJECT = 3;
    public static final int RFQ = 4;
    public static final int REMITTANCE = 5;
    public static final int CHECK = 6;
    public static final int DUNNING = 7;
    public static final int MANUFACTURING_ORDER = 8;
    public static final int DISTRIBUTION_ORDER = 9;
    public static final int POS = 10;
    private static final String[] DOC_BASETABLES = new String[]{"C_Order", "M_InOut", "C_Invoice", "C_Project", "C_RfQResponse", "C_PaySelectionCheck", "C_PaySelectionCheck", "C_DunningRunEntry", "PP_Order", "DD_Order"};
    private static final String[] DOC_IDS = new String[]{"C_Order_ID", "M_InOut_ID", "C_Invoice_ID", "C_Project_ID", "C_RfQResponse_ID", "C_PaySelectionCheck_ID", "C_PaySelectionCheck_ID", "C_DunningRunEntry_ID", "PP_Order_ID", "DD_Order_ID"};
    private static final int[] DOC_TABLE_ID = new int[]{MOrder.Table_ID, MInOut.Table_ID, MInvoice.Table_ID, MProject.Table_ID, MRfQResponse.Table_ID, MPaySelectionCheck.Table_ID, MPaySelectionCheck.Table_ID, MDunningRunEntry.Table_ID, X_PP_Order.Table_ID, MDDOrder.Table_ID};

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info) {
        this(ctx, pf, query, info, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName) {
        if (pf == null) {
            throw new IllegalArgumentException("ReportEngine - no PrintFormat");
        }
        log.info(pf + " -- " + query);
        this.m_ctx = ctx;
        this.m_printFormat = pf;
        this.m_info = info;
        this.m_trxName = trxName;
        this.setQuery(query);
    }

    public void setPrintFormat(MPrintFormat pf) {
        this.m_printFormat = pf;
        if (this.m_layout != null) {
            this.setPrintData();
            this.m_layout.setPrintFormat(pf, false);
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        if (this.m_view != null) {
            this.m_view.revalidate();
        }
    }

    public void setQuery(MQuery query) {
        this.m_query = query;
        if (query == null) {
            return;
        }
        this.setPrintData();
        if (this.m_layout != null) {
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        if (this.m_view != null) {
            this.m_view.revalidate();
        }
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    private void setPrintData() {
        if (this.m_query == null) {
            return;
        }
        DataEngine de = new DataEngine(this.m_printFormat.getLanguage(), this.m_trxName);
        this.setPrintData(de.getPrintData(this.m_ctx, this.m_printFormat, this.m_query, this.m_summary));
    }

    public PrintData getPrintData() {
        return this.m_printData;
    }

    public void setPrintData(PrintData printData) {
        if (printData == null) {
            return;
        }
        this.m_printData = printData;
    }

    private void layout() {
        if (this.m_printFormat == null) {
            throw new IllegalStateException("No print format");
        }
        if (this.m_printData == null) {
            throw new IllegalStateException("No print data (Delete Print Format and restart)");
        }
        this.m_layout = new LayoutEngine(this.m_printFormat, this.m_printData, this.m_query, this.m_info, this.m_trxName);
    }

    public LayoutEngine getLayout() {
        if (this.m_layout == null) {
            this.layout();
        }
        return this.m_layout;
    }

    public String getName() {
        return this.m_printFormat.getName();
    }

    public MPrintFormat getPrintFormat() {
        return this.m_printFormat;
    }

    public PrintInfo getPrintInfo() {
        return this.m_info;
    }

    public Properties getCtx() {
        return this.getLayout().getCtx();
    }

    public int getRowCount() {
        return this.m_printData.getRowCount();
    }

    public int getColumnCount() {
        if (this.m_layout != null) {
            return this.m_layout.getColumnCount();
        }
        return 0;
    }

    public View getView() {
        if (this.m_layout == null) {
            this.layout();
        }
        if (this.m_view == null) {
            this.m_view = new View(this.m_layout);
        }
        return this.m_view;
    }

    public void print() {
        log.info(this.m_info.toString());
        if (this.m_layout == null) {
            this.layout();
        }
        PrintRequestAttributeSet prats = this.m_layout.getPaper().getPrintRequestAttributeSet();
        if (this.m_info.isDocumentCopy() || this.m_info.getCopies() < 1) {
            prats.add(new Copies(1));
        } else {
            prats.add(new Copies(this.m_info.getCopies()));
        }
        Locale locale = Language.getLoginLanguage().getLocale();
        prats.add(new JobName(this.m_printFormat.getName(), locale));
        prats.add(PrintUtil.getJobPriority((int)this.m_layout.getNumberOfPages(), (int)this.m_info.getCopies(), (boolean)true));
        try {
            PrinterJob job = this.getPrinterJob(this.m_info.getPrinterName());
            job.setPageable((Pageable)this.m_layout.getPageable(false));
            try {
                if (this.m_info.isWithDialog() && !job.printDialog(prats)) {
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Operating System Print Issue, check & try again", (Throwable)e);
                return;
            }
            boolean printCopy = this.m_info.isDocumentCopy() && this.m_info.getCopies() > 1;
            ArchiveEngine.get().archive(this.m_layout, this.m_info);
            PrintUtil.print((PrinterJob)job, (PrintRequestAttributeSet)prats, (boolean)false, (boolean)printCopy);
            if (printCopy) {
                log.info("Copy " + (this.m_info.getCopies() - 1));
                prats.add(new Copies(this.m_info.getCopies() - 1));
                job = this.getPrinterJob(this.m_info.getPrinterName());
                job.setPageable((Pageable)this.m_layout.getPageable(true));
                PrintUtil.print((PrinterJob)job, (PrintRequestAttributeSet)prats, (boolean)false, (boolean)false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    @Override
    public void attributeUpdate(PrintServiceAttributeEvent psae) {
        log.fine("attributeUpdate - " + psae);
    }

    private PrinterJob getPrinterJob(String printerName) {
        if (printerName != null && printerName.length() > 0) {
            return CPrinter.getPrinterJob((String)printerName);
        }
        return CPrinter.getPrinterJob((String)this.m_printerName);
    }

    public void pageSetupDialog() {
        if (this.m_layout == null) {
            this.layout();
        }
        this.m_layout.pageSetupDialog(this.getPrinterJob(this.m_printerName));
        if (this.m_view != null) {
            this.m_view.revalidate();
        }
    }

    public void setPrinterName(String printerName) {
        this.m_printerName = printerName == null ? Ini.getProperty("Printer") : printerName;
    }

    public String getPrinterName() {
        return this.m_printerName;
    }

    public boolean createHTML(File file, boolean onlyTable, Language language) {
        return this.createHTML(file, onlyTable, language, null);
    }

    public boolean createHTML(File file, boolean onlyTable, Language language, IHTMLExtension extension) {
        try {
            Language lang = language;
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createHTML(new BufferedWriter(fw), onlyTable, lang, extension);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
        }
        return false;
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language) {
        return this.createHTML(writer, onlyTable, language, null);
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension) {
        try {
            String cssPrefix;
            String string = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            table table2 = new table();
            if (cssPrefix != null) {
                table2.setClass(String.valueOf(cssPrefix) + "-table");
            }
            int row = -1;
            while (row < this.m_printData.getRowCount()) {
                tr tr2 = new tr();
                table2.addElement((Element)tr2);
                if (row != -1) {
                    this.m_printData.setRowIndex(row);
                    if (extension != null) {
                        extension.extendRowElement((ConcreteElement)tr2, this.m_printData);
                    }
                }
                int col = 0;
                while (col < this.m_printFormat.getItemCount()) {
                    MPrintFormatItem item = this.m_printFormat.getItem(col);
                    if (item.isPrinted()) {
                        if (row == -1) {
                            th th2 = new th();
                            tr2.addElement((Element)th2);
                            th2.addElement(Util.maskHTML((String)item.getPrintName(language)));
                        } else {
                            td td2 = new td();
                            tr2.addElement((Element)td2);
                            Object obj = this.m_printData.getNode(new Integer(item.getAD_Column_ID()));
                            if (obj == null) {
                                td2.addElement("&nbsp;");
                            } else if (obj instanceof PrintDataElement) {
                                PrintDataElement pde = (PrintDataElement)obj;
                                String value = pde.getValueDisplay(language);
                                if (pde.getColumnName().endsWith("_ID") && extension != null) {
                                    a href = new a("javascript:void(0)");
                                    href.setID(String.valueOf(pde.getColumnName()) + "_" + row + "_a");
                                    td2.addElement((Element)href);
                                    href.addElement(Util.maskHTML((String)value));
                                    if (cssPrefix != null) {
                                        href.setClass(String.valueOf(cssPrefix) + "-href");
                                    }
                                    extension.extendIDColumn(row, (ConcreteElement)td2, href, pde);
                                } else {
                                    td2.addElement(Util.maskHTML((String)value));
                                }
                                if (cssPrefix != null) {
                                    if (DisplayType.isNumeric((int)pde.getDisplayType())) {
                                        td2.setClass(String.valueOf(cssPrefix) + "-number");
                                    } else if (DisplayType.isDate((int)pde.getDisplayType())) {
                                        td2.setClass(String.valueOf(cssPrefix) + "-date");
                                    } else {
                                        td2.setClass(String.valueOf(cssPrefix) + "-text");
                                    }
                                }
                            } else if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                            }
                        }
                    }
                    ++col;
                }
                ++row;
            }
            PrintWriter w = new PrintWriter(writer);
            if (onlyTable) {
                table2.output(w);
            } else {
                XhtmlDocument doc = new XhtmlDocument();
                doc.appendBody((Element)table2);
                if (extension.getStyleURL() != null) {
                    link l = new link(extension.getStyleURL(), "stylesheet", "text/css");
                    doc.appendHead((Element)l);
                }
                if (extension.getScriptURL() != null) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                doc.output(w);
            }
            w.flush();
            w.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
        }
        return false;
    }

    public boolean createCSV(File file, char delimiter, Language language) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createCSV(new BufferedWriter(fw), delimiter, language);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
        }
        return false;
    }

    public boolean createCSV(Writer writer, char delimiter, Language language) {
        if (delimiter == '\u0000') {
            delimiter = (char)9;
        }
        try {
            int row = -1;
            while (row < this.m_printData.getRowCount()) {
                StringBuffer sb = new StringBuffer();
                if (row != -1) {
                    this.m_printData.setRowIndex(row);
                }
                boolean first = true;
                int col = 0;
                while (col < this.m_printFormat.getItemCount()) {
                    MPrintFormatItem item = this.m_printFormat.getItem(col);
                    if (item.isPrinted()) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(delimiter);
                        }
                        if (row == -1) {
                            this.createCSVvalue(sb, delimiter, this.m_printFormat.getItem(col).getPrintName(language));
                        } else {
                            Object obj = this.m_printData.getNode(new Integer(item.getAD_Column_ID()));
                            String data = "";
                            if (obj != null) {
                                if (obj instanceof PrintDataElement) {
                                    PrintDataElement pde = (PrintDataElement)obj;
                                    data = pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(language);
                                } else if (!(obj instanceof PrintData)) {
                                    log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                                }
                            }
                            this.createCSVvalue(sb, delimiter, data);
                        }
                    }
                    ++col;
                }
                writer.write(sb.toString());
                writer.write(Env.NL);
                ++row;
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
        }
        return false;
    }

    private void createCSVvalue(StringBuffer sb, char delimiter, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        boolean needMask = false;
        StringBuffer buff = new StringBuffer();
        char[] chars = content.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\"') {
                needMask = true;
                buff.append(c);
            } else if (!(needMask || c != delimiter && Character.isLetterOrDigit(c))) {
                needMask = true;
            }
            buff.append(c);
            ++i;
        }
        if (needMask) {
            sb.append('\"').append(buff).append('\"');
        } else {
            sb.append(buff);
        }
    }

    public boolean createXML(File file) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createXML(new BufferedWriter(fw));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
        }
        return false;
    }

    public boolean createXML(Writer writer) {
        try {
            this.m_printData.createXML(new StreamResult(writer));
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
            return false;
        }
    }

    public File getPDF() {
        return this.getPDF(null);
    }

    public File getPDF(File file) {
        try {
            if (file == null) {
                file = File.createTempFile("ReportEngine", ".pdf");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        if (this.createPDF(file)) {
            return file;
        }
        return null;
    }

    public boolean createPDF(File file) {
        String fileName = null;
        URI uri = null;
        try {
            if (file == null) {
                file = File.createTempFile("ReportEngine", ".pdf");
            }
            fileName = file.getAbsolutePath();
            uri = file.toURI();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "file", (Throwable)e);
            return false;
        }
        log.fine(uri.toString());
        try {
            if (this.m_layout == null) {
                this.layout();
            }
            ArchiveEngine.get().archive(this.m_layout, this.m_info);
            Document.getPDFAsFile((String)fileName, (Pageable)this.m_layout.getPageable(false));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", (Throwable)e);
            return false;
        }
        File file2 = new File(fileName);
        log.info(String.valueOf(file2.getAbsolutePath()) + " - " + file2.length());
        return file2.exists();
    }

    public byte[] createPDFData() {
        try {
            if (this.m_layout == null) {
                this.layout();
            }
            return Document.getPDFAsArray((Pageable)this.m_layout.getPageable(false));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", (Throwable)e);
            return null;
        }
    }

    public boolean createPS(File file) {
        try {
            return this.createPS(new FileOutputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
        }
        return false;
    }

    public boolean createPS(OutputStream os) {
        StreamPrintServiceFactory[] spsfactories;
        block5: {
            String outputMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
            DocFlavor.SERVICE_FORMATTED docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
            if (spsfactories.length != 0) break block5;
            log.log(Level.SEVERE, "(fos) - No StreamPrintService");
            return false;
        }
        try {
            StreamPrintService sps = spsfactories[0].getPrintService(os);
            if (this.m_layout == null) {
                this.layout();
            }
            sps.createPrintJob().print((Doc)this.m_layout.getPageable(false), new HashPrintRequestAttributeSet());
            os.flush();
            if (os instanceof FileOutputStream) {
                ((FileOutputStream)os).close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(fos)", (Throwable)e);
        }
        return false;
    }

    public void createXLS(File outFile, Language language) throws Exception {
        PrintDataExcelExporter exp = new PrintDataExcelExporter(this.getPrintData(), this.getPrintFormat());
        exp.export(outFile, language);
    }

    public static ReportEngine get(Properties ctx, ProcessInfo pi) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        int Client_ID;
        boolean IsForm;
        int AD_PrintFormat_ID;
        String whereClause;
        String TableName;
        int AD_ReportView_ID;
        int AD_Table_ID;
        int AD_Client_ID;
        block20: {
            AD_Client_ID = pi.getAD_Client_ID();
            AD_Table_ID = 0;
            AD_ReportView_ID = 0;
            TableName = null;
            whereClause = "";
            AD_PrintFormat_ID = 0;
            IsForm = false;
            Client_ID = -1;
            sql = "SELECT rv.AD_ReportView_ID,rv.WhereClause, t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm, pf.AD_Client_ID FROM AD_PInstance pi INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID) INNER JOIN AD_ReportView rv ON (p.AD_ReportView_ID=rv.AD_ReportView_ID) INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID) LEFT OUTER JOIN AD_PrintFormat pf ON (p.AD_ReportView_ID=pf.AD_ReportView_ID AND pf.AD_Client_ID IN (0,?)) WHERE pi.AD_PInstance_ID=? ORDER BY pf.AD_Client_ID DESC, pf.IsDefault DESC";
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, pi.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_ReportView_ID = rs.getInt(1);
                        whereClause = rs.getString(2);
                        if (rs.wasNull()) {
                            whereClause = "";
                        }
                        AD_Table_ID = rs.getInt(3);
                        TableName = rs.getString(4);
                        AD_PrintFormat_ID = rs.getInt(5);
                        IsForm = "Y".equals(rs.getString(6));
                        Client_ID = rs.getInt(7);
                    }
                }
                catch (SQLException e1) {
                    log.log(Level.SEVERE, "(1) - " + sql, (Throwable)e1);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_ReportView_ID == 0) {
            block22: {
                sql = "SELECT t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm FROM AD_PInstance pi INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID) INNER JOIN AD_PrintFormat pf ON (p.AD_PrintFormat_ID=pf.AD_PrintFormat_ID) INNER JOIN AD_Table t ON (pf.AD_Table_ID=t.AD_Table_ID) WHERE pi.AD_PInstance_ID=?";
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            whereClause = "";
                            AD_Table_ID = rs.getInt(1);
                            TableName = rs.getString(2);
                            AD_PrintFormat_ID = rs.getInt(3);
                            IsForm = "Y".equals(rs.getString(4));
                            Client_ID = AD_Client_ID;
                        }
                    }
                    catch (SQLException e1) {
                        log.log(Level.SEVERE, "(2) - " + sql, (Throwable)e1);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            if (AD_PrintFormat_ID == 0) {
                log.log(Level.SEVERE, "Report Info NOT found AD_PInstance_ID=" + pi.getAD_PInstance_ID() + ",AD_Client_ID=" + AD_Client_ID);
                return null;
            }
        }
        MQuery query = null;
        query = IsForm && pi.getRecord_ID() != 0 && !TableName.startsWith("T_") ? MQuery.getEqualQuery((String)(String.valueOf(TableName) + "_ID"), (int)pi.getRecord_ID()) : MQuery.get((Properties)ctx, (int)pi.getAD_PInstance_ID(), TableName);
        if (whereClause.length() != 0) {
            query.addRestriction(whereClause);
        }
        MPrintFormat format = null;
        Serializable so = pi.getSerializableObject();
        if (so instanceof MPrintFormat) {
            format = (MPrintFormat)so;
        }
        if (format == null && AD_PrintFormat_ID != 0) {
            format = Client_ID == AD_Client_ID ? MPrintFormat.get((Properties)ctx, (int)AD_PrintFormat_ID, (boolean)false) : MPrintFormat.copyToClient((Properties)ctx, (int)AD_PrintFormat_ID, (int)AD_Client_ID);
        }
        if (format != null && format.getItemCount() == 0) {
            log.info("No Items - recreating:  " + format);
            format.delete(true);
            format = null;
        }
        if (format == null && AD_ReportView_ID != 0) {
            format = MPrintFormat.createFromReportView((Properties)ctx, (int)AD_ReportView_ID, (String)pi.getTitle());
        }
        if (format == null) {
            return null;
        }
        PrintInfo info = new PrintInfo(pi);
        info.setAD_Table_ID(AD_Table_ID);
        return new ReportEngine(ctx, format, query, info);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID) {
        return ReportEngine.get(ctx, type, Record_ID, null);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName) {
        Language language;
        int copies;
        String DocumentNo;
        int C_BPartner_ID;
        int AD_PrintFormat_ID;
        block18: {
            int[] what;
            if (Record_ID < 1) {
                log.log(Level.WARNING, "No PrintFormat for Record_ID=" + Record_ID + ", Type=" + type);
                return null;
            }
            if (type == 0 && (what = ReportEngine.getDocumentWhat(Record_ID)) != null) {
                type = what[0];
                Record_ID = what[1];
            }
            if (type == 10) {
                type = 0;
            }
            AD_PrintFormat_ID = 0;
            C_BPartner_ID = 0;
            DocumentNo = null;
            copies = 1;
            MClient client = MClient.get((Properties)ctx);
            language = client.getLanguage();
            String sql = null;
            sql = type == 6 ? "SELECT bad.Check_PrintFormat_ID,\tc.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo FROM C_PaySelectionCheck d INNER JOIN C_PaySelection ps ON (d.C_PaySelection_ID=ps.C_PaySelection_ID) INNER JOIN C_BankAccountDoc bad ON (ps.C_BankAccount_ID=bad.C_BankAccount_ID AND d.PaymentRule=bad.PaymentRule) INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.C_PaySelectionCheck_ID=?" : (type == 7 ? "SELECT dl.Dunning_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,dr.DunningDate FROM C_DunningRunEntry d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_DunningRun dr ON (d.C_DunningRun_ID=dr.C_DunningRun_ID) INNER JOIN C_DunningLevel dl ON (dl.C_DunningLevel_ID=d.C_DunningLevel_ID) WHERE d.C_DunningRunEntry_ID=?" : (type == 5 ? "SELECT pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo FROM C_PaySelectionCheck d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.C_PaySelectionCheck_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 3 ? "SELECT pf.Project_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.Value FROM C_Project d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.C_Project_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 8 ? "SELECT pf.Manuf_Order_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language, 0 , d.DocumentNo FROM PP_Order d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) LEFT OUTER JOIN AD_User u ON (u.AD_User_ID=d.Planner_ID) LEFT OUTER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID)  INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)WHERE d.PP_Order_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 9 ? "SELECT pf.Distrib_Order_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language, bp.C_BPartner_ID , d.DocumentNo FROM DD_Order d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.DD_Order_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 4 ? "SELECT COALESCE(t.AD_PrintFormat_ID, pf.AD_PrintFormat_ID), c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,rr.Name FROM C_RfQResponse rr INNER JOIN C_RfQ r ON (rr.C_RfQ_ID=r.C_RfQ_ID) INNER JOIN C_RfQ_Topic t ON (r.C_RfQ_Topic_ID=t.C_RfQ_Topic_ID) INNER JOIN AD_Client c ON (rr.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (rr.C_BPartner_ID=bp.C_BPartner_ID), AD_PrintFormat pf WHERE pf.AD_Client_ID IN (0,rr.AD_Client_ID) AND pf.AD_Table_ID=725 AND pf.IsTableBased='N' AND rr.C_RfQResponse_ID=? ORDER BY t.AD_PrintFormat_ID, pf.AD_Client_ID DESC, pf.AD_Org_ID DESC" : (type == 0 || type == 2 ? "SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID, COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID), pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument, bp.AD_Language, COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1),  dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo FROM " + DOC_BASETABLES[type] + " d" + " INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)" + " INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)" + " INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)" + " LEFT OUTER JOIN C_DocType dt ON ((d.C_DocType_ID>0 AND d.C_DocType_ID=dt.C_DocType_ID) OR (d.C_DocType_ID=0 AND d.C_DocTypeTarget_ID=dt.C_DocType_ID)) " + "WHERE d." + DOC_IDS[type] + "=?" + " AND pf.AD_Org_ID IN (0,d.AD_Org_ID) " + "ORDER BY pf.AD_Org_ID DESC" : "SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID, COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID), pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument, bp.AD_Language, COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1),  dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo,  pf.Manuf_Order_PrintFormat_ID, pf.Distrib_Order_PrintFormat_ID FROM " + DOC_BASETABLES[type] + " d" + " INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)" + " INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)" + " INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)" + " LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) " + "WHERE d." + DOC_IDS[type] + "=?" + " AND pf.AD_Org_ID IN (0,d.AD_Org_ID) " + "ORDER BY pf.AD_Org_ID DESC")))))));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String AD_Language;
                        if (type == 6 || type == 7 || type == 5 || type == 3 || type == 4 || type == 8 || type == 9) {
                            AD_PrintFormat_ID = rs.getInt(1);
                            copies = 1;
                            AD_Language = rs.getString(3);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(4);
                            if (type == 7) {
                                Timestamp ts = rs.getTimestamp(5);
                                DocumentNo = ts.toString();
                            } else {
                                DocumentNo = rs.getString(5);
                            }
                        } else {
                            AD_PrintFormat_ID = rs.getInt(type + 1);
                            if (type != 2 && rs.getInt(9) != 0) {
                                AD_PrintFormat_ID = rs.getInt(9);
                            }
                            copies = rs.getInt(8);
                            AD_Language = rs.getString(7);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(10);
                            DocumentNo = rs.getString(11);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Record_ID=" + Record_ID + ", SQL=" + sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_PrintFormat_ID == 0) {
            log.log(Level.SEVERE, "No PrintFormat found for Type=" + type + ", Record_ID=" + Record_ID);
            return null;
        }
        MPrintFormat format = MPrintFormat.get((Properties)ctx, (int)AD_PrintFormat_ID, (boolean)false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table_ID());
        query.addRestriction(DOC_IDS[type], "=", Record_ID);
        if (DocumentNo == null || DocumentNo.length() == 0) {
            DocumentNo = "DocPrint";
        }
        PrintInfo info = new PrintInfo(DocumentNo, DOC_TABLE_ID[type], Record_ID, C_BPartner_ID);
        info.setCopies(copies);
        info.setDocumentCopy(false);
        info.setPrinterName(format.getPrinterName());
        ReportEngine re = new ReportEngine(ctx, format, query, info, trxName);
        return re;
    }

    private static int[] getDocumentWhat(int C_Order_ID) {
        int[] what = new int[]{0, C_Order_ID};
        String sql = "SELECT dt.DocSubTypeSO FROM C_DocType dt, C_Order o WHERE o.C_DocType_ID=dt.C_DocType_ID AND o.C_Order_ID=?";
        String DocSubTypeSO = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                }
                if (DocSubTypeSO == null || "".equals(DocSubTypeSO)) {
                    sql = "SELECT dt.DocSubTypeSO FROM C_DocType dt, C_Order o WHERE o.C_DocTypeTarget_ID=dt.C_DocType_ID AND o.C_Order_ID=?";
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DocSubTypeSO = rs.getString(1);
                    }
                }
            }
            catch (SQLException e1) {
                log.log(Level.SEVERE, "(1) - " + sql, (Throwable)e1);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (DocSubTypeSO == null) {
            DocSubTypeSO = "";
        }
        if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("WI")) {
            what[0] = 2;
        } else if (DocSubTypeSO.equals("WP")) {
            what[0] = 1;
        } else {
            return what;
        }
        sql = what[0] == 2 ? "SELECT C_Invoice_ID REC FROM C_Invoice WHERE C_Order_ID=? ORDER BY C_Invoice_ID DESC" : "SELECT M_InOut_ID REC FROM M_InOut WHERE C_Order_ID=? ORDER BY M_InOut_ID DESC";
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    what[1] = rs.getInt(1);
                } else {
                    what[0] = 0;
                }
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "(2) - " + sql, (Throwable)e2);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("Order => " + what[0] + " ID=" + what[1]);
        return what;
    }

    public static void printConfirm(int type, int Record_ID) {
        int no;
        StringBuffer sql = new StringBuffer();
        if (type == 0 || type == 1 || type == 2) {
            sql.append("UPDATE ").append(DOC_BASETABLES[type]).append(" SET DatePrinted=SysDate, IsPrinted='Y' WHERE ").append(DOC_IDS[type]).append("=").append(Record_ID);
        }
        if (sql.length() > 0 && (no = DB.executeUpdate((String)sql.toString(), null)) != 1) {
            log.log(Level.SEVERE, "Updated records=" + no + " - should be just one");
        }
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)true);
        int AD_Table_ID = 100;
        MQuery q = new MQuery("AD_Table");
        q.addRestriction("AD_Table_ID", "<", 108);
        MPrintFormat f = MPrintFormat.createFromTable((Properties)Env.getCtx(), (int)AD_Table_ID);
        PrintInfo i = new PrintInfo("test", AD_Table_ID, 108, 0);
        i.setAD_Table_ID(AD_Table_ID);
        ReportEngine re = new ReportEngine(Env.getCtx(), f, q, i);
        re.layout();
        re.print();
        System.exit(0);
    }

    public void setWhereExtended(String whereExtended) {
        this.m_whereExtended = whereExtended;
    }

    public String getWhereExtended() {
        return this.m_whereExtended;
    }

    public void setWindowNo(int windowNo) {
        this.m_windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setSummary(boolean summary) {
        this.m_summary = summary;
    }
}

