/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Requisition;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.ofb.model.OFBForward;

public class MRequisition
extends X_M_Requisition
implements DocAction {
    private static final long serialVersionUID = 898606565778668659L;
    private MRequisitionLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MRequisition(Properties ctx, int M_Requisition_ID, String trxName) {
        super(ctx, M_Requisition_ID, trxName);
        if (M_Requisition_ID == 0) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDateRequired(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPriorityRule("5");
            this.setTotalLines(Env.ZERO);
            this.setIsApproved(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MRequisition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequisitionLine[] getLines() {
        if (this.m_lines != null) {
            MRequisition.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "M_Requisition_ID=?";
        List list = new Query(this.getCtx(), "M_RequisitionLine", "M_Requisition_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("Line").list();
        this.m_lines = new MRequisitionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MRequisition[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",Status=").append(this.getDocStatus()).append(",Action=").append(this.getDocAction()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"M_Requisition_ID")) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public void setM_PriceList_ID() {
        MPriceList defaultPL = MPriceList.getDefault((Properties)this.getCtx(), (boolean)false);
        if (defaultPL == null) {
            defaultPL = MPriceList.getDefault((Properties)this.getCtx(), (boolean)true);
        }
        if (defaultPL != null) {
            this.setM_PriceList_ID(defaultPL.getM_PriceList_ID());
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_PriceList_ID() == 0) {
            this.setM_PriceList_ID();
        }
        return true;
    }

    protected boolean beforeDelete() {
        MRequisitionLine[] mRequisitionLineArray = this.getLines();
        int n = mRequisitionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRequisitionLine line = mRequisitionLineArray[n2];
            line.deleteEx(true);
            ++n2;
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        String validation;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MRequisitionLine[] lines = this.getLines();
        if (this.getAD_User_ID() == 0 || this.getM_PriceList_ID() == 0 || this.getM_Warehouse_ID() == 0) {
            return "IN";
        }
        if (!OFBForward.NoValidationReqNoLine() && lines.length == 0) {
            throw new AdempiereException("@NoLines@");
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateDoc(), "POR", this.getAD_Org_ID());
        int precision = MPriceList.getStandardPrecision((Properties)this.getCtx(), (int)this.getM_PriceList_ID());
        BigDecimal totalLines = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MRequisitionLine line = lines[i];
            BigDecimal lineNet = line.getQty().multiply(line.getPriceActual());
            if ((lineNet = lineNet.setScale(precision, 4)).compareTo(line.getLineNetAmt()) != 0) {
                line.setLineNetAmt(lineNet);
                line.saveEx();
            }
            totalLines = totalLines.add(line.getLineNetAmt());
            ++i;
        }
        if (totalLines.compareTo(this.getTotalLines()) != 0) {
            this.setTotalLines(totalLines);
            this.saveEx();
        }
        if ((validation = this.budgetValidation()).length() > 1) {
            return validation;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.setDefiniteDocumentNo();
        String accion = this.completeOFB();
        if (accion.length() > 1) {
            return accion;
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)((Object)this))) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.freeBudget();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.closeIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 10);
        return this.m_processMsg == null;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MRequisitionLine[] lines = this.getLines();
        BigDecimal totalLines = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MRequisitionLine line = lines[i];
            BigDecimal finalQty = line.getQty();
            if (line.getC_OrderLine_ID() == 0) {
                finalQty = Env.ZERO;
            } else {
                MOrderLine ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                finalQty = ol.getQtyOrdered();
            }
            if (finalQty.compareTo(line.getQty()) != 0) {
                String description = line.getDescription();
                if (description == null) {
                    description = "";
                }
                description = String.valueOf(description) + " [" + line.getQty() + "]";
                line.setDescription(description);
                line.setQty(finalQty);
                line.setLineNetAmt();
                line.saveEx();
            }
            totalLines = totalLines.add(line.getLineNetAmt());
            ++i;
        }
        if (totalLines.compareTo(this.getTotalLines()) != 0) {
            this.setTotalLines(totalLines);
            this.saveEx();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(" - ").append(this.getUserName());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"TotalLines")).append("=").append(this.getTotalLines()).append(" (#").append(this.getLines().length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getAD_User_ID();
    }

    @Override
    public int getC_Currency_ID() {
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)this.getM_PriceList_ID(), (String)this.get_TrxName());
        return pl.getC_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalLines();
    }

    public String getUserName() {
        return MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID()).getName();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String budgetValidation() {
        MClient client = MClient.get((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        Boolean useBudget = false;
        try {
            useBudget = client.get_ValueAsBoolean("UseBudget");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (useBudget.booleanValue()) {
            MRole myrole = new MRole(this.getCtx(), Env.getAD_Role_ID((Properties)this.getCtx()), this.get_TrxName());
            MUser currentUser = new MUser(this.getCtx(), Env.getAD_User_ID((Properties)this.getCtx()), this.get_TrxName());
            String commenthelp = new String();
            String sql = "select SUM(rl.LineNetAmt)as LineNetAmt,c.m_product_category_id,c.name, rl.AD_Org_ID from M_RequisitionLine rl inner join M_Product p on (rl.m_product_id=p.m_product_id) inner join M_Product_Category c on (p.m_product_category_id=c.m_product_category_id) where rl.m_requisition_id=? group by c.m_product_category_id,c.name,rl.AD_Org_ID";
            CPreparedStatement pstmt = null;
            boolean sobrePresupuesto = false;
            boolean sobreanual = false;
            BigDecimal totalamt = Env.ZERO;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getM_Requisition_ID());
                ResultSet rs = pstmt.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                        break;
                    }
                    BigDecimal monto = MConversionRate.convertBase(this.getCtx(), rs.getBigDecimal(1), this.getM_PriceList().getC_Currency_ID(), this.getDateDoc(), 0, this.getAD_Client_ID(), rs.getInt(4));
                    if (monto == null) {
                        this.m_processMsg = "No existe tasa de cambio";
                        return "IN";
                    }
                    this.log.config("monto :" + monto);
                    totalamt = totalamt.add(monto);
                    long ActualBudget = this.getBudget(rs.getInt(2), this.getDateDoc(), rs.getInt(4), 0);
                    long YearBudget = this.getBudgetYear(rs.getInt(2), MPeriod.get(this.getCtx(), this.getDateDoc()).getC_Year_ID(), rs.getInt(4), 0);
                    if (ActualBudget >= monto.longValue()) continue;
                    long valor = 0L;
                    valor = ActualBudget <= 0L ? ActualBudget * -1L + monto.longValue() : ActualBudget - monto.longValue();
                    this.log.config("rs.getDouble(1): " + monto.doubleValue());
                    this.log.config("ActualBudget: " + ActualBudget);
                    this.log.config("valor: " + valor);
                    commenthelp = String.valueOf(commenthelp) + " | Categoria: " + rs.getString(3) + " Sobrepasado: " + valor;
                    sobrePresupuesto = true;
                    if (!((double)YearBudget < monto.doubleValue())) continue;
                    sobreanual = true;
                }
            }
            catch (Exception e) {
                this.log.severe(e.getMessage());
            }
            if (!sobrePresupuesto && !sobreanual) {
                commenthelp = "VERDE " + commenthelp;
            }
            if (sobrePresupuesto && !sobreanual) {
                commenthelp = "AMARILLO " + commenthelp;
            }
            if (sobreanual) {
                commenthelp = "ROJO " + commenthelp;
            }
            if (!myrole.get_ValueAsBoolean("RequisitionAdmin") && !myrole.get_ValueAsBoolean("RequisitionSupervisor")) {
                this.setProcessed(true);
                this.setHelp(commenthelp);
                return "WC";
            }
            if (myrole.get_ValueAsBoolean("RequisitionSupervisor") && totalamt.doubleValue() > ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue()) {
                this.setProcessed(true);
                this.setHelp(commenthelp);
                return "WC";
            }
            if (myrole.get_ValueAsBoolean("RequisitionSupervisor") && totalamt.doubleValue() < ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() && sobrePresupuesto) {
                this.setProcessed(true);
                this.setHelp(commenthelp);
                return "WC";
            }
            if (myrole.get_ValueAsBoolean("RequisitionAdmin") && ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() < totalamt.doubleValue() && ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() != 0.0) {
                this.setProcessed(true);
                this.setHelp(commenthelp);
                return "WC";
            }
            if (myrole.get_ValueAsBoolean("RequisitionAdmin") && ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() > totalamt.doubleValue() && sobreanual) {
                this.setProcessed(true);
                this.setHelp(commenthelp);
                return "WC";
            }
        }
        return "";
    }

    public long getBudget(int category_ID, Timestamp dateDoc, int Org_ID, int Product_ID) {
        ResultSet rs;
        MPeriod period;
        CPreparedStatement pstmt;
        String sql;
        long actualBudget = 0L;
        boolean found = false;
        if (Product_ID > 0) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and ?  and p.C_Year_ID=? and b.m_product_id=? and b.ad_org_id=?";
            pstmt = null;
            period = MPeriod.get(this.getCtx(), dateDoc);
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, period.getPeriodNo());
                pstmt.setInt(2, period.getC_Year_ID());
                pstmt.setInt(3, Product_ID);
                pstmt.setInt(4, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                    found = true;
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        if (Product_ID == 0 || !found) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and ?  and p.C_Year_ID=? and b.m_product_category_id=? and b.ad_org_id=?";
            pstmt = null;
            period = MPeriod.get(this.getCtx(), dateDoc);
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, period.getPeriodNo());
                pstmt.setInt(2, period.getC_Year_ID());
                pstmt.setInt(3, category_ID);
                pstmt.setInt(4, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        return actualBudget;
    }

    public long getBudgetYear(int category_ID, int Year_ID, int Org_ID, int Product_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        long actualBudget = 0L;
        boolean found = false;
        if (Product_ID > 0) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and 12  and p.C_Year_ID=? and b.m_product_id=? and b.ad_org_id=?";
            pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, Year_ID);
                pstmt.setInt(2, Product_ID);
                pstmt.setInt(3, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                    found = true;
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        if (Product_ID == 0 || !found) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and 12  and p.C_Year_ID=? and b.m_product_category_id=? and b.ad_org_id=?";
            pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, Year_ID);
                pstmt.setInt(2, category_ID);
                pstmt.setInt(3, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        return actualBudget;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String completeOFB() {
        MRequisitionLine[] lines;
        DB.executeUpdate((String)("update M_REQUISITIONLINE set Processed='Y' where M_REQUISITION_ID=" + this.getM_Requisition_ID()), (String)this.get_TrxName());
        if (this.isSOTrx()) {
            lines = this.getLines();
            int i = 0;
            while (i < lines.length) {
                MProduct product;
                MRequisitionLine line = lines[i];
                if (line.getM_Product_ID() > 0 && (product = new MProduct(this.getCtx(), line.getM_Product_ID(), this.get_TrxName())).isStocked()) {
                    MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID());
                    if (!MStorage.add(this.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, line.getQty(), Env.ZERO, this.get_TrxName())) {
                        this.m_processMsg = "No se puede Reservar";
                        return "IN";
                    }
                }
                ++i;
            }
        }
        if ("Y".equals(DB.getSQLValueString((String)this.get_TrxName(), (String)("select UseBudget from AD_Client where AD_Client_ID=" + this.getAD_Client_ID()), (Object[])new Object[0])) && !this.isSOTrx()) {
            String sql = "select SUM(rl.LineNetAmt)as LineNetAmt,c.m_product_category_id, rl.AD_Org_ID from M_RequisitionLine rl inner join M_Product p on (rl.m_product_id=p.m_product_id) inner join M_Product_Category c on (p.m_product_category_id=c.m_product_category_id) where rl.m_requisition_id=? group by c.m_product_category_id, rl.AD_Org_ID";
            CPreparedStatement pstmt = null;
            MPeriod period = MPeriod.get(this.getCtx(), this.getDateDoc());
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getM_Requisition_ID());
                ResultSet rs = pstmt.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                        break;
                    }
                    BigDecimal monto = MConversionRate.convertBase(this.getCtx(), rs.getBigDecimal(1), this.getM_PriceList().getC_Currency_ID(), this.getDateDoc(), 0, this.getAD_Client_ID(), rs.getInt(3));
                    if (monto == null) {
                        this.m_processMsg = "No existe tasa de cambio";
                        return "IN";
                    }
                    DB.executeUpdate((String)("Update m_product_category_Budget set BudgetUsed=BudgetUsed+" + monto.doubleValue() + " where m_product_category_id=" + rs.getInt(2) + " And AD_Org_ID=" + rs.getInt(3) + " and c_period_ID=" + period.getC_Period_ID()), (String)this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.log.severe(e.getMessage());
            }
        }
        if (this.getDocBase().equals("RRC") && !this.isSOTrx()) {
            MRequisitionLine line;
            String clientName = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID()).getName().toUpperCase();
            MRequisitionLine[] lines2 = this.getLines();
            MInventory inv = null;
            MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID(), (String)this.get_TrxName());
            if (OFBForward.ValidStockMaterialReq()) {
                int a = 0;
                while (a < lines2.length) {
                    line = lines2[a];
                    if (line.getM_Product_ID() > 0) {
                        BigDecimal qtyEntered = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT SUM(qtyonhand) FROM M_Storage  WHERE M_Product_ID=" + line.getM_Product_ID() + " AND M_Locator_ID=" + wh.getDefaultLocator().getM_Locator_ID()), (Object[])new Object[0]);
                        BigDecimal qtyIntransit = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT SUM(ml.QtyInternalUse) FROM M_InventoryLine ml  INNER JOIN M_Inventory mi ON (mi.M_Inventory_ID = ml.M_Inventory_ID)  WHERE ml.M_Product_ID=" + line.getM_Product_ID() + " AND ml.M_Locator_ID=" + wh.getDefaultLocator().getM_Locator_ID() + " AND mi.DocStatus IN ('DR','IP')"), (Object[])new Object[0]);
                        if (qtyEntered == null) {
                            qtyEntered = Env.ZERO;
                        }
                        if (qtyIntransit == null) {
                            qtyIntransit = Env.ZERO;
                        }
                        qtyEntered = qtyEntered.subtract(qtyIntransit);
                        if (line.getQty().compareTo(qtyEntered) > 0) {
                            String ret;
                            MLocator loc = new MLocator(this.getCtx(), wh.getDefaultLocator().getM_Locator_ID(), this.get_TrxName());
                            this.m_processMsg = ret = "ERROR: Producto " + line.getM_Product().getName() + " sin stock. Stock:" + qtyEntered + ". Solicitado:" + line.getQty() + " en ubicaci\u00f2n " + loc.getValue();
                            return "IN";
                        }
                    }
                    ++a;
                }
            }
            int i = 0;
            while (i < lines2.length) {
                line = lines2[i];
                if (line.getM_Product_ID() > 0) {
                    if (inv == null) {
                        inv = new MInventory(this.getCtx(), 0, this.get_TrxName());
                        inv.setAD_Org_ID(this.getAD_Org_ID());
                        inv.setM_Warehouse_ID(this.getM_Warehouse_ID());
                        if (clientName.indexOf("GOBIERNO") > 0) {
                            inv.setC_DocType_ID(1000023);
                        } else if (clientName.indexOf("GEMINIS") > 0) {
                            inv.setC_DocType_ID(1000058);
                        }
                        inv.set_CustomColumn("AD_User_ID", this.getAD_User_ID());
                        try {
                            inv.set_CustomColumn("M_Requisition_ID", this.get_ID());
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "No se pudo asignar la variable M_Requisition_ID en M_Inventory", (Throwable)e);
                        }
                        inv.set_CustomColumn("AD_User_ID", this.getAD_User_ID());
                        inv.save();
                    }
                    MInventoryLine il = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
                    il.setM_Inventory_ID(inv.getM_Inventory_ID());
                    il.setAD_Org_ID(this.getAD_Org_ID());
                    il.setM_Product_ID(line.getM_Product_ID());
                    il.setM_Locator_ID(wh.getDefaultLocator().getM_Locator_ID());
                    il.setQtyInternalUse(line.getQty());
                    il.setC_Charge_ID(this.get_ValueAsInt("C_Charge_ID"));
                    il.save();
                }
                ++i;
            }
            if (inv != null) {
                this.set_CustomColumn("M_Inventory_ID", inv.getM_Inventory_ID());
            }
        }
        if (!this.isSOTrx()) {
            lines = this.getLines();
            MRfQ rqf = null;
            BigDecimal total = Env.ZERO;
            int i = 0;
            while (i < lines.length) {
                MRequisitionLine line = lines[i];
                if (line.getM_Product_ID() > 0 && line.get_ValueAsBoolean("IsRfQ")) {
                    if (rqf == null && this.get_ValueAsInt("C_RfQ_ID") == 0) {
                        rqf = new MRfQ(this.getCtx(), 0, this.get_TrxName());
                        rqf.setSalesRep_ID(this.getAD_User_ID());
                        rqf.set_CustomColumn("M_Requisition_ID", (Object)this.getM_Requisition_ID());
                        rqf.setDescription(this.getDescription());
                        rqf.set_CustomColumn("M_PriceList_ID", (Object)this.getM_PriceList_ID());
                        rqf.setAD_Org_ID(this.getAD_Org_ID());
                        rqf.setName(String.valueOf(this.getDocumentNo()) + " " + this.getDescription());
                        rqf.setC_Currency_ID(this.getM_PriceList().getC_Currency_ID());
                        rqf.save();
                    } else if (rqf == null && this.get_ValueAsInt("C_RfQ_ID") > 0) {
                        rqf = new MRfQ(this.getCtx(), this.get_ValueAsInt("C_RfQ_ID"), this.get_TrxName());
                    }
                    MRfQLine rfqline = new MRfQLine(rqf);
                    rfqline.setAD_Org_ID(line.getAD_Org_ID());
                    rfqline.setLine(line.getLine());
                    rfqline.setM_Product_ID(line.getM_Product_ID());
                    rfqline.setDescription(line.getDescription());
                    rfqline.set_CustomColumn("Qty", (Object)line.getQty());
                    rfqline.set_CustomColumn("PriceActual", (Object)line.getPriceActual());
                    rfqline.set_CustomColumn("LineNetAmt", (Object)line.getLineNetAmt());
                    rfqline.set_CustomColumn("M_RequisitionLine_ID", (Object)line.getM_RequisitionLine_ID());
                    rfqline.save();
                    total = total.add(line.getLineNetAmt());
                }
                ++i;
            }
            if (rqf != null) {
                rqf.set_CustomColumn("TotalAmt", (Object)total);
                rqf.setSalesRep_ID(this.getAD_User_ID());
                rqf.save();
                this.set_CustomColumn("C_RfQ_ID", rqf.getC_RfQ_ID());
            }
        }
        return "";
    }

    public boolean isSOTrx() {
        boolean issotrx = "Y".equals(DB.getSQLValueString((String)this.get_TrxName(), (String)("Select IsSoTrx from C_DocType where C_DocType_ID=" + this.getC_DocType_ID()), (Object[])new Object[0]));
        return issotrx;
    }

    public String getDocBase() {
        String base = DB.getSQLValueString((String)this.get_TrxName(), (String)("Select docbasetype from C_DocType where C_DocType_ID=" + this.getC_DocType_ID()), (Object[])new Object[0]);
        return base;
    }

    private BigDecimal getQtyOnHand(int M_AttributeSetInstance_ID, int M_Product_ID, int M_Warehouse_ID) {
        this.log.config("M_Warehouse_ID: " + M_Warehouse_ID + "M_Product_ID: " + M_Product_ID + " M_AttributeSetInstance_ID: " + M_AttributeSetInstance_ID);
        BigDecimal bd = null;
        String sql = "SELECT sum(s.QtyOnHand) FROM M_Storage s  INNER JOIN M_Locator l on (l.M_Locator_ID=s.M_locator_ID) WHERE s.M_Product_ID=? AND l.M_Warehouse_ID=?";
        if (M_AttributeSetInstance_ID > 0) {
            sql = "SELECT sum(s.QtyOnHand) FROM M_Storage s  INNER JOIN M_Locator l on (l.M_Locator_ID=s.M_locator_ID) WHERE s.M_Product_ID=? AND l.M_Warehouse_ID=? AND s.M_AttributeSetInstance_ID=?";
        }
        try {
            ResultSet rs;
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Warehouse_ID);
            if (M_AttributeSetInstance_ID > 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                bd = rs.getBigDecimal(1);
                this.log.config("QtyOnHand: " + bd);
                if (bd != null) {
                    return bd;
                }
            } else {
                return new BigDecimal(0);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return new BigDecimal(0);
        }
        return new BigDecimal(0);
    }

    private void freeBudget() {
        if (this.getDocStatus().equals("CO") && "Y".equals(DB.getSQLValueString((String)this.get_TrxName(), (String)("select UseBudget from AD_Client where AD_Client_ID=" + this.getAD_Client_ID()), (Object[])new Object[0])) && !this.isSOTrx()) {
            MRequisitionLine[] lines;
            MRequisitionLine[] mRequisitionLineArray = lines = this.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MRequisitionLine line = mRequisitionLineArray[n2];
                MPeriod period = MPeriod.get(this.getCtx(), line.getParent().getDateDoc());
                if (!line.get_ValueAsBoolean("IsCorrected")) {
                    DB.executeUpdate((String)("Update m_product_category_Budget set BudgetUsed=BudgetUsed - " + line.getLineNetAmt().doubleValue() + " where m_product_category_id=" + line.getM_Product().getM_Product_Category_ID() + " And AD_Org_ID=" + line.getAD_Org_ID() + " and c_period_ID=" + period.getC_Period_ID()), (String)this.get_TrxName());
                    line.set_CustomColumn("IsCorrected", true);
                    line.save();
                }
                ++n2;
            }
        }
    }
}

