/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.PO;
import org.compiere.model.X_C_ProjectLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProjectLine
extends X_C_ProjectLine {
    private static final long serialVersionUID = 2668549463273628848L;
    private MProject m_parent = null;

    public MProjectLine(Properties ctx, int C_ProjectLine_ID, String trxName) {
        super(ctx, C_ProjectLine_ID, trxName);
        if (C_ProjectLine_ID == 0) {
            this.setLine(0);
            this.setIsPrinted(true);
            this.setProcessed(false);
            this.setInvoicedAmt(Env.ZERO);
            this.setInvoicedQty(Env.ZERO);
            this.setPlannedAmt(Env.ZERO);
            this.setPlannedMarginAmt(Env.ZERO);
            this.setPlannedPrice(Env.ZERO);
            this.setPlannedQty(Env.ONE);
        }
    }

    public MProjectLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectLine(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg((PO)((Object)project));
        this.setC_Project_ID(project.getC_Project_ID());
        this.setLine();
    }

    private void setLine() {
        this.setLine(DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT COALESCE(MAX(Line),0)+10 FROM C_ProjectLine WHERE C_Project_ID=?", (int)this.getC_Project_ID()));
    }

    public void setMProjectIssue(MProjectIssue pi) {
        this.setC_ProjectIssue_ID(pi.getC_ProjectIssue_ID());
        this.setM_Product_ID(pi.getM_Product_ID());
        this.setCommittedQty(pi.getMovementQty());
        if (this.getDescription() != null) {
            this.setDescription(pi.getDescription());
        }
    }

    public void setC_OrderPO_ID(int C_OrderPO_ID) {
        super.setC_OrderPO_ID(C_OrderPO_ID);
    }

    public MProject getProject() {
        if (this.m_parent == null && this.getC_Project_ID() != 0) {
            this.m_parent = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
            if (this.get_TrxName() != null) {
                this.m_parent.load(this.get_TrxName());
            }
        }
        return this.m_parent;
    }

    public BigDecimal getLimitPrice() {
        BigDecimal limitPrice = this.getPlannedPrice();
        if (this.getM_Product_ID() == 0) {
            return limitPrice;
        }
        if (this.getProject() == null) {
            return limitPrice;
        }
        boolean isSOTrx = true;
        MProductPricing pp = new MProductPricing(this.getM_Product_ID(), this.m_parent.getC_BPartner_ID(), this.getPlannedQty(), isSOTrx);
        pp.setM_PriceList_ID(this.m_parent.getM_PriceList_ID());
        if (pp.calculatePrice()) {
            limitPrice = pp.getPriceLimit();
        }
        return limitPrice;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectLine[");
        sb.append(this.get_ID()).append("-").append(this.getLine()).append(",C_Project_ID=").append(this.getC_Project_ID()).append(",C_ProjectPhase_ID=").append(this.getC_ProjectPhase_ID()).append(",C_ProjectTask_ID=").append(this.getC_ProjectTask_ID()).append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID()).append(", M_Product_ID=").append(this.getM_Product_ID()).append(", PlannedQty=").append(this.getPlannedQty()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getLine() == 0) {
            this.setLine();
        }
        this.setPlannedAmt(this.getPlannedQty().multiply(this.getPlannedPrice()));
        if (this.is_ValueChanged("C_ProjectTask_ID") && this.getC_ProjectTask_ID() != 0) {
            MProjectTask pt = new MProjectTask(this.getCtx(), this.getC_ProjectTask_ID(), this.get_TrxName());
            if (pt == null || pt.get_ID() == 0) {
                this.log.warning("Project Task Not Found - ID=" + this.getC_ProjectTask_ID());
                return false;
            }
            this.setC_ProjectPhase_ID(pt.getC_ProjectPhase_ID());
        }
        if (this.is_ValueChanged("C_ProjectPhase_ID") && this.getC_ProjectPhase_ID() != 0) {
            MProjectPhase pp = new MProjectPhase(this.getCtx(), this.getC_ProjectPhase_ID(), this.get_TrxName());
            if (pp == null || pp.get_ID() == 0) {
                this.log.warning("Project Phase Not Found - " + this.getC_ProjectPhase_ID());
                return false;
            }
            this.setC_Project_ID(pp.getC_Project_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateHeader();
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.updateHeader();
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE C_Project p SET (PlannedAmt,PlannedQty,PlannedMarginAmt,\tCommittedAmt,CommittedQty, InvoicedAmt, InvoicedQty) = (SELECT COALESCE(SUM(pl.PlannedAmt),0),COALESCE(SUM(pl.PlannedQty),0),COALESCE(SUM(pl.PlannedMarginAmt),0), COALESCE(SUM(pl.CommittedAmt),0),COALESCE(SUM(pl.CommittedQty),0), COALESCE(SUM(pl.InvoicedAmt),0), COALESCE(SUM(pl.InvoicedQty),0) FROM C_ProjectLine pl WHERE pl.C_Project_ID=p.C_Project_ID AND pl.IsActive='Y') WHERE C_Project_ID=" + this.getC_Project_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "updateHeader - #" + no);
        }
    }
}

