/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MTable;
import org.compiere.model.MYear;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Period;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MPeriod
extends X_C_Period {
    private static final long serialVersionUID = 6498973218391994963L;
    private static CCache<Integer, MPeriod> s_cache = new CCache("C_Period", 10);
    private static CLogger s_log = CLogger.getCLogger(MPeriod.class);
    private int m_C_Calendar_ID = 0;
    private MPeriodControl[] m_controls = null;

    public static MPeriod get(Properties ctx, int C_Period_ID) {
        if (C_Period_ID <= 0) {
            return null;
        }
        Integer key = new Integer(C_Period_ID);
        MPeriod retValue = (MPeriod)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MPeriod(ctx, C_Period_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MPeriod get(Properties ctx, Timestamp DateAcct) {
        return MPeriod.get(ctx, DateAcct, 0);
    }

    public static MPeriod get(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        if (DateAcct == null) {
            return null;
        }
        int C_Calendar_ID = MPeriod.getC_Calendar_ID(ctx, AD_Org_ID);
        return MPeriod.findByCalendar(ctx, DateAcct, C_Calendar_ID);
    }

    public static MPeriod findByCalendar(Properties ctx, Timestamp DateAcct, int C_Calendar_ID) {
        return MPeriod.findByCalendar(ctx, DateAcct, C_Calendar_ID, null);
    }

    public static MPeriod findByCalendar(Properties ctx, Timestamp DateAcct, int C_Calendar_ID, String trxName) {
        MPeriod retValue;
        int AD_Client_ID;
        block8: {
            AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
            for (MPeriod period : s_cache.values()) {
                if (period.getC_Calendar_ID() != C_Calendar_ID || !period.isStandardPeriod() || !period.isInPeriod(DateAcct) || period.getAD_Client_ID() != AD_Client_ID) continue;
                return period;
            }
            retValue = null;
            String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID= ?) AND to_date('" + TimeUtil.getDay((Timestamp)DateAcct).toString().substring(0, 10) + "','yyyy-mm-dd') BETWEEN TRUNC(StartDate) AND TRUNC(EndDate)" + " AND IsActive=? AND PeriodType=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, C_Calendar_ID);
                    pstmt.setString(2, "Y");
                    pstmt.setString(3, "S");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPeriod period = new MPeriod(ctx, rs, trxName);
                        Integer key = new Integer(period.getC_Period_ID());
                        s_cache.put((Object)key, (Object)period);
                        if (!period.isStandardPeriod()) continue;
                        retValue = period;
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, "DateAcct=" + DateAcct, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            s_log.info("No Standard Period for " + DateAcct + " (AD_Client_ID=" + AD_Client_ID + ")");
        }
        return retValue;
    }

    public static int getC_Period_ID(Properties ctx, Timestamp DateAcct) {
        MPeriod period = MPeriod.get(ctx, DateAcct);
        if (period == null) {
            return 0;
        }
        return period.getC_Period_ID();
    }

    public static int getC_Period_ID(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        MPeriod period = MPeriod.get(ctx, DateAcct, AD_Org_ID);
        if (period == null) {
            return 0;
        }
        return period.getC_Period_ID();
    }

    public static boolean isOpen(Properties ctx, Timestamp DateAcct, String DocBaseType) {
        return MPeriod.isOpen(ctx, DateAcct, DocBaseType, 0);
    }

    public static boolean isOpen(Properties ctx, Timestamp DateAcct, String DocBaseType, int AD_Org_ID) {
        if (DateAcct == null) {
            s_log.warning("No DateAcct");
            return false;
        }
        if (DocBaseType == null) {
            s_log.warning("No DocBaseType");
            return false;
        }
        MPeriod period = MPeriod.get(ctx, DateAcct, AD_Org_ID);
        if (period == null) {
            s_log.warning("No Period for " + DateAcct + " (" + DocBaseType + ")");
            return false;
        }
        boolean open = period.isOpen(DocBaseType, DateAcct);
        if (!open) {
            s_log.warning(String.valueOf(period.getName()) + ": Not open for " + DocBaseType + " (" + DateAcct + ")");
        }
        return open;
    }

    public static MPeriod getFirstInYear(Properties ctx, Timestamp DateAcct) {
        return MPeriod.getFirstInYear(ctx, DateAcct, 0);
    }

    public static MPeriod getFirstInYear(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        MPeriod retValue;
        block6: {
            retValue = null;
            int C_Calendar_ID = MPeriod.get(ctx, DateAcct, AD_Org_ID).getC_Calendar_ID();
            String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT p.C_Year_ID FROM C_Year y INNER JOIN C_Period p ON (y.C_Year_ID=p.C_Year_ID) WHERE y.C_Calendar_ID=?     AND ? BETWEEN StartDate AND EndDate) AND IsActive=? AND PeriodType=? ORDER BY StartDate";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_Calendar_ID);
                    pstmt.setTimestamp(2, DateAcct);
                    pstmt.setString(3, "Y");
                    pstmt.setString(4, "S");
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MPeriod(ctx, rs, null);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MPeriod(Properties ctx, int C_Period_ID, String trxName) {
        super(ctx, C_Period_ID, trxName);
        if (C_Period_ID == 0) {
            this.setPeriodType("S");
        }
    }

    public MPeriod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPeriod(MYear year, int PeriodNo, String name, Timestamp startDate, Timestamp endDate) {
        this(year.getCtx(), 0, year.get_TrxName());
        this.setClientOrg((PO)year);
        this.setC_Year_ID(year.getC_Year_ID());
        this.setPeriodNo(PeriodNo);
        this.setName(name);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public MPeriodControl[] getPeriodControls(boolean requery) {
        ArrayList<MPeriodControl> list;
        block7: {
            if (this.m_controls != null && !requery) {
                return this.m_controls;
            }
            list = new ArrayList<MPeriodControl>();
            String sql = "SELECT * FROM C_PeriodControl WHERE C_Period_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.getC_Period_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MPeriodControl(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_controls = new MPeriodControl[list.size()];
        list.toArray(this.m_controls);
        return this.m_controls;
    }

    public MPeriodControl getPeriodControl(String DocBaseType) {
        if (DocBaseType == null) {
            return null;
        }
        this.getPeriodControls(false);
        int i = 0;
        while (i < this.m_controls.length) {
            if (DocBaseType.equals(this.m_controls[i].getDocBaseType())) {
                return this.m_controls[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isInPeriod(Timestamp date) {
        Timestamp from;
        if (date == null) {
            return false;
        }
        Timestamp dateOnly = TimeUtil.getDay((Timestamp)date);
        if (dateOnly.before(from = TimeUtil.getDay((Timestamp)this.getStartDate()))) {
            return false;
        }
        Timestamp to = TimeUtil.getDay((Timestamp)this.getEndDate());
        return !dateOnly.after(to);
    }

    public boolean isOpen(String DocBaseType) {
        return this.isOpen(DocBaseType, null);
    }

    public boolean isOpen(String DocBaseType, Timestamp dateAcct) {
        if (!this.isActive()) {
            s_log.warning("Period not active: " + this.getName());
            return false;
        }
        MAcctSchema as = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID()).getAcctSchema();
        if (as != null && as.isAutoPeriodControl()) {
            Timestamp date2;
            Timestamp date1;
            Timestamp today = TimeUtil.trunc((Timestamp)new Timestamp(System.currentTimeMillis()), (String)"D");
            Timestamp first = TimeUtil.addDays((Timestamp)today, (int)(-as.getPeriod_OpenHistory()));
            Timestamp last = TimeUtil.addDays((Timestamp)today, (int)as.getPeriod_OpenFuture());
            if (dateAcct != null) {
                date2 = date1 = TimeUtil.trunc((Timestamp)dateAcct, (String)"D");
            } else {
                date1 = this.getStartDate();
                date2 = this.getEndDate();
            }
            if (date1.before(first)) {
                this.log.warning("Automatic Period Control:" + date1 + " before first day - " + first);
                return false;
            }
            if (date2.after(last)) {
                this.log.warning("Automatic Period Control:" + date2 + " after last day - " + last);
                return false;
            }
            if (this.isInPeriod(today)) {
                as.setC_Period_ID(this.getC_Period_ID());
                as.save();
            }
            return true;
        }
        if (DocBaseType == null) {
            this.log.warning(String.valueOf(this.getName()) + " - No DocBaseType");
            return false;
        }
        MPeriodControl pc = this.getPeriodControl(DocBaseType);
        if (pc == null) {
            this.log.warning(String.valueOf(this.getName()) + " - Period Control not found for " + DocBaseType);
            return false;
        }
        this.log.fine(String.valueOf(this.getName()) + ": " + DocBaseType);
        return pc.isOpen();
    }

    public boolean isStandardPeriod() {
        return "S".equals(this.getPeriodType());
    }

    protected boolean beforeSave(boolean newRecord) {
        Timestamp date = this.getStartDate();
        if (date == null) {
            return false;
        }
        this.setStartDate(TimeUtil.getDay((Timestamp)date));
        date = this.getEndDate();
        if (date != null) {
            this.setEndDate(TimeUtil.getDay((Timestamp)date));
        } else {
            this.setEndDate(TimeUtil.getMonthLastDay((Timestamp)this.getStartDate()));
        }
        if (this.getEndDate().before(this.getStartDate())) {
            SimpleDateFormat df = DisplayType.getDateFormat((int)15);
            this.log.saveError("Error", String.valueOf(df.format(this.getEndDate())) + " < " + df.format(this.getStartDate()));
            return false;
        }
        MYear year = new MYear(this.getCtx(), this.getC_Year_ID(), this.get_TrxName());
        Query query = MTable.get((Properties)this.getCtx(), (String)"C_Period").createQuery("C_Year_ID IN (SELECT y.C_Year_ID from C_Year y WHERE                   y.C_Calendar_ID =?) AND (? BETWEEN StartDate AND EndDate OR ? BETWEEN StartDate AND EndDate) AND PeriodType=?", this.get_TrxName());
        query.setParameters(new Object[]{year.getC_Calendar_ID(), this.getStartDate(), this.getEndDate(), this.getPeriodType()});
        List periods = query.list();
        int i = 0;
        while (i < periods.size()) {
            if (((MPeriod)((Object)periods.get(i))).getC_Period_ID() != this.getC_Period_ID()) {
                this.log.saveError("Error", "Period overlaps with: " + ((MPeriod)((Object)periods.get(i))).getName());
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            MDocType[] types = MDocType.getOfClient((Properties)this.getCtx());
            int count = 0;
            ArrayList<String> baseTypes = new ArrayList<String>();
            int i = 0;
            while (i < types.length) {
                MDocType type = types[i];
                String DocBaseType = type.getDocBaseType();
                if (!baseTypes.contains(DocBaseType)) {
                    MPeriodControl pc = new MPeriodControl(this, DocBaseType);
                    if (pc.save()) {
                        ++count;
                    }
                    baseTypes.add(DocBaseType);
                }
                ++i;
            }
            this.log.fine("PeriodControl #" + count);
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPeriod[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(", ").append(this.getStartDate()).append("-").append(this.getEndDate()).append("]");
        return sb.toString();
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, String docBaseType) throws PeriodClosedException {
        if (!MPeriod.isOpen(ctx, dateAcct, docBaseType)) {
            throw new PeriodClosedException(dateAcct, docBaseType);
        }
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, String docBaseType, int AD_Org_ID) throws PeriodClosedException {
        if (!MPeriod.isOpen(ctx, dateAcct, docBaseType, AD_Org_ID)) {
            throw new PeriodClosedException(dateAcct, docBaseType);
        }
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, int C_DocType_ID) throws PeriodClosedException {
        MDocType dt = MDocType.get((Properties)ctx, (int)C_DocType_ID);
        MPeriod.testPeriodOpen(ctx, dateAcct, dt.getDocBaseType());
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, int C_DocType_ID, int AD_Org_ID) throws PeriodClosedException {
        MDocType dt = MDocType.get((Properties)ctx, (int)C_DocType_ID);
        MPeriod.testPeriodOpen(ctx, dateAcct, dt.getDocBaseType(), AD_Org_ID);
    }

    public int getC_Calendar_ID() {
        if (this.m_C_Calendar_ID == 0) {
            MYear year = (MYear)this.getC_Year();
            if (year != null) {
                this.m_C_Calendar_ID = year.getC_Calendar_ID();
            } else {
                this.log.severe("@NotFound@ C_Year_ID=" + this.getC_Year_ID());
            }
        }
        return this.m_C_Calendar_ID;
    }

    public static int getC_Calendar_ID(Properties ctx, int AD_Org_ID) {
        int C_Calendar_ID = 0;
        if (AD_Org_ID != 0) {
            MOrgInfo info = MOrgInfo.get((Properties)ctx, (int)AD_Org_ID, null);
            C_Calendar_ID = info.getC_Calendar_ID();
        }
        if (C_Calendar_ID == 0) {
            MClientInfo cInfo = MClientInfo.get((Properties)ctx);
            C_Calendar_ID = cInfo.getC_Calendar_ID();
        }
        return C_Calendar_ID;
    }
}

