/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostDetail;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCostDetail
extends X_M_CostDetail {
    private static final long serialVersionUID = -7882724307127281675L;
    private static CLogger s_log = CLogger.getCLogger(MCostDetail.class);

    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        boolean ok;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_OrderLine_ID=" + C_OrderLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_OrderLine_ID=?", C_OrderLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_OrderLine_ID(C_OrderLine_ID);
            MOrder order = new MOrderLine(as.getCtx(), C_OrderLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", order.getDateAcct());
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        boolean ok;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_InvoiceLine_ID=" + C_InvoiceLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_InvoiceLine_ID=?", C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
            MInvoice invoice = new MInvoiceLine(as.getCtx(), C_InvoiceLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", invoice.getDateAcct());
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, String trxName) {
        MClient client;
        boolean ok;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InOutLine_ID=" + M_InOutLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InOutLine_ID=?", M_InOutLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InOutLine_ID(M_InOutLine_ID);
            cd.setIsSOTrx(IsSOTrx);
            MInOut InOut = new MInOutLine(as.getCtx(), M_InOutLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", InOut.getDateAcct());
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        boolean ok;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InventoryLine_ID=" + M_InventoryLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InventoryLine_ID=?", M_InventoryLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InventoryLine_ID(M_InventoryLine_ID);
            MInventory Inventory = new MInventoryLine(as.getCtx(), M_InventoryLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", Inventory.getMovementDate());
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, String trxName) {
        MClient client;
        boolean ok;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_MovementLine_ID=" + M_MovementLine_ID + " AND IsSOTrx=" + (from ? "'Y'" : "'N'") + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_MovementLine_ID=? AND IsSOTrx=" + (from ? "'Y'" : "'N'"), M_MovementLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_MovementLine_ID(M_MovementLine_ID);
            cd.setIsSOTrx(from);
            MMovement Movement = new MMovementLine(as.getCtx(), M_MovementLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", Movement.getMovementDate());
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_ProductionLine_ID=" + M_ProductionLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", M_ProductionLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_ProductionLine_ID(M_ProductionLine_ID);
            cd.set_CustomColumn("Enabled", true);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        X_M_ProductionLine MProdL = new X_M_ProductionLine(as.getCtx(), M_ProductionLine_ID, trxName);
        X_M_ProductionPlan MProdP = new X_M_ProductionPlan(as.getCtx(), MProdL.getM_ProductionPlan_ID(), trxName);
        X_M_Production MProdC = new X_M_Production(as.getCtx(), MProdP.getM_Production_ID(), trxName);
        cd.set_CustomColumn("DateAcct", MProdC.getMovementDate());
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, String trxName) {
        MCostDetail retValue;
        block8: {
            int C_AcctSchema_ID;
            String sql = "SELECT * FROM M_CostDetail WHERE " + whereClause;
            MClientInfo clientInfo = MClientInfo.get((Properties)ctx);
            MAcctSchema primary = clientInfo.getMAcctSchema1();
            int n = C_AcctSchema_ID = primary != null ? primary.getC_AcctSchema_ID() : 0;
            if (C_AcctSchema_ID > 0) {
                sql = String.valueOf(sql) + " AND C_AcctSchema_ID=?";
            }
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, ID);
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                    if (C_AcctSchema_ID > 0) {
                        pstmt.setInt(3, C_AcctSchema_ID);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = new MCostDetail(ctx, rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, String.valueOf(sql) + " - " + ID, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        return retValue;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        String localWhereClause = String.valueOf(whereClause) + " AND M_AttributeSetInstance_ID=?" + " AND C_AcctSchema_ID=?";
        MCostDetail retValue = (MCostDetail)new Query(ctx, "M_CostDetail", localWhereClause, trxName).setParameters(new Object[]{ID, M_AttributeSetInstance_ID, C_AcctSchema_ID}).first();
        return retValue;
    }

    public static boolean processProduct(MProduct product, String trxName) {
        String whereClause = "M_Product_ID=? AND Processed=?";
        int counterOK = 0;
        int counterError = 0;
        List list = new Query(product.getCtx(), "M_CostDetail", "M_Product_ID=? AND Processed=?", trxName).setParameters(new Object[]{product.getM_Product_ID(), false}).setOrderBy("C_AcctSchema_ID, M_CostElement_ID, AD_Org_ID, M_AttributeSetInstance_ID, Created").list();
        for (MCostDetail cd : list) {
            if (cd.process()) {
                ++counterOK;
                continue;
            }
            ++counterError;
        }
        s_log.config("OK=" + counterOK + ", Errors=" + counterError);
        return counterError == 0;
    }

    public MCostDetail(Properties ctx, int M_CostDetail_ID, String trxName) {
        super(ctx, M_CostDetail_ID, trxName);
        if (M_CostDetail_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setProcessed(false);
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setIsSOTrx(false);
            this.setDeltaAmt(Env.ZERO);
            this.setDeltaQty(Env.ZERO);
        }
    }

    public MCostDetail(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    @Override
    public void setAmt(BigDecimal Amt) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Amt - processed");
        }
        if (Amt == null) {
            super.setAmt(Env.ZERO);
        } else {
            super.setAmt(Amt);
        }
    }

    @Override
    public void setQty(BigDecimal Qty) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Qty - processed");
        }
        if (Qty == null) {
            super.setQty(Env.ZERO);
        } else {
            super.setQty(Qty);
        }
    }

    public boolean isOrder() {
        return this.getC_OrderLine_ID() != 0;
    }

    public boolean isInvoice() {
        return this.getC_InvoiceLine_ID() != 0;
    }

    public boolean isShipment() {
        return this.isSOTrx() && this.getM_InOutLine_ID() != 0;
    }

    public boolean isDelta() {
        return this.getDeltaAmt().signum() != 0 || this.getDeltaQty().signum() != 0;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCostDetail[");
        sb.append(this.get_ID());
        if (this.getC_OrderLine_ID() != 0) {
            sb.append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getC_InvoiceLine_ID() != 0) {
            sb.append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            sb.append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID());
        }
        if (this.getM_MovementLine_ID() != 0) {
            sb.append(",M_MovementLine_ID=").append(this.getM_MovementLine_ID());
        }
        if (this.getM_InventoryLine_ID() != 0) {
            sb.append(",M_InventoryLine_ID=").append(this.getM_InventoryLine_ID());
        }
        if (this.getM_ProductionLine_ID() != 0) {
            sb.append(",M_ProductionLine_ID=").append(this.getM_ProductionLine_ID());
        }
        sb.append(",Amt=").append(this.getAmt()).append(",Qty=").append(this.getQty());
        if (this.isDelta()) {
            sb.append(",DeltaAmt=").append(this.getDeltaAmt()).append(",DeltaQty=").append(this.getDeltaQty());
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized boolean process() {
        if (this.isProcessed()) {
            this.log.info("Already processed");
            return true;
        }
        return true;
    }

    private boolean process(MAcctSchema as, MProduct product, MCostElement ce, int Org_ID, int M_ASI_ID) {
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            boolean ok = false;
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            String CostingLevel = product.getCostingLevel(as);
            int Org_ID = this.getAD_Org_ID();
            int M_ASI_ID = this.getM_AttributeSetInstance_ID();
            if ("C".equals(CostingLevel)) {
                Org_ID = 0;
                M_ASI_ID = 0;
            } else if ("O".equals(CostingLevel)) {
                M_ASI_ID = 0;
            } else if ("B".equals(CostingLevel)) {
                Org_ID = 0;
            }
            if (this.getM_CostElement_ID() == 0) {
                MCostElement[] ces = MCostElement.getCostingMethods((PO)this);
                int i = 0;
                while (i < ces.length) {
                    MCostElement ce = ces[i];
                    ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
                    if (ok) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                MCostElement ce = MCostElement.get((Properties)this.getCtx(), (int)this.getM_CostElement_ID());
                ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
            }
            return ok;
        }
        return super.afterDelete(success);
    }

    public synchronized boolean voidline() {
        if (this.getQty().signum() == 0 && this.getAmt().signum() == 0) {
            this.log.info("Already reset");
            return true;
        }
        if (!this.isProcessed()) {
            this.setQty(Env.ZERO);
            this.setAmt(Env.ZERO);
            return this.save();
        }
        if (!((Boolean)this.get_Value("Enabled")).booleanValue()) {
            this.log.info("Record Disabled");
            return true;
        }
        boolean ok = false;
        MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
        String CostingLevel = as.getCostingLevel();
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MProductCategoryAcct pca = MProductCategoryAcct.get((Properties)this.getCtx(), (int)product.getM_Product_Category_ID(), (int)this.getC_AcctSchema_ID(), null);
        if (pca.getCostingLevel() != null) {
            CostingLevel = pca.getCostingLevel();
        }
        int Org_ID = this.getAD_Org_ID();
        int M_ASI_ID = this.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            Org_ID = 0;
            M_ASI_ID = 0;
        } else if ("O".equals(CostingLevel)) {
            M_ASI_ID = 0;
        } else if ("B".equals(CostingLevel)) {
            Org_ID = 0;
        }
        MCost cost = null;
        if (this.getM_CostElement_ID() == 0) {
            MCostElement[] ces = MCostElement.getCostingMethods((PO)this);
            int i = 0;
            while (i < ces.length) {
                MCostElement ce = ces[i];
                if (ce.isStandardCosting()) {
                    cost = MCost.get(product, M_ASI_ID, as, Org_ID, ce.getM_CostElement_ID(), product.get_TrxName());
                }
                ++i;
            }
        } else {
            MCostElement ce = MCostElement.get((Properties)this.getCtx(), (int)this.getM_CostElement_ID());
            cost = MCost.get(product, M_ASI_ID, as, Org_ID, ce.getM_CostElement_ID(), product.get_TrxName());
        }
        cost.add(this.getAmt().negate(), this.getQty().negate());
        cost.save();
        if (ok) {
            this.setQty(Env.ZERO);
            this.setAmt(Env.ZERO);
            ok = this.save();
        }
        this.log.info(String.valueOf(ok) + " - " + this.toString());
        return ok;
    }
}

