/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.model.X_C_CashLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCashLine
extends X_C_CashLine {
    private static final long serialVersionUID = 2962077554051498950L;
    private String m_processMsg = null;
    private MCash m_parent = null;
    private MCashBook m_cashBook = null;
    private MBankAccount m_bankAccount = null;
    private MInvoice m_invoice = null;

    public MCashLine(Properties ctx, int C_CashLine_ID, String trxName) {
        super(ctx, C_CashLine_ID, trxName);
        if (C_CashLine_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setIsGenerated(false);
        }
    }

    public MCashLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCashLine(MCash cash) {
        this(cash.getCtx(), 0, cash.get_TrxName());
        this.setClientOrg((PO)((Object)cash));
        this.setC_Cash_ID(cash.getC_Cash_ID());
        this.m_parent = cash;
        this.m_cashBook = this.m_parent.getCashBook();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public void setInvoice(MInvoice invoice) {
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setCashType("I");
        this.setC_Currency_ID(invoice.getC_Currency_ID());
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)invoice.getC_DocType_ID());
        BigDecimal amt = invoice.getGrandTotal();
        if ("API".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType())) {
            amt = amt.negate();
        }
        this.setAmount(amt);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsGenerated(true);
        this.m_invoice = invoice;
    }

    public void setOrder(MOrder order, String trxName) {
        this.setCashType("I");
        this.setC_Currency_ID(order.getC_Currency_ID());
        BigDecimal amt = order.getGrandTotal();
        this.setAmount(amt);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsGenerated(true);
        if ("WP".equals(order.getDocStatus())) {
            this.saveEx(trxName);
            order.setC_CashLine_ID(this.getC_CashLine_ID());
            order.processIt("WC");
            order.saveEx(trxName);
            MInvoice[] invoices = order.getInvoices();
            int length = invoices.length;
            if (length > 0) {
                this.m_invoice = invoices[length - 1];
                this.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
            }
        }
    }

    public Timestamp getStatementDate() {
        return this.getParent().getStatementDate();
    }

    public MCashLine createReversal() {
        MCash parent = this.getParent();
        if (!parent.isProcessed()) {
            this.setIsActive(false);
            return this;
        }
        parent = MCash.get(this.getCtx(), parent.getAD_Org_ID(), parent.getStatementDate(), parent.getC_Currency_ID(), this.get_TrxName());
        MCashLine reversal = new MCashLine(parent);
        reversal.setClientOrg((PO)((Object)this));
        reversal.setC_BankAccount_ID(this.getC_BankAccount_ID());
        reversal.setC_Charge_ID(this.getC_Charge_ID());
        reversal.setC_Currency_ID(this.getC_Currency_ID());
        reversal.setC_Invoice_ID(this.getC_Invoice_ID());
        reversal.setCashType(this.getCashType());
        reversal.setDescription(this.getDescription());
        reversal.setIsGenerated(true);
        reversal.setAmount(this.getAmount().negate());
        if (this.getDiscountAmt() == null) {
            this.setDiscountAmt(Env.ZERO);
        } else {
            reversal.setDiscountAmt(this.getDiscountAmt().negate());
        }
        if (this.getWriteOffAmt() == null) {
            this.setWriteOffAmt(Env.ZERO);
        } else {
            reversal.setWriteOffAmt(this.getWriteOffAmt().negate());
        }
        reversal.addDescription("(" + this.getLine() + ")");
        return reversal;
    }

    public MCash getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MCash(this.getCtx(), this.getC_Cash_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public MCashBook getCashBook() {
        if (this.m_cashBook == null) {
            this.m_cashBook = MCashBook.get((Properties)this.getCtx(), (int)this.getParent().getC_CashBook_ID());
        }
        return this.m_cashBook;
    }

    public MBankAccount getBankAccount() {
        if (this.m_bankAccount == null && this.getC_BankAccount_ID() != 0) {
            this.m_bankAccount = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        }
        return this.m_bankAccount;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = MInvoice.get(this.getCtx(), this.getC_Invoice_ID());
        }
        return this.m_invoice;
    }

    protected boolean beforeDelete() {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    protected boolean beforeSave(boolean newRecord) {
        boolean verify;
        int count;
        Object generated;
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate((Properties)this.getCtx(), (String)"C_CashLine"));
            return false;
        }
        if (this.is_ValueChanged("C_Invoice_ID") && (generated = this.get_ValueOld("IsGenerated")) != null && ((Boolean)generated).booleanValue()) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotChangeCashGenInvoice"));
            return false;
        }
        if ("T".equals(this.getCashType()) && this.get_ValueAsString("DocumentNo") != null && this.get_ValueAsString("DocumentNo").length() > 0) {
            String mysql = "select count(1) from c_payment where docstatus IN ('CO','DR') and isreceipt='" + (this.getAmount().signum() > 0 ? "N" : "Y") + "' and c_bpartner_id=" + this.get_ValueAsInt("C_BPartner_ID") + " and C_BankAccount_ID=" + this.getC_BankAccount_ID() + " and checkno='" + this.get_ValueAsString("DocumentNo") + "'" + (this.getC_Payment_ID() > 0 ? " and C_payment_ID<>" + this.getC_Payment_ID() : "");
            count = DB.getSQLValue((String)this.get_TrxName(), (String)mysql);
            if (count > 0) {
                this.log.saveError("Error", "Este Pago ya existe no puede ser generado desde una caja");
                this.m_processMsg = "Este Pago ya existe no puede ser generado desde una caja";
                return false;
            }
        }
        if ("T".equals(this.getCashType()) && this.getC_BankAccount_ID() == 0) {
            this.log.saveError("Error", "la cuenta bancaria es obligatoria para este tipo de movimiento");
            return false;
        }
        if ("I".equals(this.getCashType()) && this.getC_Invoice_ID() > 0 && newRecord) {
            this.log.config("Se hara asignacion de monto");
            this.log.config("id factura: " + this.getC_Invoice_ID());
            BigDecimal open = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select invoiceOpen(?, null) from C_Invoice WHERE C_Invoice_ID=?", (Object[])new Object[]{this.getC_Invoice_ID(), this.getC_Invoice_ID()});
            this.log.config("open despues de consulta: " + open + ". factura: " + this.getC_Invoice_ID());
            if (open.signum() == 0) {
                this.log.saveError("Error", "esta Factura no posee monto abierto");
                return false;
            }
            count = DB.getSQLValue((String)this.get_TrxName(), (String)"select count(1) from C_CashLine WHERE C_Cash_ID=? and C_Invoice_ID=? and C_CashLine_ID<>?", (Object[])new Object[]{this.getC_Cash_ID(), this.getC_Invoice_ID(), this.getC_CashLine_ID()});
            if (count > 0) {
                this.log.saveError("Error", "esta Factura ya se encuentra en otra linea");
                return false;
            }
        }
        if ((this.is_ValueChanged("C_Payment_ID") || newRecord) && this.getC_Payment_ID() > 0 && !this.getC_Payment().getDocStatus().equals("CO") && !this.getC_Payment().getDocStatus().equals("CL")) {
            this.log.saveError("Error", "No puede asignar un pago que esta anulado");
            return false;
        }
        if ("I".equals(this.getCashType()) && this.getC_Invoice_ID() == 0) {
            this.setCashType("E");
        }
        if ("T".equals(this.getCashType()) && this.getC_BankAccount_ID() == 0) {
            this.setCashType("E");
        }
        if ("C".equals(this.getCashType()) && this.getC_Charge_ID() == 0) {
            this.setCashType("E");
        }
        boolean bl = verify = newRecord || this.is_ValueChanged("CashType") || this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_BankAccount_ID");
        if (verify) {
            if ("T".equals(this.getCashType())) {
                this.setC_Currency_ID(this.getBankAccount().getC_Currency_ID());
            } else if ("I".equals(this.getCashType())) {
                this.setC_Currency_ID(this.getInvoice().getC_Currency_ID());
            } else {
                this.setC_Currency_ID(this.getCashBook().getC_Currency_ID());
            }
            if ("T".equals(this.getCashType())) {
                this.setAD_Org_ID(this.getBankAccount().getAD_Org_ID());
            } else if ("I".equals(this.getCashType())) {
                this.setAD_Org_ID(this.getCashBook().getAD_Org_ID());
            }
            if (this.getAD_Org_ID() == 0) {
                this.setAD_Org_ID(this.getParent().getAD_Org_ID());
            }
        }
        if (!"T".equals(this.getCashType())) {
            this.setC_BankAccount_ID(I_ZERO);
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_CashLine WHERE C_Cash_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Cash_ID());
            this.setLine(ii);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.isActive() && this.getC_Invoice_ID() > 0) {
            DB.executeUpdate((String)("Update C_Invoice set C_CashLine_ID=" + this.getC_CashLine_ID() + "where C_Invoice_ID=" + this.getC_Invoice_ID()), (String)this.get_TrxName());
        }
        return this.updateHeader();
    }

    private boolean updateHeader() {
        String sql = "UPDATE C_Cash c SET StatementDifference=(SELECT COALESCE(SUM(currencyConvert(cl.Amount, cl.C_Currency_ID, cb.C_Currency_ID, c.DateAcct, 0, c.AD_Client_ID, c.AD_Org_ID)),0) FROM C_CashLine cl, C_CashBook cb WHERE cb.C_CashBook_ID=c.C_CashBook_ID AND cl.C_Cash_ID=c.C_Cash_ID AND cl.IsActive='Y') WHERE C_Cash_ID=" + this.getC_Cash_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.warning("Difference #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_Cash SET EndingBalance = BeginningBalance + StatementDifference WHERE C_Cash_ID=" + this.getC_Cash_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("Balance #" + no);
        }
        return no == 1;
    }
}

