/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutMovement
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, null);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        this.checkQtyAvailableOFB(ctx, mTab, WindowNo, M_Product_ID, (BigDecimal)value);
        return "";
    }

    public String locator(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        this.checkQtyAvailableOFB(ctx, mTab, WindowNo, M_Product_ID, null);
        return "";
    }

    private void checkQtyAvailable(Properties ctx, GridTab mTab, int WindowNo, int M_Product_ID, BigDecimal MovementQty) {
        MProduct product;
        if (M_Product_ID != 0 && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            int M_Locator_ID;
            if (MovementQty == null) {
                MovementQty = (BigDecimal)mTab.getValue("MovementQty");
            }
            if ((M_Locator_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Locator_ID")) <= 0) {
                return;
            }
            int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_AttributeSetInstance_ID");
            BigDecimal available = MStorage.getQtyAvailable(0, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(MovementQty) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            }
        }
    }

    private void checkQtyAvailableOFB(Properties ctx, GridTab mTab, int WindowNo, int M_Product_ID, BigDecimal MovementQty) {
        MProduct product;
        if (M_Product_ID != 0 && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            BigDecimal stock;
            int M_Locator_ID;
            if (MovementQty == null) {
                MovementQty = (BigDecimal)mTab.getValue("MovementQty");
            }
            if ((M_Locator_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Locator_ID")) <= 0) {
                return;
            }
            int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_AttributeSetInstance_ID");
            String mySQL = "select SUM(QtyOnHand) from M_Storage where M_Locator_ID=? and M_Product_ID=?";
            if (M_AttributeSetInstance_ID > 0) {
                mySQL = String.valueOf(mySQL) + " and M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
            }
            if ((stock = DB.getSQLValueBD(null, (String)mySQL, (Object[])new Object[]{M_Locator_ID, M_Product_ID})).compareTo(MovementQty) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", stock.toString(), false);
            }
        }
    }
}

