/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MResource;
import org.compiere.model.OFBProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class CalloutMPMeasure
extends CalloutEngine {
    public String checkAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer AssetMeter_ID = (Integer)mTab.getValue("MP_AssetMeter_ID");
        BigDecimal maxDay = DB.getSQLValueBD(null, (String)("select m.maxday from MP_Meter m inner join MP_ASSETMETER a on (a.MP_Meter_ID=m.MP_Meter_ID) where a.MP_ASSETMETER_ID=" + AssetMeter_ID), (Object[])new Object[0]);
        Timestamp Datetrx = (Timestamp)mTab.getValue("DateTrx");
        BigDecimal Amt = (BigDecimal)value;
        BigDecimal lastAmt = DB.getSQLValueBD(null, (String)"select amt from MP_AssetMeter_Log where MP_AssetMeter_ID=? and DateTrx<? order by datetrx desc", (Object[])new Object[]{AssetMeter_ID, Datetrx});
        Timestamp LastDate = DB.getSQLValueTSEx(null, (String)"select datetrx from MP_AssetMeter_Log where MP_AssetMeter_ID=? and DateTrx<? order by datetrx desc", (Object[])new Object[]{AssetMeter_ID, Datetrx});
        if (lastAmt != null) {
            if (Amt.compareTo(lastAmt) < 0) {
                mTab.fireDataStatusEEvent("La entrada es inferior a una entrada anterior", "", false);
            }
            if (LastDate != null) {
                long diferenciaMils = Datetrx.getTime() - LastDate.getTime();
                long segundos = diferenciaMils / 1000L;
                long horas = segundos / 3600L;
                int dias = (int)(horas / 24L);
                BigDecimal diff = Amt.subtract(lastAmt);
                if (diff.compareTo(new BigDecimal(maxDay.intValue() * dias)) > 0) {
                    mTab.fireDataStatusEEvent("La entrada supera el maximo por dias", "", false);
                }
            }
        }
        return "";
    }

    public String getProductCost(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = (Integer)value;
        BigDecimal cost = OFBProductCost.getProductCost(M_Product_ID, (Integer)mTab.getValue("AD_Org_ID"), Env.ONE, Trx.createTrxName(), ctx);
        mTab.setValue("CostAmt", (Object)cost);
        return "";
    }

    public String getBOMCost(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_BOM_ID = (Integer)value;
        MPPProductBOM bom = new MPPProductBOM(ctx, M_BOM_ID, null);
        MPPProductBOMLine[] lista = bom.getLines();
        String Trxname = Trx.createTrxName();
        BigDecimal cost = Env.ZERO;
        int i = 0;
        while (i < lista.length) {
            cost = cost.add(OFBProductCost.getProductCost(lista[i].getM_Product_ID(), (Integer)mTab.getValue("AD_Org_ID"), lista[i].getQtyBOM(), Trxname, ctx));
            ++i;
        }
        mTab.setValue("CostAmt", (Object)cost);
        return "";
    }

    public String getResourceCost(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int Resource_ID = (Integer)value;
        MResource resource = new MResource(ctx, Resource_ID, null);
        mTab.setValue("CostNormal", (Object)((BigDecimal)resource.get_Value("CostNormal")));
        mTab.setValue("CostExtra", (Object)((BigDecimal)resource.get_Value("CostExtra")));
        return "";
    }

    public String calcAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal CE;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        BigDecimal CN = mTab.getValue("CostNormal") == null ? Env.ZERO : (BigDecimal)mTab.getValue("CostNormal");
        BigDecimal bigDecimal = CE = mTab.getValue("CostExtra") == null ? Env.ZERO : (BigDecimal)mTab.getValue("CostExtra");
        if (mField.getColumnName().equals("ResourceQty") || mField.getColumnName().equals("ResourceQtyExtra")) {
            CN = (mTab.getValue("ResourceQty") == null ? Env.ZERO : (BigDecimal)mTab.getValue("ResourceQty")).multiply(CN);
            CE = (mTab.getValue("ResourceQtyExtra") == null ? Env.ZERO : (BigDecimal)mTab.getValue("ResourceQtyExtra")).multiply(CE);
        }
        mTab.setValue("CostAmt", (Object)CN.add(CE));
        return "";
    }
}

