/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.X_MP_JobStandar;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.model.X_MP_OT_Task;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VMPRequestOT
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener,
ASyncProcess {
    private static final long serialVersionUID = -5322824600164192235L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMPRequestOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private CPanel mainPanel = new CPanel();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel allocationPanel = new CPanel();
    private MiniTable requestTable = new MiniTable();
    private CPanel infoPanel = new CPanel();
    private int m_A_Asset_ID = 0;
    private int m_Job_ID = 0;
    private CPanel requestPanel = new CPanel();
    private JLabel requestLabel = new JLabel();
    private BorderLayout requestLayout = new BorderLayout();
    private JLabel requestInfo = new JLabel();
    private JScrollPane requestScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton ProcessButton = new JButton();
    private JButton VoidButton = new JButton();
    private JButton searchButton = new JButton();
    private JButton addButton = new JButton();
    private JButton EnableButton = new JButton();
    private JButton ChangeButton = new JButton();
    private JLabel assetLabel = new JLabel();
    private JCheckBox selectall = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private VLookup assetSearch = null;
    private JLabel jobLabel = new JLabel();
    private VLookup jobSearch = null;
    private JButton jobButton = new JButton();

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"Y");
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)((Object)this));
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.dateLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocDate", (boolean)false));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.allocationPanel.setLayout((LayoutManager)this.allocationLayout);
        this.requestLabel.setRequestFocusEnabled(false);
        this.requestLabel.setText("Request List");
        this.requestPanel.setLayout((LayoutManager)this.requestLayout);
        this.requestInfo.setHorizontalAlignment(4);
        this.requestInfo.setHorizontalTextPosition(4);
        this.requestInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.ProcessButton.setText("Generar OT");
        this.ProcessButton.addActionListener(this);
        this.VoidButton.setText("Rechazar Solicitud");
        this.VoidButton.addActionListener(this);
        this.searchButton.setText("Buscar");
        this.searchButton.addActionListener(this);
        this.addButton.setText("Agregar Seleccion");
        this.addButton.addActionListener(this);
        this.EnableButton.setText("Habilitar Edicion");
        this.EnableButton.addActionListener(this);
        this.ChangeButton.setText("Aplicar Fecha");
        this.ChangeButton.addActionListener(this);
        this.jobButton.setText("Asignar Estandar");
        this.jobButton.addActionListener(this);
        this.jobLabel.setText("Estandar");
        this.assetLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"A_Asset_ID"));
        this.selectall.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Select all"));
        this.selectall.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.requestScrollPane.setPreferredSize(new Dimension(300, 300));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.parameterPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.ChangeButton, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetLabel, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetSearch, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.selectall, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.jobLabel, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.jobSearch, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.jobButton, (Object)new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, (Object)"South");
        this.allocationPanel.add((Component)this.VoidButton, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.ProcessButton, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.requestPanel.add((Component)this.requestLabel, (Object)"North");
        this.requestPanel.add((Component)this.requestInfo, (Object)"South");
        this.requestPanel.add((Component)this.requestScrollPane, (Object)"Center");
        this.requestScrollPane.getViewport().add((Component)((Object)this.requestTable), null);
        this.mainPanel.add((Component)this.infoPanel, (Object)"Center");
        this.infoPanel.setLayout((LayoutManager)new BorderLayout());
        this.infoPanel.add((Component)this.requestPanel, (Object)"Center");
        this.infoPanel.setPreferredSize(new Dimension(1000, 450));
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID((String)"MP_Maintain", (String)"A_Asset_ID");
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.assetSearch = new VLookup("A_Asset_ID", true, false, true, (Lookup)lookupBP);
        this.assetSearch.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID((String)"MP_Maintain", (String)"MP_JobStandar_ID");
        MLookup lookupjob = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.jobSearch = new VLookup("MP_JobStandar_ID", true, false, true, (Lookup)lookupjob);
        this.jobSearch.addVetoableChangeListener((VetoableChangeListener)this);
        this.dateField.setValue((Object)Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.statusBar.setStatusLine("Seleccione la mantencion, cambie la fecha pronosticada o genere directamente la OT ");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select rt.DATEDOC,rt.DATEREQUIRED,rt.DOCUMENTNO,rt.MP_OT_REQUEST_ID, rt.AD_Org_ID, rt.AD_User_ID, rt.A_Asset_ID, rt.MP_JOBSTANDAR_ID, rt.Description, u.name, a.name as AssetName, jo.name as jobName,rl.name as PriorityRule, rt.OT_Request_Type from MP_OT_REQUEST rt inner join AD_User u on (rt.AD_User_ID=u.AD_User_ID) inner join A_Asset a on (rt.A_Asset_ID=a.A_Asset_ID) left outer join MP_JOBSTANDAR jo on (rt.MP_JOBSTANDAR_ID=jo.MP_JOBSTANDAR_ID) inner join AD_Ref_List rl on (rt.PriorityRule=rl.value and rl. AD_Reference_ID=154) where rt.DocStatus='WC' and rt.processed='Y'");
        sql.append(" and rt.AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
        log.config("Prognosis=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            String tipo = new String();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                if (rs.getString(14).equals("RV")) {
                    tipo = "Revision";
                }
                if (rs.getString(14).equals("RP")) {
                    tipo = "Reparacion";
                }
                if (rs.getString(14).equals("CN")) {
                    tipo = "Completar Niveles";
                }
                line.add(tipo);
                line.add(rs.getTimestamp(2));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(3));
                line.add(pp);
                line.add(rs.getTimestamp(1));
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(6), rs.getString(10));
                line.add(pp2);
                KeyNamePair pp3 = new KeyNamePair(rs.getInt(7), rs.getString(11));
                line.add(pp3);
                line.add(rs.getString(9));
                line.add(rs.getString(13));
                KeyNamePair pp4 = new KeyNamePair(rs.getInt(8), rs.getString(12));
                line.add(pp4);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.requestTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Seleccionar");
        columnNames.add("Tipo Solicitud");
        columnNames.add("Fecha Programacion");
        columnNames.add("Num Solicitud");
        columnNames.add("Fecha Solicitud");
        columnNames.add("Usuario");
        columnNames.add("Activo");
        columnNames.add("Descripcion");
        columnNames.add("Prioridad");
        columnNames.add("Trabajo Estandar");
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.requestTable.setModel(modelP);
        int i = 0;
        this.requestTable.setColumnClass(i++, Boolean.class, false);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, Timestamp.class, false);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, Timestamp.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.autoSize();
        this.requestTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            log.config("");
                            if (!e.getSource().equals(this.ProcessButton)) break block8;
                            this.saveData();
                            break block9;
                        }
                        if (!e.getSource().equals(this.jobButton)) break block10;
                        TableModel prognosis = this.requestTable.getModel();
                        int rows = prognosis.getRowCount();
                        X_MP_JobStandar job = new X_MP_JobStandar(Env.getCtx(), this.m_Job_ID, null);
                        int i = 0;
                        while (i < rows) {
                            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                                KeyNamePair pp = new KeyNamePair(job.getMP_JobStandar_ID(), job.getName());
                                prognosis.setValueAt(pp, i, 9);
                            }
                            ++i;
                        }
                        break block9;
                    }
                    if (!e.getSource().equals(this.VoidButton)) break block11;
                    this.voidData();
                    break block9;
                }
                if (!e.getSource().equals(this.ChangeButton)) break block12;
                this.ProcessButton.setEnabled(true);
                TableModel prognosis = this.requestTable.getModel();
                int rows = prognosis.getRowCount();
                Timestamp DateTrx = (Timestamp)this.dateField.getValue();
                int i = 0;
                while (i < rows) {
                    if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                        prognosis.setValueAt(DateTrx, i, 2);
                    }
                    ++i;
                }
                break block9;
            }
            if (!e.getSource().equals(this.selectall)) break block9;
            TableModel prognosis = this.requestTable.getModel();
            int rows = prognosis.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 6);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            this.m_A_Asset_ID = (Integer)value;
        } else if (name.equals("MP_JobStandar_ID")) {
            this.jobSearch.setValue(value);
            this.m_Job_ID = (Integer)value;
        }
    }

    private void saveData() {
        TableModel prognosis = this.requestTable.getModel();
        int rows = prognosis.getRowCount();
        Trx trx = Trx.get((String)Trx.createTrxName((String)"AL"), (boolean)true);
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                pp = (KeyNamePair)prognosis.getValueAt(i, 6);
                int Asset_ID = pp.getKey();
                Timestamp Datetrx = (Timestamp)prognosis.getValueAt(i, 2);
                String description = (String)prognosis.getValueAt(i, 7);
                int job_id = 0;
                if (prognosis.getValueAt(i, 9) != null) {
                    pp = (KeyNamePair)prognosis.getValueAt(i, 9);
                    job_id = pp.getKey();
                }
                if (!this.createOT(job_id, Datetrx, description, Asset_ID, Req_ID)) {
                    log.log(Level.SEVERE, "OT not created #" + i);
                } else {
                    String sql = "Update MP_OT_REQUEST set DocStatus='AP',MP_JobStandar_ID=" + job_id + " where MP_OT_REQUEST_ID=" + Req_ID;
                    DB.executeUpdate((String)sql);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    private void voidData() {
        TableModel prognosis = this.requestTable.getModel();
        int rows = prognosis.getRowCount();
        Trx trx = Trx.get((String)Trx.createTrxName((String)"AL"), (boolean)true);
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                String sql = "Update MP_OT_REQUEST set DocStatus='VO' where MP_OT_REQUEST_ID=" + Req_ID;
                DB.executeUpdate((String)sql);
            }
            ++i;
        }
        this.loadMPs();
    }

    public boolean createOT(int Job_ID, Timestamp Datetrx, String description, int Asset_ID, int Req_ID) {
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_JobStandar_ID(Job_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setMP_OT_Request_ID(Req_ID);
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"OTC")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        return this.createOTTaskDetail(Job_ID, newOT);
    }

    public void lookChilds(int MP_ID, X_MP_OT OT) {
        String sql = "select mp_maintain_id from mp_maintain where ischild='Y' and MP_MAINTAINPARENT_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, MP_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createOTTaskDetail(rs.getInt(1), OT);
                this.lookChilds(rs.getInt(1), OT);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public boolean createOTTaskDetail(int Job_ID, X_MP_OT OT) {
        String sql = "select * from MP_JOBSTANDAR_TASK where MP_JOBSTANDAR_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, Job_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Task ta = new X_MP_OT_Task(Env.getCtx(), 0, null);
                ta.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                ta.setMP_OT_ID(OT.getMP_OT_ID());
                ta.setDescription(rs.getString("Description"));
                ta.setDuration(rs.getBigDecimal("Duration"));
                ta.setC_UOM_ID(rs.getInt("C_UOM_ID"));
                ta.setStatus("NS");
                ta.saveEx();
                this.createOTResourceDetail(rs.getInt("MP_JOBSTANDAR_TASK_ID"), ta.getMP_OT_Task_ID());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID) {
        String sql = "select * from MP_JOBSTANDAR_RESOURCE where MP_JOBSTANDAR_TASK_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, oldTask_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
                re.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                re.setMP_OT_Task_ID(newTask_ID);
                re.setCostAmt(rs.getBigDecimal("CostAmt"));
                re.setS_Resource_ID(rs.getInt("S_Resource_ID"));
                re.setM_BOM_ID(rs.getInt("M_BOM_ID"));
                re.setResourceQty(rs.getBigDecimal("RESOURCEQTY"));
                re.setResourceType(rs.getString("RESOURCETYPE"));
                re.set_ValueOfColumn("M_Product_ID", (Object)rs.getInt("M_Product_ID"));
                re.saveEx();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }

    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean isUILocked() {
        return this.isEnabled();
    }

    public void executeASync(ProcessInfo pi) {
    }
}

