/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.SwingWorker;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.impexp.ImpFormat;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.model.MRole;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class VFileImport
extends CPanel
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = 3996535986364873964L;
    private static final int MAX_LOADED_LINES = 100;
    private static final int MAX_SHOWN_LINES = 10;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private ArrayList<String> m_data = new ArrayList();
    private ImpFormat m_format;
    private JLabel[] m_labels;
    private JTextField[] m_fields;
    private int m_record = -1;
    private File m_file = null;
    private static CLogger log = CLogger.getCLogger(VFileImport.class);
    private static final String s_none = "----";
    private CPanel northPanel = new CPanel();
    private JButton bFile = new JButton();
    private JComboBox pickFormat = new JComboBox();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private JScrollPane rawDataPane = new JScrollPane();
    private JTextArea rawData = new JTextArea();
    private JScrollPane previewPane = new JScrollPane();
    private CPanel previewPanel = new CPanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JLabel info = new JLabel();
    private JLabel labelFormat = new JLabel();
    private GridBagLayout previewLayout = new GridBagLayout();
    private JButton bNext = new JButton();
    private JButton bPrevious = new JButton();
    private JLabel record = new JLabel();
    private CComboBox fCharset = new CComboBox((Object[])Ini.getAvailableCharsets());

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.northPanel, "North");
            frame.getContentPane().add((Component)this.centerPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)((Object)this));
        this.bFile.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        this.bFile.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFileInfo"));
        this.bFile.addActionListener(this);
        this.fCharset.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Charset", (boolean)false));
        this.info.setText("   ");
        this.labelFormat.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_ImpFormat_ID"));
        this.bNext.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Next"));
        this.bNext.setMargin(new Insets(2, 2, 2, 2));
        this.bNext.setText(">");
        this.bNext.addActionListener(this);
        this.record.setText("------");
        this.bPrevious.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Previous"));
        this.bPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.bPrevious.setText("<");
        this.bPrevious.addActionListener(this);
        this.northPanel.setBorder(BorderFactory.createEtchedBorder());
        this.northPanel.add((Component)this.bFile, null);
        this.northPanel.add((Component)this.fCharset);
        this.northPanel.add((Component)this.info, null);
        this.northPanel.add((Component)this.labelFormat, null);
        this.northPanel.add((Component)this.pickFormat, null);
        this.northPanel.add((Component)this.bPrevious, null);
        this.northPanel.add((Component)this.record, null);
        this.northPanel.add((Component)this.bNext, null);
        this.centerPanel.setLayout((LayoutManager)this.centerLayout);
        this.rawData.setFont(new Font("Monospaced", 0, 10));
        this.rawData.setColumns(80);
        this.rawData.setRows(10);
        this.rawDataPane.getViewport().add((Component)this.rawData, null);
        this.centerPanel.add((Component)this.rawDataPane, (Object)"Center");
        this.centerPanel.add((Component)this.previewPane, (Object)"South");
        this.previewPanel.setLayout((LayoutManager)this.previewLayout);
        this.previewPane.getViewport().add((Component)this.previewPanel, null);
        this.previewPane.setPreferredSize(new Dimension(700, 80));
        this.confirmPanel.addActionListener((ActionListener)this);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() {
        this.pickFormat.addItem(s_none);
        String sql = MRole.getDefault().addAccessSQL("SELECT Name FROM AD_ImpFormat", "AD_ImpFormat", true, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.pickFormat.addItem(rs.getString(1));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.pickFormat.setSelectedIndex(0);
        this.pickFormat.addActionListener(this);
        this.fCharset.setSelectedItem((Object)Ini.getCharset());
        this.fCharset.addActionListener((ActionListener)this);
        this.confirmPanel.getOKButton().setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bFile) {
            this.cmd_loadFile();
            this.invalidate();
            this.m_frame.pack();
        } else if (e.getSource() == this.fCharset) {
            int record = this.m_record;
            this.cmd_reloadFile();
            this.m_record = record - 1;
            this.cmd_applyFormat(true);
        } else if (e.getSource() == this.pickFormat) {
            this.cmd_loadFormat();
            this.invalidate();
            this.m_frame.pack();
        } else if (e.getSource() == this.bNext) {
            this.cmd_applyFormat(true);
        } else if (e.getSource() == this.bPrevious) {
            this.cmd_applyFormat(false);
        } else if (e.getActionCommand().equals("Ok")) {
            this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
            this.confirmPanel.setEnabled(false);
            this.m_frame.setBusy(true);
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    VFileImport.this.cmd_process();
                    return Boolean.TRUE;
                }
            };
            worker.start();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        if (this.m_data != null && this.m_data.size() > 0 && this.m_format != null && this.m_format.getRowCount() > 0) {
            this.confirmPanel.getOKButton().setEnabled(true);
        } else {
            this.confirmPanel.getOKButton().setEnabled(false);
        }
    }

    private void cmd_loadFile() {
        String directory = String.valueOf(Adempiere.getAdempiereHome()) + File.separator + "data" + File.separator + "import";
        log.config(directory);
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFileInfo"));
        if (chooser.showOpenDialog((Component)((Object)this)) != 0) {
            return;
        }
        this.m_file = chooser.getSelectedFile();
        log.config(this.m_file.getName());
        this.bFile.setText(this.m_file.getName());
        this.cmd_reloadFile();
    }

    private void cmd_reloadFile() {
        if (this.m_file == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_data.clear();
        this.rawData.setText("");
        try {
            Charset charset = (Charset)this.fCharset.getSelectedItem();
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_file), charset), 10240);
            String s = null;
            while ((s = in.readLine()) != null) {
                this.m_data.add(s);
                if (this.m_data.size() > 100) continue;
                this.rawData.append(s);
                this.rawData.append("\n");
            }
            in.close();
            this.rawData.setCaretPosition(0);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            this.bFile.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        }
        int index = 1;
        if (this.m_data.size() == 1) {
            index = 0;
        }
        int length = 0;
        if (this.m_data.size() > 0) {
            length = this.m_data.get(index).toString().length();
        }
        this.info.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Records")) + "=" + this.m_data.size() + ", " + Msg.getMsg((Properties)Env.getCtx(), (String)"Length") + "=" + length + "   ");
        this.setCursor(Cursor.getDefaultCursor());
        log.config("Records=" + this.m_data.size() + ", Length=" + length);
    }

    private void cmd_loadFormat() {
        this.previewPanel.removeAll();
        String formatName = this.pickFormat.getSelectedItem().toString();
        if (formatName.equals(s_none)) {
            return;
        }
        this.m_format = ImpFormat.load(formatName);
        if (this.m_format == null) {
            ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"FileImportNoFormat", (String)formatName);
            return;
        }
        int size = this.m_format.getRowCount();
        this.m_labels = new JLabel[size];
        this.m_fields = new JTextField[size];
        int i = 0;
        while (i < size) {
            ImpFormatRow row = this.m_format.getRow(i);
            this.m_labels[i] = new JLabel(row.getColumnName());
            this.previewPanel.add((Component)this.m_labels[i], (Object)new GridBagConstraints(i, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
            int length = row.getEndNo() - row.getStartNo();
            if (length <= 5) {
                length = 5;
            } else if (length > 20) {
                length = 20;
            }
            this.m_fields[i] = new JTextField(length);
            this.previewPanel.add((Component)this.m_fields[i], (Object)new GridBagConstraints(i, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
            ++i;
        }
        this.m_record = -1;
        this.record.setText("------");
        this.previewPanel.invalidate();
        this.previewPanel.repaint();
    }

    private void cmd_applyFormat(boolean next) {
        if (this.m_format == null || this.m_data.size() == 0) {
            return;
        }
        this.m_record = next ? ++this.m_record : --this.m_record;
        if (this.m_record < 0) {
            this.m_record = 0;
        } else if (this.m_record >= this.m_data.size()) {
            this.m_record = this.m_data.size() - 1;
        }
        this.record.setText(" " + String.valueOf(this.m_record + 1) + " ");
        String[] lInfo = this.m_format.parseLine(this.m_data.get(this.m_record).toString(), false, true, false);
        int size = this.m_format.getRowCount();
        if (lInfo.length != size) {
            log.log(Level.SEVERE, "FormatElements=" + size + " != Fields=" + lInfo.length);
        }
        int i = 0;
        while (i < size) {
            this.m_fields[i].setText(lInfo[i]);
            this.m_fields[i].setCaretPosition(0);
            ++i;
        }
    }

    private void cmd_process() {
        if (this.m_format == null) {
            ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"FileImportNoFormat");
            return;
        }
        log.config(this.m_format.getName());
        int row = 0;
        int imported = 0;
        row = 0;
        while (row < this.m_data.size()) {
            if (this.m_format.updateDB(Env.getCtx(), this.m_data.get(row).toString(), null, row)) {
                ++imported;
            }
            ++row;
        }
        ADialog.info((int)this.m_WindowNo, (Container)((Object)this), (String)"FileImportR/I", (String)(String.valueOf(row) + " / " + imported + "#"));
        this.dispose();
    }
}

