/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.adempiere.pdf.Document;
import org.adempiere.pdf.viewer.PDFViewerBean;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextArea;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class Attachment
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 2497487523050526742L;
    private int m_WindowNo;
    private MAttachment m_attachment;
    private boolean m_change = false;
    private static CLogger log = CLogger.getCLogger(Attachment.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CTextArea text = new CTextArea();
    private CButton bOpen = new CButton();
    private CButton bSave = new CButton();
    private CPanel northPanel = new CPanel();
    private CButton bLoad = new CButton();
    private BorderLayout northLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel toolBar = new CPanel((LayoutManager)new FlowLayout(3, 5, 5));
    private CButton bDelete = new CButton();
    private CButton bDeleteAll = null;
    private CComboBox cbContent = new CComboBox();
    private JSplitPane centerPane = new JSplitPane();
    private CPanel graphPanel = new CPanel((LayoutManager)new BorderLayout());
    private GImage gifPanel = new GImage();
    private JScrollPane gifScroll = new JScrollPane(this.gifPanel);
    private PDFViewerBean pdfViewer = Document.getViewer();
    private CTextArea info = new CTextArea();

    public Attachment(Frame frame, int WindowNo, int AD_Attachment_ID, int AD_Table_ID, int Record_ID, String trxName) {
        super(frame, Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment"), true);
        log.config("ID=" + AD_Attachment_ID + ", Table=" + AD_Table_ID + ", Record=" + Record_ID);
        this.m_WindowNo = WindowNo;
        try {
            this.staticInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.m_attachment = AD_Attachment_ID == 0 ? new MAttachment(Env.getCtx(), AD_Table_ID, Record_ID, trxName) : new MAttachment(Env.getCtx(), AD_Attachment_ID, trxName);
        this.loadAttachments();
        try {
            AEnv.showCenterWindow((Window)frame, (Window)((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.text.requestFocus();
    }

    void staticInit() throws Exception {
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.getContentPane().add((Component)this.mainPanel);
        this.northPanel.setLayout((LayoutManager)this.northLayout);
        this.northPanel.add((Component)this.toolBar, (Object)"Center");
        this.toolBar.add((Component)this.bLoad);
        this.toolBar.add((Component)this.bDelete);
        this.toolBar.add((Component)this.bSave);
        this.toolBar.add((Component)this.bOpen);
        this.toolBar.add((Component)this.cbContent);
        this.mainPanel.add((Component)this.northPanel, (Object)"North");
        this.bOpen.setEnabled(false);
        this.bOpen.setIcon((Icon)Env.getImageIcon((String)"Editor24.gif"));
        this.bOpen.setMargin(new Insets(0, 2, 0, 2));
        this.bOpen.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Open"));
        this.bOpen.addActionListener((ActionListener)this);
        this.bSave.setEnabled(false);
        this.bSave.setIcon((Icon)Env.getImageIcon((String)"Export24.gif"));
        this.bSave.setMargin(new Insets(0, 2, 0, 2));
        this.bSave.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AttachmentSave"));
        this.bSave.addActionListener((ActionListener)this);
        this.bLoad.setIcon((Icon)Env.getImageIcon((String)"Import24.gif"));
        this.bLoad.setMargin(new Insets(0, 2, 0, 2));
        this.bLoad.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Load"));
        this.bLoad.addActionListener((ActionListener)this);
        this.bDelete.setIcon((Icon)Env.getImageIcon((String)"Delete24.gif"));
        this.bDelete.setMargin(new Insets(0, 2, 0, 2));
        this.bDelete.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Delete"));
        this.bDelete.addActionListener((ActionListener)this);
        Dimension size = this.cbContent.getPreferredSize();
        size.width = 200;
        this.cbContent.setPreferredSize(size);
        this.cbContent.addActionListener((ActionListener)this);
        this.cbContent.setLightWeightPopupEnabled(false);
        this.text.setBackground(AdempierePLAF.getInfoBackground());
        this.text.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.add((Component)this.confirmPanel, (Object)"South");
        this.confirmPanel.addActionListener((ActionListener)this);
        this.bDeleteAll = ConfirmPanel.createDeleteButton((boolean)true);
        this.confirmPanel.addButton((JButton)this.bDeleteAll);
        this.bDeleteAll.addActionListener((ActionListener)this);
        this.info.setText("-");
        this.info.setReadWrite(false);
        this.graphPanel.add((Component)this.info, (Object)"Center");
        this.mainPanel.add((Component)this.centerPane, (Object)"Center");
        this.centerPane.add((Component)this.graphPanel, "left");
        this.centerPane.add((Component)this.text, "right");
        this.centerPane.setResizeWeight(0.75);
    }

    public void dispose() {
        this.pdfViewer = null;
        super.dispose();
    }

    private void loadAttachments() {
        log.config("");
        String sText = this.m_attachment.getTextMsg();
        if (sText == null) {
            this.text.setText("");
        } else {
            this.text.setText(sText);
        }
        int size = this.m_attachment.getEntryCount();
        int i = 0;
        while (i < size) {
            this.cbContent.addItem((Object)this.m_attachment.getEntryName(i));
            ++i;
        }
        if (size > 0) {
            this.cbContent.setSelectedIndex(0);
        } else {
            this.displayData(0);
        }
    }

    private void displayData(int index) {
        MAttachmentEntry entry = this.m_attachment.getEntry(index);
        log.config("Index=" + index + " - " + entry);
        this.gifPanel.setImage(null);
        this.graphPanel.removeAll();
        this.bDelete.setEnabled(false);
        this.bOpen.setEnabled(false);
        this.bSave.setEnabled(false);
        Dimension size = null;
        if (entry == null || entry.getData() == null) {
            this.info.setText("-");
        } else {
            this.bOpen.setEnabled(true);
            this.bSave.setEnabled(true);
            this.bDelete.setEnabled(true);
            log.config(entry.toStringX());
            this.info.setText(entry.toStringX());
            if (entry.isPDF() && this.pdfViewer != null) {
                try {
                    this.pdfViewer.loadPDF(entry.getInputStream());
                    this.pdfViewer.setScale(50);
                    size = this.pdfViewer.getPreferredSize();
                    this.graphPanel.add((Component)this.pdfViewer, (Object)"Center");
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "(pdf)", (Throwable)e);
                }
            } else if (entry.isGraphic()) {
                Image image = Toolkit.getDefaultToolkit().createImage(entry.getData());
                if (image != null) {
                    this.gifPanel.setImage(image);
                    size = this.gifPanel.getPreferredSize();
                    if (size.width == -1 && size.height == -1) {
                        log.log(Level.SEVERE, "Invalid Image");
                    } else {
                        this.graphPanel.add((Component)this.gifScroll, (Object)"Center");
                    }
                } else {
                    log.log(Level.SEVERE, "Could not create image");
                }
            }
        }
        if (this.graphPanel.getComponentCount() == 0) {
            this.graphPanel.add((Component)this.info, (Object)"Center");
        }
        log.config("Size=" + size);
        this.pack();
    }

    private String getFileName(int index) {
        String fileName = null;
        if (this.cbContent.getItemCount() > index) {
            fileName = (String)this.cbContent.getItemAt(index);
        }
        return fileName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            String oldText;
            String newText = this.text.getText();
            if (newText == null) {
                newText = "";
            }
            if ((oldText = this.m_attachment.getTextMsg()) == null) {
                oldText = "";
            }
            if (!this.m_change) {
                boolean bl = this.m_change = !newText.equals(oldText);
            }
            if (newText.length() > 0 || this.m_attachment.getEntryCount() > 0) {
                if (this.m_change) {
                    this.m_attachment.setBinaryData(new byte[0]);
                    this.m_attachment.setTextMsg(this.text.getText());
                    this.m_attachment.save();
                }
            } else {
                this.m_attachment.delete(true);
            }
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() == this.bDeleteAll) {
            this.deleteAttachment();
            this.dispose();
        } else if (e.getSource() == this.bDelete) {
            this.deleteAttachmentEntry();
        } else if (e.getSource() == this.cbContent) {
            this.displayData(this.cbContent.getSelectedIndex());
        } else if (e.getSource() == this.bLoad) {
            this.loadFile();
        } else if (e.getSource() == this.bSave) {
            this.saveAttachmentToFile();
        } else if (e.getSource() == this.bOpen && !this.openAttachment()) {
            this.saveAttachmentToFile();
        }
    }

    private void loadFile() {
        File[] files;
        log.info("");
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"AttachmentNew"));
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal != 0) {
            return;
        }
        File[] fileArray = files = chooser.getSelectedFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            int cnt = this.m_attachment.getEntryCount();
            boolean add = true;
            int i = 0;
            while (i < cnt) {
                if (this.m_attachment.getEntryName(i).equals(file.getName())) {
                    if (this.m_attachment.updateEntry(i, file)) {
                        this.cbContent.setSelectedItem((Object)file.getName());
                        this.m_change = true;
                    }
                    add = false;
                    break;
                }
                ++i;
            }
            if (add && this.m_attachment.addEntry(file)) {
                this.cbContent.addItem((Object)file.getName());
                this.cbContent.setSelectedIndex(this.cbContent.getItemCount() - 1);
                this.m_change = true;
            }
            ++n2;
        }
    }

    private void deleteAttachment() {
        log.info("");
        if (!this.canDelete()) {
            ADialog.warn((int)this.m_WindowNo, (Container)((Object)this), (String)"AttachmentDelete", (String)"Este rol no tiene permisos de borrar Attachment");
            return;
        }
        if (ADialog.ask((int)this.m_WindowNo, (Container)((Object)this), (String)"AttachmentDelete?")) {
            this.m_attachment.delete(true);
        }
    }

    private void deleteAttachmentEntry() {
        log.info("");
        if (!this.canDelete()) {
            ADialog.warn((int)this.m_WindowNo, (Container)((Object)this), (String)"AttachmentDelete", (String)"Este rol no tiene permisos de borrar Attachment");
            return;
        }
        int index = this.cbContent.getSelectedIndex();
        String fileName = this.getFileName(index);
        if (fileName == null) {
            return;
        }
        if (ADialog.ask((int)this.m_WindowNo, (Container)((Object)this), (String)"AttachmentDeleteEntry?", (String)fileName)) {
            if (this.m_attachment.deleteEntry(index)) {
                this.cbContent.removeItemAt(index);
            }
            this.m_change = true;
        }
    }

    private void saveAttachmentToFile() {
        int index = this.cbContent.getSelectedIndex();
        log.info("index=" + index);
        if (this.m_attachment.getEntryCount() < index) {
            return;
        }
        String fileName = this.getFileName(index);
        String ext = fileName.substring(fileName.lastIndexOf(46));
        log.config("Ext=" + ext);
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setDialogTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"AttachmentSave"));
        File f = new File(fileName);
        chooser.setSelectedFile(f);
        int returnVal = chooser.showSaveDialog((Component)((Object)this));
        if (returnVal != 0) {
            return;
        }
        File saveFile = chooser.getSelectedFile();
        if (saveFile == null) {
            return;
        }
        log.config("Save to " + saveFile.getAbsolutePath());
        this.m_attachment.getEntryFile(index, saveFile);
    }

    private boolean openAttachment() {
        File tempFile;
        block5: {
            int index = this.cbContent.getSelectedIndex();
            byte[] data = this.m_attachment.getEntryData(index);
            if (data == null) {
                return false;
            }
            String fileName = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + this.m_attachment.getEntryName(index);
            tempFile = new File(fileName);
            this.m_attachment.getEntryFile(index, tempFile);
            if (!Env.isWindows()) break block5;
            Process p = Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL \"" + tempFile + "\"");
            return true;
        }
        try {
            if (Env.isMac()) {
                String[] cmdArray = new String[]{"open", tempFile.getAbsolutePath()};
                Process p = Runtime.getRuntime().exec(cmdArray);
                return true;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        return false;
    }

    public static void main(String[] args) {
    }

    private boolean canDelete() {
        MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
        return role.get_ValueAsBoolean("DeleteAttachment");
    }

    class GImage
    extends JPanel {
        private static final long serialVersionUID = 4991225210651641722L;
        private Image m_image = null;

        public void setImage(Image image) {
            this.m_image = image;
            if (this.m_image == null) {
                return;
            }
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.m_image, 0);
            try {
                mt.waitForID(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Dimension dim = new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this));
            this.setPreferredSize(dim);
        }

        @Override
        public void paint(Graphics g) {
            Insets in = this.getInsets();
            if (this.m_image != null) {
                g.drawImage(this.m_image, in.left, in.top, this);
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

