/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.adempiere.apps.graph.PAPanel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AKeyboardFocusManager;
import org.compiere.apps.ALogin;
import org.compiere.apps.AMenuStartItem;
import org.compiere.apps.AppsAction;
import org.compiere.apps.WindowManager;
import org.compiere.apps.WindowMenu;
import org.compiere.apps.wf.WFActivity;
import org.compiere.apps.wf.WFPanel;
import org.compiere.grid.tree.VTreePanel;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTreeNode;
import org.compiere.model.MUser;
import org.compiere.swing.CButton;
import org.compiere.swing.CFrame;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTabbedPane;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Splash;

public final class AMenu
extends CFrame
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = 5255914306969824011L;
    private int m_WindowNo;
    private Properties m_ctx = Env.getCtx();
    private boolean m_startingItem = false;
    private int m_AD_User_ID;
    private int m_AD_Role_ID;
    private int m_tabMenu = 0;
    private int m_tabActivities = 1;
    private int m_tabWorkflow = 2;
    private int m_request_Menu_ID = 0;
    private int m_note_Menu_ID = 0;
    private String m_requestSQL = null;
    private static CLogger log;
    private InfoUpdater infoUpdater = null;
    private Thread infoUpdaterThread = null;
    private WindowManager windowManager = new WindowManager();
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CTabbedPane centerPane = new CTabbedPane();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private JMenuBar menuBar = new JMenuBar();
    protected JProgressBar progressBar = new JProgressBar(0, 100);
    private CPanel infoPanel = new CPanel();
    private CButton bNotes = new CButton();
    private CButton bRequests = new CButton();
    private GridLayout infoLayout = new GridLayout();
    private JProgressBar memoryBar = new JProgressBar();
    private PAPanel paPanel = null;
    private VTreePanel treePanel = null;
    private WFActivity wfActivity = null;
    private WFPanel wfPanel = null;
    private WindowMenu m_WindowMenu;

    static {
        AdempierePLAF.setPLAF();
        log = CLogger.getCLogger(AMenu.class);
    }

    public AMenu() {
        log.info("CodeBase=" + Adempiere.getCodeBase());
        Splash splash = Splash.getSplash();
        this.m_WindowNo = Env.createWindowNo((Container)((Object)this));
        this.initSystem(splash);
        splash.setText(Msg.getMsg((Properties)this.m_ctx, (String)"Loading"));
        splash.toFront();
        splash.paint(splash.getGraphics());
        if (!Adempiere.startupEnvironment((boolean)true)) {
            System.exit(1);
        }
        MSession.get((Properties)Env.getCtx(), (boolean)true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!ADialog.ask((int)0, null, (String)"ExitApplication?")) {
                    return;
                }
                AMenu.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.wfActivity = new WFActivity(this);
        this.wfPanel = new WFPanel(this);
        this.treePanel = new VTreePanel(this.m_WindowNo, true, false);
        try {
            this.jbInit();
            this.createMenu();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "AMenu", (Throwable)ex);
        }
        int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
        int AD_Tree_ID = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        this.treePanel.initTree(AD_Tree_ID);
        Env.setContext((Properties)this.m_ctx, (int)this.m_WindowNo, (String)"WindowName", (String)Msg.getMsg((Properties)this.m_ctx, (String)"Menu"));
        this.setTitle(Env.getHeader((Properties)this.m_ctx, (int)this.m_WindowNo));
        this.progressBar.setString(Msg.getMsg((Properties)this.m_ctx, (String)"SelectProgram"));
        Point loc = Ini.getWindowLocation(0);
        if (loc == null) {
            loc = new Point(0, 0);
        }
        this.setLocation(loc);
        this.pack();
        this.setVisible(true);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            this.setExtendedState(6);
        } else {
            this.setState(0);
        }
        this.validate();
        this.m_AD_User_ID = Env.getContextAsInt((Properties)this.m_ctx, (String)"#AD_User_ID");
        this.m_AD_Role_ID = Env.getContextAsInt((Properties)this.m_ctx, (String)"#AD_Role_ID");
        this.updateInfo();
        this.infoUpdater = new InfoUpdater();
        this.infoUpdaterThread = new Thread((Runnable)this.infoUpdater, "InfoUpdater");
        this.infoUpdaterThread.start();
        splash.dispose();
        splash = null;
    }

    private void initSystem(Splash splash) {
        this.setIconImage(Adempiere.getImage16());
        KeyboardFocusManager.setCurrentKeyboardFocusManager((KeyboardFocusManager)AKeyboardFocusManager.get());
        log.finer("Login");
        ALogin login = new ALogin((Frame)splash);
        if (!login.initLogin()) {
            try {
                AEnv.showCenterScreen((Window)((Object)login));
            }
            catch (Exception ex) {
                log.severe(ex.toString());
            }
            if (!login.isConnected() || !login.isOKpressed()) {
                AEnv.exit((int)1);
            }
        }
        if (!DB.isBuildOK((Properties)this.m_ctx)) {
            AEnv.exit((int)1);
        }
        DB.isDatabaseOK((Properties)this.m_ctx);
    }

    void jbInit() throws Exception {
        this.setName("Menu");
        this.setLocale(Language.getLoginLanguage().getLocale());
        this.setJMenuBar(this.menuBar);
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.mainLayout.setHgap(0);
        this.mainLayout.setVgap(2);
        this.treePanel.addPropertyChangeListener("NodeSelected", (PropertyChangeListener)this);
        this.infoPanel.setLayout((LayoutManager)this.infoLayout);
        this.infoLayout.setColumns(2);
        this.infoLayout.setHgap(4);
        this.infoLayout.setVgap(0);
        this.bNotes.setToolTipText("");
        this.bNotes.setActionCommand("Notes");
        this.bNotes.addActionListener((ActionListener)this);
        this.bNotes.setIcon((Icon)Env.getImageIcon((String)"GetMail24.gif"));
        this.bNotes.setMargin(new Insets(0, 0, 0, 0));
        this.bRequests.setActionCommand("Requests");
        this.bRequests.addActionListener((ActionListener)this);
        this.bRequests.setIcon((Icon)Env.getImageIcon((String)"Request24.gif"));
        this.bRequests.setMargin(new Insets(0, 0, 0, 0));
        this.southLayout.setHgap(0);
        this.southLayout.setVgap(1);
        this.memoryBar.setStringPainted(true);
        this.memoryBar.setOpaque(false);
        this.memoryBar.setBorderPainted(false);
        this.memoryBar.addMouseListener(new AMenu_MouseAdapter());
        this.progressBar.setStringPainted(true);
        this.progressBar.setOpaque(false);
        this.getContentPane().add((Component)this.mainPanel);
        this.mainPanel.add((Component)this.centerPane, (Object)"Center");
        this.mainPanel.add((Component)this.southPanel, (Object)"South");
        this.mainPanel.add(Box.createHorizontalStrut(3), (Object)"East");
        this.mainPanel.add(Box.createHorizontalStrut(3), (Object)"West");
        this.centerPane.setFont(this.centerPane.getFont().deriveFont(this.centerPane.getFont().getSize2D() + 1.0f));
        this.paPanel = PAPanel.get();
        if (this.paPanel != null) {
            this.centerPane.addTab(Msg.getMsg((Properties)this.m_ctx, (String)"PAPanel"), (Icon)Env.getImageIcon2((String)"InfoAccount16"), (Component)((Object)this.paPanel));
            ++this.m_tabMenu;
            ++this.m_tabActivities;
            ++this.m_tabWorkflow;
        }
        this.treePanel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.centerPane.addTab(Msg.getMsg((Properties)this.m_ctx, (String)"Menu"), (Icon)Env.getImageIcon2((String)"Home16"), (Component)this.treePanel);
        if (Env.getAD_User_ID((Properties)this.m_ctx) == 100 || Env.getAD_Role_ID((Properties)this.m_ctx) == 1000000) {
            this.centerPane.addTab(String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"WorkflowActivities")) + ": 0", (Icon)Env.getImageIcon2((String)"Assignment16"), (Component)new CScrollPane((Component)this.wfActivity));
        }
        if (Env.getAD_User_ID((Properties)this.m_ctx) == 100 || Env.getAD_Role_ID((Properties)this.m_ctx) == 1000000) {
            this.centerPane.addTab(Msg.getMsg((Properties)this.m_ctx, (String)"WorkflowPanel"), (Icon)Env.getImageIcon2((String)"WorkFlow16"), (Component)new CScrollPane((Component)this.wfPanel));
        }
        this.centerPane.addChangeListener((ChangeListener)this);
        this.southPanel.setLayout((LayoutManager)this.southLayout);
        this.southPanel.add((Component)this.infoPanel, (Object)"North");
        this.southPanel.add((Component)this.progressBar, (Object)"South");
        this.infoPanel.add((Component)this.bNotes, null);
        this.infoPanel.add((Component)this.bRequests, null);
        this.infoPanel.add((Component)this.memoryBar, null);
        int loc = Ini.getDividerLocation();
        if (loc > 0) {
            this.treePanel.setDividerLocation(loc);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = Ini.getWindowDimension(0);
        if (dim == null) {
            dim = new Dimension(350, 500);
        }
        return dim;
    }

    private void createMenu() {
        JMenu mFile = AEnv.getMenu((String)"File");
        this.menuBar.add(mFile);
        AEnv.addMenuItem((String)"PrintScreen", null, (KeyStroke)KeyStroke.getKeyStroke(154, 0), (JMenu)mFile, (ActionListener)this);
        AEnv.addMenuItem((String)"ScreenShot", null, (KeyStroke)KeyStroke.getKeyStroke(154, 1), (JMenu)mFile, (ActionListener)this);
        mFile.addSeparator();
        AEnv.addMenuItem((String)"Logout", null, (KeyStroke)KeyStroke.getKeyStroke(76, 9), (JMenu)mFile, (ActionListener)this);
        AEnv.addMenuItem((String)"Exit", null, (KeyStroke)KeyStroke.getKeyStroke(88, 9), (JMenu)mFile, (ActionListener)this);
        JMenu mView = AEnv.getMenu((String)"View");
        this.menuBar.add(mView);
        if (MRole.getDefault().isAllow_Info_Product()) {
            AEnv.addMenuItem((String)"InfoProduct", null, (KeyStroke)KeyStroke.getKeyStroke(73, 8), (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_BPartner()) {
            AEnv.addMenuItem((String)"InfoBPartner", null, (KeyStroke)KeyStroke.getKeyStroke(73, 10), (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isShowAcct() && MRole.getDefault().isAllow_Info_Account()) {
            AEnv.addMenuItem((String)"InfoAccount", null, (KeyStroke)KeyStroke.getKeyStroke(73, 10), (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_Schedule()) {
            AEnv.addMenuItem((String)"InfoSchedule", null, null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_MRP()) {
            AEnv.addMenuItem((String)"InfoMRP", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_CRP()) {
            AEnv.addMenuItem((String)"InfoCRP", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        mView.addSeparator();
        if (MRole.getDefault().isAllow_Info_Order()) {
            AEnv.addMenuItem((String)"InfoOrder", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_Invoice()) {
            AEnv.addMenuItem((String)"InfoInvoice", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_InOut()) {
            AEnv.addMenuItem((String)"InfoInOut", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_Payment()) {
            AEnv.addMenuItem((String)"InfoPayment", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_CashJournal()) {
            AEnv.addMenuItem((String)"InfoCashLine", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_Resource()) {
            AEnv.addMenuItem((String)"InfoAssignment", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        if (MRole.getDefault().isAllow_Info_Asset()) {
            AEnv.addMenuItem((String)"InfoAsset", (String)"Info", null, (JMenu)mView, (ActionListener)this);
        }
        JMenu mTools = AEnv.getMenu((String)"Tools");
        this.menuBar.add(mTools);
        AEnv.addMenuItem((String)"Calculator", null, null, (JMenu)mTools, (ActionListener)this);
        AEnv.addMenuItem((String)"Calendar", null, null, (JMenu)mTools, (ActionListener)this);
        AEnv.addMenuItem((String)"Editor", null, null, (JMenu)mTools, (ActionListener)this);
        MUser user = MUser.get((Properties)Env.getCtx());
        if (user.isAdministrator()) {
            AEnv.addMenuItem((String)"Script", null, null, (JMenu)mTools, (ActionListener)this);
        }
        if (AEnv.isWorkflowProcess()) {
            AEnv.addMenuItem((String)"WorkFlow", null, null, (JMenu)mTools, (ActionListener)this);
        }
        if (MRole.getDefault().isShowPreference()) {
            mTools.addSeparator();
            AEnv.addMenuItem((String)"Preference", null, null, (JMenu)mTools, (ActionListener)this);
        }
        this.m_WindowMenu = new WindowMenu(this.windowManager, (JFrame)((Object)this));
        this.menuBar.add((JMenu)this.m_WindowMenu);
        KeyStroke ks = KeyStroke.getKeyStroke(87, 2);
        this.getRootPane().getInputMap(2).put(ks, "ShowAllWindow");
        AppsAction action = new AppsAction("ShowAllWindow", ks, false);
        this.getRootPane().getActionMap().put("ShowAllWindow", (Action)action);
        action.setDelegate((ActionListener)this);
        JMenu mHelp = AEnv.getMenu((String)"Help");
        this.menuBar.add(mHelp);
        AEnv.addMenuItem((String)"Online", null, null, (JMenu)mHelp, (ActionListener)this);
        AEnv.addMenuItem((String)"EMailSupport", null, null, (JMenu)mHelp, (ActionListener)this);
        AEnv.addMenuItem((String)"About", null, null, (JMenu)mHelp, (ActionListener)this);
    }

    public void dispose() {
        this.preDispose();
        super.dispose();
        AEnv.exit((int)0);
    }

    private void preDispose() {
        Ini.setWindowDimension(0, this.getSize());
        Ini.setDividerLocation(this.treePanel.getDividerLocation());
        Ini.setWindowLocation(0, this.getLocation());
        Ini.saveProperties(true);
        this.infoUpdater.stop = true;
        try {
            try {
                this.infoUpdaterThread.join(50L);
            }
            catch (InterruptedException interruptedException) {
                this.infoUpdaterThread = null;
                this.infoUpdater = null;
            }
        }
        finally {
            this.infoUpdaterThread = null;
            this.infoUpdater = null;
        }
    }

    public void logout() {
        this.windowManager.close();
        this.preDispose();
        super.dispose();
        AEnv.logout();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.treePanel.getSearchField().requestFocusInWindow();
        }
    }

    protected void setBusy(boolean value) {
        this.m_startingItem = value;
        if (value) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        MTreeNode nd = (MTreeNode)e.getNewValue();
        log.info(String.valueOf(nd.getNode_ID()) + " - " + nd.toString());
        if (this.m_startingItem || nd.isSummary()) {
            return;
        }
        String sta = nd.toString();
        this.progressBar.setString(sta);
        int cmd = nd.getNode_ID();
        new AMenuStartItem(cmd, true, sta, this).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bNotes) {
            this.gotoNotes();
        } else if (e.getSource() == this.bRequests) {
            this.gotoRequests();
        } else if (e.getActionCommand().equals("ShowAllWindow")) {
            this.m_WindowMenu.expose();
        } else if (!AEnv.actionPerformed((String)e.getActionCommand(), (int)this.m_WindowNo, (Container)((Object)this))) {
            log.log(Level.SEVERE, "unknown action=" + e.getActionCommand());
        }
    }

    private int getNotes() {
        String sql = "SELECT COUNT(1) FROM AD_Note WHERE AD_Client_ID=? AND AD_User_ID IN (0,?) AND Processed='N'";
        int retValue = DB.getSQLValue(null, (String)sql, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)this.m_AD_User_ID);
        return retValue;
    }

    private void gotoNotes() {
        if (this.m_note_Menu_ID == 0) {
            this.m_note_Menu_ID = DB.getSQLValue(null, (String)"SELECT AD_Menu_ID FROM AD_Menu m INNER JOIN AD_TABLE t ON (t.AD_Window_ID=m.AD_Window_ID) WHERE t.AD_Table_ID=?", (int)389);
        }
        if (this.m_note_Menu_ID == 0) {
            this.m_note_Menu_ID = 233;
        }
        new AMenuStartItem(this.m_note_Menu_ID, true, Msg.translate((Properties)this.m_ctx, (String)"AD_Note_ID"), this).start();
    }

    private int getRequests() {
        if (this.m_requestSQL == null) {
            this.m_requestSQL = MRole.getDefault().addAccessSQL("SELECT COUNT(1) FROM R_Request WHERE (SalesRep_ID=? OR AD_Role_ID=?) AND Processed='N' AND (DateNextAction IS NULL OR TRUNC(DateNextAction) <= TRUNC(SysDate)) AND (R_Status_ID IS NULL OR R_Status_ID IN (SELECT R_Status_ID FROM R_Status WHERE IsClosed='N'))", "R_Request", false, true);
        }
        int retValue = DB.getSQLValue(null, (String)this.m_requestSQL, (int)this.m_AD_User_ID, (int)this.m_AD_Role_ID);
        return retValue;
    }

    private void gotoRequests() {
        if (this.m_request_Menu_ID == 0) {
            this.m_request_Menu_ID = 237;
        }
        new AMenuStartItem(this.m_request_Menu_ID, true, Msg.translate((Properties)this.m_ctx, (String)"R_Request_ID"), this).start();
    }

    public void updateInfo() {
        double total = Runtime.getRuntime().totalMemory() / 1024L;
        double free = Runtime.getRuntime().freeMemory() / 1024L;
        double used = total - free;
        double percent = used * 100.0 / total;
        this.memoryBar.setMaximum((int)total);
        this.memoryBar.setValue((int)used);
        String msg = MessageFormat.format("{0,number,integer} MB - {1,number,integer}%", new BigDecimal(total / 1024.0), new BigDecimal(percent));
        this.memoryBar.setString(msg);
        msg = Msg.getMsg((Properties)this.m_ctx, (String)"MemoryInfo", (Object[])new Object[]{new BigDecimal(total), new BigDecimal(free)});
        this.memoryBar.setToolTipText(msg);
        if ((Env.getAD_User_ID((Properties)this.m_ctx) == 100 || Env.getAD_Role_ID((Properties)this.m_ctx) == 1000000) && DB.isConnected()) {
            int requests = this.getRequests();
            this.bRequests.setText(String.valueOf(Msg.translate((Properties)this.m_ctx, (String)"R_Request_ID")) + ": " + requests);
            int notes = this.getNotes();
            this.bNotes.setText(String.valueOf(Msg.translate((Properties)this.m_ctx, (String)"AD_Note_ID")) + ": " + notes);
            int activities = this.wfActivity.getActivitiesCount();
            this.centerPane.setTitleAt(this.m_tabActivities, String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"WorkflowActivities")) + ": " + activities);
            MSystem.get((Properties)this.m_ctx).info();
        }
    }

    public void updateActivities(int act_length) {
        this.centerPane.setTitleAt(this.m_tabActivities, String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"WorkflowActivities")) + ": " + act_length);
    }

    protected void startWorkFlow(int AD_Workflow_ID) {
        this.centerPane.setSelectedIndex(this.m_tabWorkflow);
        this.wfPanel.load(AD_Workflow_ID, false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.centerPane.getSelectedIndex() == this.m_tabActivities) {
            this.wfActivity.loadActivities();
        }
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public static void main(String[] args) {
        Splash.getSplash();
        Adempiere.startup((boolean)true);
        new AMenu();
    }

    class AMenu_MouseAdapter
    extends MouseAdapter {
        AMenu_MouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                System.gc();
            }
        }
    }

    class InfoUpdater
    implements Runnable {
        boolean stop = false;

        InfoUpdater() {
        }

        @Override
        public void run() {
            int sleep = MSysConfig.getIntValue((String)"MENU_INFOUPDATER_SLEEP_MS", (int)60000, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            while (!this.stop) {
                AMenu.this.updateInfo();
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

