/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MJournalLine;
import org.compiere.model.MProduct;
import org.compiere.model.X_AD_Client;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_C_ProjectSchedule;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_PaymentRequest
extends Doc {
    private int m_precision = -1;
    private int m_C_BankAccount_ID = 0;

    public Doc_PaymentRequest(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, X_C_PaymentRequest.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        X_C_PaymentRequest pr = new X_C_PaymentRequest(this.getCtx(), this.getPO().get_ID(), null);
        this.setDateDoc(pr.getDateTrx());
        this.setDateAcct(pr.getDateAcct());
        this.setAmount(0, new BigDecimal("0.0"));
        this.setAmount(1, new BigDecimal("0.0"));
        this.setAmount(2, new BigDecimal("0.0"));
        this.m_C_BankAccount_ID = pr.getC_BankAccount_ID();
        return null;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    private int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue);
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts;
        Fact fact3;
        Fact fact2;
        Fact fact;
        block54: {
            MDocType DocType;
            fact = new Fact((Doc)this, as, "A");
            fact2 = new Fact((Doc)this, as, "R");
            fact3 = new Fact((Doc)this, as, "B");
            facts = new ArrayList<Fact>();
            X_C_PaymentRequest pr = new X_C_PaymentRequest(this.getCtx(), this.getPO().get_ID(), null);
            if (pr.getDocStatus().equals("VO")) {
                facts.add(fact);
                facts.add(fact2);
                facts.add(fact3);
                return facts;
            }
            X_AD_Client client = new X_AD_Client(this.getCtx(), pr.getAD_Client_ID(), null);
            BigDecimal PayAmt = new BigDecimal("0.0");
            if (client.getName().equalsIgnoreCase("Gobierno Regional Valpara\u00edso")) {
                X_C_ProjectSchedule ps = new X_C_ProjectSchedule(this.getCtx(), pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.getTrxName());
                this.setAmount(2, ps.getDueAmt());
                PayAmt = ps.getDueAmt();
            }
            if (!(DocType = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"PRT")[0]).get_ValueAsBoolean("Posted")) {
                return facts;
            }
            if (pr.getRequestType().equals("J")) {
                return facts;
            }
            if (pr.getRequestType().equals("R") && client.getName().equalsIgnoreCase("Gobierno Regional Valpara\u00edso")) {
                if (!as.isAccrual()) {
                    return facts;
                }
                String sqlVNA = "SELECT COUNT(1) FROM AD_Ref_List where AD_Reference_ID=1000077 and NoAcct = 'Y' and value IN ( select Pay_Type from PM_ProjectPay where C_ProjectSchedule_ID = ?)";
                int cantVNA = DB.getSQLValue((String)this.getTrxName(), (String)sqlVNA, (int)pr.get_ValueAsInt("C_ProjectSchedule_ID"));
                if (cantVNA > 0) {
                    return facts;
                }
                if (pr.get_ValueAsString("IsPrepayment").equals("false") || pr.get_ValueAsString("IsPrepayment").equals("N")) {
                    if (this.getDocumentType().equals("PRT")) {
                        FactLine fl;
                        block52: {
                            fl = null;
                            String desc = null;
                            String sql = "select cpl.m_product_id from C_PaymentRequest cpr inner join C_ProjectSchedule cps on (cpr.c_projectschedule_id = cps.c_projectschedule_id) inner join DM_Document dmd on (cps.DM_Document_ID = dmd.DM_Document_ID) inner join C_ProjectLine cpl on (dmd.C_ProjectLine_ID = cpl.C_ProjectLine_ID) where cpr.C_PaymentRequest_ID=?";
                            try {
                                int proID = DB.getSQLValue((String)this.getTrxName(), (String)sql, (int)pr.get_ID());
                                MProduct pro = new MProduct(this.getCtx(), proID, this.getTrxName());
                                String sql2 = "select MAX(P_default_acct) from M_Product_Acct where M_Product_ID=?";
                                int cvcID = DB.getSQLValue((String)this.getTrxName(), (String)sql2, (int)pro.get_ID());
                                desc = "";
                                if (PayAmt.compareTo(new BigDecimal("0.0")) > 0) {
                                    fl = fact.createLine(null, MAccount.get(this.getCtx(), cvcID), this.getC_Currency_ID(), PayAmt, null);
                                    if (client.getName().equalsIgnoreCase("Gobierno Regional Valpara\u00edso")) {
                                        fl.setDescription("Estado de Pago");
                                    }
                                    fl.save();
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            BigDecimal chargeamt = this.getAmount(2);
                            int charge_ID = this.getValidCombination_ID(0, as);
                            desc = "";
                            if (chargeamt.compareTo(new BigDecimal("0.0")) > 0) {
                                fl = fact.createLine(null, MAccount.get(this.getCtx(), charge_ID), this.getC_Currency_ID(), null, chargeamt);
                                if (client.getName().equalsIgnoreCase("Gobierno Regional Valpara\u00edso")) {
                                    fl.setDescription("Estado de Pago");
                                }
                                fl.save();
                            }
                            fl.save();
                            String sqlAux1C = "SELECT cpr.ad_client_id, cpr.ad_org_id, cpr.isactive, cpr.created, cpr.createdby, cpr.updated, cpr.updatedby, cpr.c_bpartner_id,coalesce(cps.description,'--') as description,'CAB' as tipo,dueamt AS amt, cpr.datetrx, (SELECT M_Product_ID FROM C_ProjectLine cpl INNER JOIN DM_Document dm ON (cpl.C_ProjectLine_ID = dm.C_ProjectLine_ID) WHERE DM_Document_ID = cps.DM_Document_ID) as M_Product_ID FROM c_paymentrequest cpr JOIN c_projectschedule cps ON cpr.c_projectschedule_id = cps.c_projectschedule_id WHERE cpr.C_PaymentRequest_ID=?";
                            CPreparedStatement pstmtauxC = null;
                            ResultSet rsauxC = null;
                            try {
                                try {
                                    pstmtauxC = DB.prepareStatement((String)sqlAux1C, (String)this.getTrxName());
                                    pstmtauxC.setInt(1, pr.get_ID());
                                    rsauxC = pstmtauxC.executeQuery();
                                    while (rsauxC.next()) {
                                        String insetC = "INSERT INTO  t_fact_acctgore (fact_acct_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby, ad_table_id,record_id, c_bpartner_id,description,tipo,monto,datetrx,m_product_id,c_project_id) VALUES (" + fl.get_ID() + "," + rsauxC.getInt("AD_Client_ID") + "," + rsauxC.getInt("ad_org_id") + ",'" + rsauxC.getString("isactive") + "','" + rsauxC.getTimestamp("Created") + "'," + rsauxC.getInt("CreatedBy") + ",'" + rsauxC.getTimestamp("Updated") + "'," + rsauxC.getInt("UpdatedBy") + "," + pr.get_Table_ID() + "," + pr.get_ID() + "," + rsauxC.getInt("c_bpartner_id") + ",'" + rsauxC.getString("description") + "','" + rsauxC.getString("tipo") + "'," + rsauxC.getBigDecimal("amt") + ",'" + rsauxC.getTimestamp("datetrx") + "'," + rsauxC.getInt("M_Product_ID") + "," + pr.get_ValueAsInt("C_Project_ID") + ")";
                                        DB.executeUpdate((String)insetC, (String)this.getTrxName());
                                    }
                                }
                                catch (SQLException e) {
                                    this.log.log(Level.SEVERE, sqlAux1C, (Throwable)e);
                                    DB.close(rsauxC, (Statement)pstmtauxC);
                                    rsauxC = null;
                                    pstmtauxC = null;
                                    break block52;
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close(rsauxC, pstmtauxC);
                                rsauxC = null;
                                pstmtauxC = null;
                                throw throwable;
                            }
                            DB.close((ResultSet)rsauxC, (Statement)pstmtauxC);
                            rsauxC = null;
                            pstmtauxC = null;
                        }
                        String sqlAux1 = "SELECT cpr.ad_client_id, cpr.ad_org_id, cpr.isactive, cpr.created, cpr.createdby, cpr.updated, cpr.updatedby, cpr.c_bpartner_id,coalesce(pp.description,'--') as description,pp.pay_type as tipo2,'LIN' as tipo,abs(pp.amt + pp.referenceamount) AS amt, CASE WHEN cil.documentno is null THEN coalesce(dm.documentno,'--') WHEN cil.documentno is not null THEN coalesce(cil.documentno,'--') ELSE coalesce(cil.documentno,'--') END as documentno,  0 as c_validcombination_id,cpr.datetrx,0 as debito,0 as credito, (SELECT M_Product_ID FROM C_ProjectLine cpl INNER JOIN DM_Document dm ON (cpl.C_ProjectLine_ID = dm.C_ProjectLine_ID) WHERE DM_Document_ID = cps.DM_Document_ID) as M_Product_ID FROM c_paymentrequest cpr INNER JOIN c_projectschedule cps ON (cpr.c_projectschedule_id = cps.c_projectschedule_id) INNER JOIN pm_projectpay pp ON (cps.c_projectschedule_id = pp.c_projectschedule_id) LEFT JOIN c_invoice cil ON (pp.c_invoice_id = cil.c_invoice_id) LEFT JOIN DM_Document dm ON (pp.DM_Document_ID = dm.DM_Document_ID) WHERE cpr.C_PaymentRequest_ID= ? ";
                        CPreparedStatement pstmtaux = null;
                        ResultSet rsaux2 = null;
                        try {
                            try {
                                pstmtaux = DB.prepareStatement((String)sqlAux1, (String)this.getTrxName());
                                pstmtaux.setInt(1, pr.get_ID());
                                rsaux2 = pstmtaux.executeQuery();
                                while (rsaux2.next()) {
                                    String inset = "INSERT INTO  t_fact_acctgore (fact_acct_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby, ad_table_id,record_id, c_bpartner_id,description,tipo,tipo2,monto,documentno,c_validcombination_id,datetrx,debito,credito,m_product_id,c_project_id) VALUES (" + fl.get_ID() + "," + rsaux2.getInt("AD_Client_ID") + "," + rsaux2.getInt("ad_org_id") + ",'" + rsaux2.getString("isactive") + "','" + rsaux2.getTimestamp("Created") + "'," + rsaux2.getInt("CreatedBy") + ",'" + rsaux2.getTimestamp("Updated") + "'," + rsaux2.getInt("UpdatedBy") + "," + pr.get_Table_ID() + "," + pr.get_ID() + "," + rsaux2.getInt("c_bpartner_id") + ",'" + rsaux2.getString("description") + "','" + rsaux2.getString("tipo") + "','" + rsaux2.getString("tipo2") + "'," + rsaux2.getBigDecimal("amt") + ",'" + rsaux2.getString("documentno") + "'," + rsaux2.getInt("c_validcombination_id") + ",'" + rsaux2.getTimestamp("datetrx") + "'," + rsaux2.getBigDecimal("debito") + "," + rsaux2.getBigDecimal("credito") + "," + rsaux2.getInt("M_Product_ID") + "," + pr.get_ValueAsInt("C_Project_ID") + ")";
                                    DB.executeUpdate((String)inset, (String)this.getTrxName());
                                }
                            }
                            catch (SQLException e) {
                                this.log.log(Level.SEVERE, sqlAux1, (Throwable)e);
                                DB.close(rsaux2, (Statement)pstmtaux);
                                rsaux2 = null;
                                pstmtaux = null;
                                break block54;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rsaux2, pstmtaux);
                            rsaux2 = null;
                            pstmtaux = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rsaux2, (Statement)pstmtaux);
                        rsaux2 = null;
                        pstmtaux = null;
                    } else {
                        this.p_Error = "DocumentType unknown: " + this.getDocumentType();
                        this.log.log(Level.SEVERE, this.p_Error);
                        fact = null;
                    }
                } else if (pr.get_ValueAsString("IsPrepayment").equals("true") || pr.get_ValueAsString("IsPrepayment").equals("Y")) {
                    if (this.getDocumentType().equals("PRT")) {
                        BigDecimal chargeamt = this.getAmount(2);
                        String sql = "select MAX(C_IsPrePayment_Acct) from C_AcctSchema_Default where C_AcctSchema_ID = ?";
                        try {
                            int cacID = DB.getSQLValue((String)this.getTrxName(), (String)sql, (int)as.get_ID());
                            fact.createLine(null, MAccount.get(this.getCtx(), cacID), this.getC_Currency_ID(), chargeamt, null);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql, (Throwable)e);
                        }
                        int charge_ID = this.getValidCombination_ID(0, as);
                        fact.createLine(null, MAccount.get(this.getCtx(), charge_ID), this.getC_Currency_ID(), null, chargeamt);
                    } else {
                        this.p_Error = "DocumentType unknown: " + this.getDocumentType();
                        this.log.log(Level.SEVERE, this.p_Error);
                        fact = null;
                    }
                }
            } else if (pr.getRequestType().equals("I") && client.getName().equalsIgnoreCase("Gobierno Regional Valpara\u00edso")) {
                block58: {
                    FactLine fl;
                    block56: {
                        fl = null;
                        String sql3 = "select MAX(combinacion_id1),sum(linetotalamt)  from RVOFB_RPaymentLine where c_paymentrequest_id = ? group by cuenta_id1 ";
                        CPreparedStatement pstmt = null;
                        ResultSet rs = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement((String)sql3, (String)this.getTrxName());
                                pstmt.setInt(1, pr.get_ID());
                                rs = pstmt.executeQuery();
                                while (rs.next()) {
                                    int cvc = rs.getInt(1);
                                    BigDecimal amtProd = new BigDecimal("0.0");
                                    amtProd = rs.getBigDecimal(2);
                                    fact.createLine(null, MAccount.get(this.getCtx(), cvc), this.getC_Currency_ID(), amtProd, null);
                                }
                            }
                            catch (SQLException e) {
                                this.log.log(Level.SEVERE, sql3, (Throwable)e);
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                break block56;
                            }
                        }
                        catch (Throwable charge_ID) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw charge_ID;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    String sqlCargo = "SELECT CH_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=1000000";
                    int charge2_ID = DB.getSQLValue((String)this.getTrxName(), (String)sqlCargo, (int)pr.getC_Charge_ID());
                    fl = fact.createLine(null, MAccount.get(this.getCtx(), charge2_ID), this.getC_Currency_ID(), null, pr.getPayAmt());
                    fl.save();
                    String isACT = "N";
                    if (pr.isActive()) {
                        isACT = "Y";
                    }
                    String insetC = "INSERT INTO  t_fact_acctgore (fact_acct_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby, ad_table_id,record_id, c_bpartner_id,description,tipo,monto,datetrx,m_product_id,c_project_id,documentno) VALUES (" + fl.get_ID() + "," + pr.getAD_Client_ID() + "," + pr.getAD_Org_ID() + ",'" + isACT + "','" + pr.getCreated() + "'," + pr.getCreatedBy() + ",'" + pr.getUpdated() + "'," + pr.getUpdatedBy() + "," + pr.get_Table_ID() + "," + pr.get_ID() + "," + pr.getC_BPartner_ID() + ",'" + pr.getDescription() + "','" + "CAB" + "'," + pr.getPayAmt() + ",'" + pr.getDateTrx() + "',0,0,'" + pr.getDocumentNo() + "')";
                    DB.executeUpdate((String)insetC, (String)this.getTrxName());
                    String sqlAux1 = "SELECT ci.ad_client_id, ci.ad_org_id, ci.isactive, ci.created, ci.createdby, ci.updated, ci.updatedby, ci.c_bpartner_id, coalesce(PrintName,'--') as description ,'LIN' as tipo, ci.grandtotal AS amt, ci.dateinvoiced as datetrx, ci.documentno as documentno, 0 as c_project_id,0 as M_Product_ID,0 as debito,0 as credito FROM C_PaymentRequest pr LEFT JOIN C_PaymentRequestLine prl ON (pr.C_PaymentRequest_ID = prl.C_PaymentRequest_ID) LEFT JOIN C_Invoice ci ON (prl.C_Invoice_ID = ci.C_Invoice_ID) LEFT JOIN C_DocType dt ON (ci.C_DocTypeTarget_ID = dt.C_DocType_ID) WHERE pr.C_PaymentRequest_ID=?";
                    CPreparedStatement pstmtaux = null;
                    ResultSet rsaux = null;
                    try {
                        try {
                            pstmtaux = DB.prepareStatement((String)sqlAux1, (String)this.getTrxName());
                            pstmtaux.setInt(1, pr.get_ID());
                            rsaux = pstmtaux.executeQuery();
                            while (rsaux.next()) {
                                String inset = "INSERT INTO  t_fact_acctgore (fact_acct_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby, ad_table_id,record_id, c_bpartner_id,description,tipo,monto,documentno,datetrx,debito,credito,m_product_id,c_project_id) VALUES (" + fl.get_ID() + "," + rsaux.getInt("AD_Client_ID") + "," + rsaux.getInt("ad_org_id") + ",'" + rsaux.getString("isactive") + "','" + rsaux.getTimestamp("Created") + "'," + rsaux.getInt("CreatedBy") + ",'" + rsaux.getTimestamp("Updated") + "'," + rsaux.getInt("UpdatedBy") + "," + pr.get_Table_ID() + "," + pr.get_ID() + "," + rsaux.getInt("c_bpartner_id") + ",'" + rsaux.getString("description") + "','" + rsaux.getString("tipo") + "'," + rsaux.getBigDecimal("amt") + ",'" + rsaux.getString("documentno") + "','" + rsaux.getTimestamp("datetrx") + "'," + rsaux.getBigDecimal("debito") + "," + rsaux.getBigDecimal("credito") + "," + rsaux.getInt("M_Product_ID") + "," + rsaux.getInt("C_Project_ID") + ")";
                                DB.executeUpdate((String)inset, (String)this.getTrxName());
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, sqlAux1, (Throwable)e);
                            DB.close(rsaux, (Statement)pstmtaux);
                            rsaux = null;
                            pstmtaux = null;
                            break block58;
                        }
                    }
                    catch (Throwable rsaux2) {
                        DB.close(rsaux, pstmtaux);
                        rsaux = null;
                        pstmtaux = null;
                        throw rsaux2;
                    }
                    DB.close((ResultSet)rsaux, (Statement)pstmtaux);
                    rsaux = null;
                    pstmtaux = null;
                }
                String sqlcc = "select ch_Expense_Acct from C_AcctSchema_Default where C_AcctSchema_ID=1000000 and ad_client_id = 1000000 ";
                int cvcIDcc = DB.getSQLValue((String)this.getTrxName(), (String)sqlcc);
                fact2.createLine(null, MAccount.get(this.getCtx(), cvcIDcc), this.getC_Currency_ID(), pr.getPayAmt().negate(), null);
            } else if (pr.getRequestType().equals("P") && client.getName().equalsIgnoreCase("Grupo Geminis")) {
                MAccount acct = null;
                FactLine fl = null;
                int AD_Org_ID = this.getBank_Org_ID();
                String sqlDet = "SELECT C_PaymentRequestLine_ID FROM C_PaymentRequestLine WHERE C_PaymentRequest_ID=?";
                CPreparedStatement pstmtDet = null;
                ResultSet rsDet = null;
                try {
                    pstmtDet = DB.prepareStatement((String)sqlDet, (String)this.getTrxName());
                    pstmtDet.setInt(1, pr.get_ID());
                    rsDet = pstmtDet.executeQuery();
                    while (rsDet.next()) {
                        X_C_PaymentRequestLine prl = new X_C_PaymentRequestLine(this.getCtx(), rsDet.getInt(1), this.getTrxName());
                        MJournalLine jl = new MJournalLine(this.getCtx(), prl.getGL_JournalLine_ID(), this.getTrxName());
                        acct = MAccount.get(as.getCtx(), jl.getC_ValidCombination_ID());
                        fl = fact.createLine(null, acct, this.getC_Currency_ID(), prl.getAmt(), null);
                        this.log.config("acct:" + (Object)((Object)acct) + jl.getC_ValidCombination_ID());
                    }
                    acct = this.getC_Charge_ID() != 0 ? MCharge.getAccount((int)this.getC_Charge_ID(), (MAcctSchema)as, (BigDecimal)pr.getPayAmt()) : this.getAccount(12, as);
                    fl = fact.createLine(null, acct, this.getC_Currency_ID(), null, pr.getPayAmt());
                    if (fl != null && AD_Org_ID != 0 && this.getC_Charge_ID() == 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlDet, (Throwable)e);
                }
            }
        }
        facts.add(fact);
        facts.add(fact2);
        facts.add(fact3);
        return facts;
    }
}

