/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.OFBProductCost;
import org.compiere.model.ProductCost;
import org.compiere.model.X_Fact_Acct;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class Doc_Invoice
extends Doc {
    private DocTax[] m_taxes = null;
    private int m_precision = -1;
    private boolean m_allLinesService = true;
    private boolean m_allLinesItem = true;

    public Doc_Invoice(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInvoice.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MInvoice invoice = (MInvoice)((Object)this.getPO());
        this.setDateDoc(invoice.getDateInvoiced());
        this.setIsTaxIncluded(invoice.isTaxIncluded());
        this.setAmount(0, invoice.getGrandTotal());
        this.setAmount(1, invoice.getTotalLines());
        this.setAmount(2, invoice.getChargeAmt());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(invoice);
        this.log.fine("Lines=" + this.p_lines.length + ", Taxes=" + this.m_taxes.length);
        return null;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_InvoiceTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_Tax_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    if (name.trim().toUpperCase().equals("IVA NO RECUPERABLE")) continue;
                    BigDecimal rate = rs.getBigDecimal(3);
                    BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                    BigDecimal amount = rs.getBigDecimal(5);
                    boolean salesTax = "Y".equals(rs.getString(6));
                    DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                    this.log.fine(taxLine.toString());
                    list.add(taxLine);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    private DocLine[] loadLines(MInvoice invoice) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        BigDecimal totalTemp = new BigDecimal("0.0");
        MInvoiceLine[] lines = invoice.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceLine line = lines[i];
            if (!line.isDescription()) {
                MTax tax;
                DocLine docLine = new DocLine(line, this);
                BigDecimal Qty = line.getQtyInvoiced();
                boolean cm = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
                docLine.setQty(cm ? Qty.negate() : Qty, invoice.isSOTrx());
                BigDecimal LineNetAmt = line.getLineNetAmt();
                BigDecimal PriceList = line.getPriceList();
                if (this.getDocumentType().equals("APS") || this.getDocumentType().equals("PSC")) {
                    LineNetAmt = line.getLineTotalAmt().setScale(0, 1);
                    totalTemp = totalTemp.add(LineNetAmt);
                    if (i == lines.length - 1) {
                        if (totalTemp.compareTo(invoice.getGrandTotal()) < 0) {
                            LineNetAmt = LineNetAmt.add(invoice.getGrandTotal().subtract(totalTemp));
                        } else if (totalTemp.compareTo(invoice.getGrandTotal()) > 0) {
                            LineNetAmt = LineNetAmt.subtract(totalTemp.subtract(invoice.getGrandTotal()));
                        }
                    }
                }
                if (line.getC_Tax_ID() > 0 && line.getC_Tax().getName().trim().toUpperCase().equals("IVA NO RECUPERABLE")) {
                    LineNetAmt = line.getLineTotalAmt();
                    PriceList = line.getLineTotalAmt().divide(line.getQtyInvoiced(), 4);
                }
                int C_Tax_ID = docLine.getC_Tax_ID();
                if (this.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                    BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPrecision());
                    this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                    LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                    int t = 0;
                    while (t < this.m_taxes.length) {
                        if (this.m_taxes[t].getC_Tax_ID() == C_Tax_ID) {
                            this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                            break;
                        }
                        ++t;
                    }
                    BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPrecision());
                    PriceList = PriceList.subtract(PriceListTax);
                }
                docLine.setAmount(LineNetAmt, PriceList, Qty);
                docLine.m_Payment_ID = line.get_ValueAsInt("C_Payment_ID");
                if (line.isA_CreateAsset() && line.getA_CapvsExp().equals("Cap")) {
                    docLine.isAsset = true;
                    docLine.AssetGroup_ID = line.get_ValueAsInt("A_Asset_Group_ID");
                }
                if (docLine.isItem()) {
                    this.m_allLinesService = false;
                } else {
                    this.m_allLinesItem = false;
                }
                this.log.fine(docLine.toString());
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        if (this.isTaxIncluded()) {
            int i2 = 0;
            while (i2 < this.m_taxes.length) {
                if (this.m_taxes[i2].isIncludedTaxDifference()) {
                    BigDecimal diff = this.m_taxes[i2].getIncludedTaxDifference();
                    int j = 0;
                    while (j < dls.length) {
                        if (dls[j].getC_Tax_ID() == this.m_taxes[i2].getC_Tax_ID()) {
                            dls[j].setLineNetAmtDifference(diff);
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        return dls;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        int i = 0;
        while (i < this.m_taxes.length) {
            retValue = retValue.subtract(this.m_taxes[i].getAmount());
            sb.append("-").append(this.m_taxes[i].getAmount());
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            retValue = retValue.subtract(this.p_lines[i].getAmtSource());
            sb.append("-").append(this.p_lines[i].getAmtSource());
            ++i;
        }
        sb.append("]");
        this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact((Doc)this, as, "A");
        MInvoice doc = (MInvoice)((Object)this.getPO());
        MDocType type = MDocType.get((Properties)this.getCtx(), (int)doc.getC_DocType_ID());
        if (!type.get_ValueAsBoolean("Posted")) {
            return facts;
        }
        MInvoice invoice = (MInvoice)((Object)this.getPO());
        MClient client = new MClient(this.getCtx(), this.getAD_Client_ID(), this.getTrxName());
        if (invoice.getDocStatus().equals("VO")) {
            MInvoiceLine[] iLines = invoice.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                MCostDetail cd = OFBProductCost.get(as.getCtx(), "C_InvoiceLine_ID=?", iLine.getC_InvoiceLine_ID(), iLine.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                if (cd != null && cd.isProcessed()) {
                    if (cd.getAmt().signum() > 0) {
                        OFBProductCost.createInvoice(as, cd.getAD_Org_ID(), cd.getM_Product_ID(), cd.getM_AttributeSetInstance_ID(), cd.getC_InvoiceLine_ID(), cd.getM_CostElement_ID(), cd.getAmt().negate(), Env.ZERO, "Anulacion Factura", this.getTrxName());
                    } else {
                        String sql = "DELETE From M_CostDetail WHERE Processed='N'  AND C_InvoiceLine_ID=" + iLine.getC_InvoiceLine_ID() + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID();
                        int no = DB.executeUpdate((String)sql, (String)this.getTrxName());
                        if (no != 0) {
                            this.log.config("Deleted #" + no);
                        }
                    }
                }
                ++i;
            }
            return facts;
        }
        if (!as.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("ARI") || this.getDocumentType().equals("ARF")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), null, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i2 = 0;
            while (i2 < fLines.length) {
                if (fLines[i2] != null) {
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i2;
            }
            int receivables_ID = this.getValidCombination_ID(1, as);
            int receivablesServices_ID = this.getValidCombination_ID(4, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
            if (OFBForward.UpdateIVAPA()) {
                BigDecimal amtIVA = DB.getSQLValueBD((String)"C_Invoice_ID", (String)("SELECT ROUND(COALESCE(SUM(IVATaxAmt),0)) FROM C_InvoiceLine cil  INNER JOIN C_Tax ct ON (cil.C_Tax_ID = ct.C_Tax_ID) WHERE cil.IsActive = 'Y' AND IsTaxExempt = 'N' AND C_Invoice_ID = " + invoice.get_ID()), (Object[])new Object[0]);
                if (amtIVA == null) {
                    amtIVA = Env.ZERO;
                }
                BigDecimal oTax = invoice.getGrandTotal().subtract(invoice.getTotalLines()).subtract(amtIVA);
                int customTAx = this.getValidCombination_ID(219, as);
                fact.createLine(null, MAccount.get(this.getCtx(), customTAx), this.getC_Currency_ID(), null, oTax);
            }
        } else if (this.getDocumentType().equals("ARC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), amt, null);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt, null)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), amt, null);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i3 = 0;
            while (i3 < fLines.length) {
                if (fLines[i3] != null) {
                    fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), true);
                    fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i3;
            }
            int receivables_ID = this.getValidCombination_ID(1, as);
            int receivablesServices_ID = this.getValidCombination_ID(4, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            if (OFBForward.UpdateIVAPA()) {
                BigDecimal amtIVA = DB.getSQLValueBD((String)"C_Invoice_ID", (String)("SELECT ROUND(COALESCE(SUM(IVATaxAmt),0)) FROM C_InvoiceLine cil  INNER JOIN C_Tax ct ON (cil.C_Tax_ID = ct.C_Tax_ID) WHERE cil.IsActive = 'Y' AND IsTaxExempt = 'N' AND C_Invoice_ID = " + invoice.get_ID()), (Object[])new Object[0]);
                if (amtIVA == null) {
                    amtIVA = Env.ZERO;
                }
                BigDecimal oTax = invoice.getGrandTotal().subtract(invoice.getTotalLines()).subtract(amtIVA);
                int customTAx = this.getValidCombination_ID(219, as);
                fact.createLine(null, MAccount.get(this.getCtx(), customTAx), this.getC_Currency_ID(), oTax, null);
            }
        } else if (this.getDocumentType().equals("API")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        OFBProductCost.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i4 = 0;
            while (i4 < fLines.length) {
                if (fLines[i4] != null) {
                    fLines[i4].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i4].setLocationFromOrg(fLines[i4].getAD_Org_ID(), false);
                }
                ++i4;
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            this.updateProductPO(as);
            this.updateProductInfo(as.getC_AcctSchema_ID());
            if (OFBForward.UpdateIVAPA()) {
                BigDecimal amtIVA = DB.getSQLValueBD((String)"C_Invoice_ID", (String)("SELECT ROUND(COALESCE(SUM(IVATaxAmt),0)) FROM C_InvoiceLine cil  INNER JOIN C_Tax ct ON (cil.C_Tax_ID = ct.C_Tax_ID) WHERE cil.IsActive = 'Y' AND IsTaxExempt = 'N' AND C_Invoice_ID = " + invoice.get_ID()), (Object[])new Object[0]);
                if (amtIVA == null) {
                    amtIVA = Env.ZERO;
                }
                BigDecimal oTax = invoice.getGrandTotal().subtract(invoice.getTotalLines()).subtract(amtIVA);
                int customTAx = this.getValidCombination_ID(219, as);
                fact.createLine(null, MAccount.get(this.getCtx(), customTAx), this.getC_Currency_ID(), oTax, null);
            }
        } else if (this.getDocumentType().equals("APC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, this.getAmount(2));
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), null, this.m_taxes[i].getAmount());
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, false);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), dAmt, null);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource().negate(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i5 = 0;
            while (i5 < fLines.length) {
                if (fLines[i5] != null) {
                    fLines[i5].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i5].setLocationFromOrg(fLines[i5].getAD_Org_ID(), false);
                }
                ++i5;
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
            if (OFBForward.UpdateIVAPA()) {
                BigDecimal amtIVA = DB.getSQLValueBD((String)"C_Invoice_ID", (String)("SELECT ROUND(COALESCE(SUM(IVATaxAmt),0)) FROM C_InvoiceLine cil  INNER JOIN C_Tax ct ON (cil.C_Tax_ID = ct.C_Tax_ID) WHERE cil.IsActive = 'Y' AND IsTaxExempt = 'N' AND C_Invoice_ID = " + invoice.get_ID()), (Object[])new Object[0]);
                if (amtIVA == null) {
                    amtIVA = Env.ZERO;
                }
                BigDecimal oTax = invoice.getGrandTotal().subtract(invoice.getTotalLines()).subtract(amtIVA);
                int customTAx = this.getValidCombination_ID(219, as);
                fact.createLine(null, MAccount.get(this.getCtx(), customTAx), this.getC_Currency_ID(), null, oTax);
            }
        } else if (this.getDocumentType().equals("ARB")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), dAmt, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i6 = 0;
            while (i6 < fLines.length) {
                if (fLines[i6] != null) {
                    fLines[i6].setLocationFromOrg(fLines[i6].getAD_Org_ID(), true);
                    fLines[i6].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i6;
            }
            int receivables_ID = this.getValidCombination_ID(8, as);
            int receivablesServices_ID = this.getValidCombination_ID(8, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else if (this.getDocumentType().equals("APB")) {
            System.out.println("*** AP Boleta");
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal TotalTax = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            TotalTax = DB.getSQLValueBD((String)"C_Invoice", (String)"Select (GrandTotal - TotalLines) from C_Invoice where C_Invoice_ID=?", (int)this.get_ID());
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), null, this.m_taxes[i].getAmount());
                TotalTax.add(this.m_taxes[i].getAmount());
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            System.out.println("*** TotalTax: " + TotalTax);
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal LineNetAmtTax2;
                MTax tax2;
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment() && !line.isAsset.booleanValue()) {
                    MTax tax22 = MTax.get(this.getCtx(), line.getC_Tax_ID());
                    BigDecimal LineNetAmtTax22 = tax22.calculateTax(line.getAmtSource(), false, this.getStdPrecision());
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource().add(LineNetAmtTax22), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost && !line.isAsset.booleanValue()) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                    }
                    tax2 = MTax.get(this.getCtx(), line.getC_Tax_ID());
                    LineNetAmtTax2 = tax2.calculateTax(line.getAmtSource(), false, this.getStdPrecision());
                    fact.createLine(line, expense, this.getC_Currency_ID(), amt.add(LineNetAmtTax2), dAmt);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                if (line.isAsset.booleanValue()) {
                    BigDecimal amt = line.getAmtSource();
                    int acct_id = DB.getSQLValue((String)"A_Asset_Group_Acct", (String)("select A_ASSET_ACCT from A_Asset_Group_Acct  where A_Asset_Group_ID=" + line.AssetGroup_ID + " and AD_CLient_ID=" + this.getAD_Client_ID()));
                    this.log.info("comb_ID:" + acct_id);
                    MAccount myacct = new MAccount(this.getCtx(), acct_id, null);
                    tax2 = MTax.get(this.getCtx(), line.getC_Tax_ID());
                    LineNetAmtTax2 = tax2.calculateTax(amt, false, this.getStdPrecision());
                    fact.createLine(line, myacct, this.getC_Currency_ID(), line.getAmtSource().add(LineNetAmtTax2), null);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i7 = 0;
            while (i7 < fLines.length) {
                if (fLines[i7] != null) {
                    fLines[i7].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i7].setLocationFromOrg(fLines[i7].getAD_Org_ID(), false);
                }
                ++i7;
            }
            int payables_ID = this.getValidCombination_ID(5, as);
            int payablesServices_ID = this.getValidCombination_ID(5, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), null, grossAmt.subtract(TotalTax));
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt.subtract(TotalTax));
            }
            this.updateProductPO(as);
            this.updateProductInfo(as.getC_AcctSchema_ID());
        } else if (this.getDocumentType().equals("PTK") && (client.getName().toLowerCase().contains("pedro de valdivia") || client.getName().toLowerCase().contains("geminis")) && invoice.getC_DocType().getName().toLowerCase().contains("reverso")) {
            this.log.config("if cpv o geminis");
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            int z = 0;
            while (z < this.p_lines.length) {
                block313: {
                    int receivables_ID = 0;
                    int receivablesServices_ID = 0;
                    int charge_IDAcct = 0;
                    if (this.p_lines[z].m_Payment_ID > 0) {
                        MPayment pay = new MPayment(this.getCtx(), this.p_lines[z].m_Payment_ID, this.getTrxName());
                        String SqlDetPay = "select fact_acct_id,account_id,amtsourcedr,amtsourcecr from fact_acct where record_id = " + pay.get_ID() + " and AD_Table_ID = 335 ";
                        CPreparedStatement pstmtDetP = null;
                        ResultSet rsDetP = null;
                        try {
                            try {
                                pstmtDetP = DB.prepareStatement((String)SqlDetPay, (String)this.getTrxName());
                                rsDetP = pstmtDetP.executeQuery();
                                while (rsDetP.next()) {
                                    BigDecimal sourceDR = rsDetP.getBigDecimal("amtsourcedr");
                                    BigDecimal sourceCR = rsDetP.getBigDecimal("amtsourcecr");
                                    if (sourceDR.compareTo(Env.ZERO) != 0) {
                                        fact.createLine(null, MAccount.get(new X_Fact_Acct(this.getCtx(), rsDetP.getInt("fact_acct_id"), this.getTrxName())), this.getC_Currency_ID(), null, sourceDR);
                                        continue;
                                    }
                                    if (sourceCR.compareTo(Env.ZERO) == 0) continue;
                                    fact.createLine(null, MAccount.get(new X_Fact_Acct(this.getCtx(), rsDetP.getInt("fact_acct_id"), this.getTrxName())), this.getC_Currency_ID(), sourceCR, null);
                                }
                            }
                            catch (SQLException e) {
                                this.log.log(Level.SEVERE, SqlDetPay, (Throwable)e);
                                DB.close((ResultSet)rsDetP, (Statement)pstmtDetP);
                                rsDetP = null;
                                pstmtDetP = null;
                                break block313;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rsDetP, pstmtDetP);
                            rsDetP = null;
                            pstmtDetP = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rsDetP, (Statement)pstmtDetP);
                        rsDetP = null;
                        pstmtDetP = null;
                    } else if (this.p_lines[z].getC_Charge_ID() > 0) {
                        receivables_ID = this.getValidCombination_ID(6, as);
                        receivablesServices_ID = this.getValidCombination_ID(6, as);
                        String sqlCVC_ID = "SELECT CH_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID = " + this.p_lines[z].getC_Charge_ID() + " AND C_AcctSchema_ID=?";
                        charge_IDAcct = DB.getSQLValue((String)this.getTrxName(), (String)sqlCVC_ID, (int)as.get_ID());
                        this.log.config("charge_IDAcct ID Valid Combination : " + charge_IDAcct);
                        if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                            grossAmt = this.p_lines[z].getAmtSource();
                            serviceAmt = Env.ZERO;
                        } else if (this.m_allLinesService) {
                            serviceAmt = this.p_lines[z].getAmtSource();
                            grossAmt = Env.ZERO;
                        }
                        BigDecimal amt = Env.ZERO;
                        if (grossAmt.signum() != 0) {
                            fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
                            amt = grossAmt;
                        }
                        if (serviceAmt.signum() != 0) {
                            fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
                            amt = serviceAmt;
                        }
                        this.log.config("Variable amt = " + amt);
                        if (amt != null && amt.signum() != 0) {
                            fact.createLine(null, MAccount.get(this.getCtx(), charge_IDAcct), this.getC_Currency_ID(), null, amt);
                        }
                    }
                }
                ++z;
            }
        } else if (this.getDocumentType().equals("VDC") && client.getName().toLowerCase().contains("pedro de valdivia") && invoice.getC_DocType().getName().toLowerCase().contains("reverso")) {
            this.log.config("if cpv");
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            int z = 0;
            while (z < this.p_lines.length) {
                block315: {
                    int receivables_ID = 0;
                    int receivablesServices_ID = 0;
                    int charge_IDAcct = 0;
                    if (this.p_lines[z].m_Payment_ID > 0) {
                        MPayment pay = new MPayment(this.getCtx(), this.p_lines[z].m_Payment_ID, this.getTrxName());
                        String SqlDetPay = "select fact_acct_id,account_id,amtsourcedr,amtsourcecr from fact_acct where record_id = " + pay.get_ID() + " and AD_Table_ID = 335 ";
                        CPreparedStatement pstmtDetP = null;
                        ResultSet rsDetP = null;
                        try {
                            try {
                                pstmtDetP = DB.prepareStatement((String)SqlDetPay, (String)this.getTrxName());
                                rsDetP = pstmtDetP.executeQuery();
                                while (rsDetP.next()) {
                                    BigDecimal sourceDR = rsDetP.getBigDecimal("amtsourcedr");
                                    BigDecimal sourceCR = rsDetP.getBigDecimal("amtsourcecr");
                                    if (sourceDR.compareTo(Env.ZERO) != 0) {
                                        fact.createLine(null, MAccount.get(new X_Fact_Acct(this.getCtx(), rsDetP.getInt("fact_acct_id"), this.getTrxName())), this.getC_Currency_ID(), null, sourceDR);
                                        continue;
                                    }
                                    if (sourceCR.compareTo(Env.ZERO) == 0) continue;
                                    fact.createLine(null, MAccount.get(new X_Fact_Acct(this.getCtx(), rsDetP.getInt("fact_acct_id"), this.getTrxName())), this.getC_Currency_ID(), sourceCR, null);
                                }
                            }
                            catch (SQLException e) {
                                this.log.log(Level.SEVERE, SqlDetPay, (Throwable)e);
                                DB.close((ResultSet)rsDetP, (Statement)pstmtDetP);
                                rsDetP = null;
                                pstmtDetP = null;
                                break block315;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rsDetP, pstmtDetP);
                            rsDetP = null;
                            pstmtDetP = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rsDetP, (Statement)pstmtDetP);
                        rsDetP = null;
                        pstmtDetP = null;
                    } else if (this.p_lines[z].getC_Charge_ID() > 0) {
                        receivables_ID = this.getValidCombination_ID(6, as);
                        receivablesServices_ID = this.getValidCombination_ID(6, as);
                        String sqlCVC_ID = "SELECT CH_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID = " + this.p_lines[z].getC_Charge_ID() + " AND C_AcctSchema_ID=?";
                        charge_IDAcct = DB.getSQLValue((String)this.getTrxName(), (String)sqlCVC_ID, (int)as.get_ID());
                        this.log.config("charge_IDAcct ID Valid Combination : " + charge_IDAcct);
                        if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                            grossAmt = this.p_lines[z].getAmtSource();
                            serviceAmt = Env.ZERO;
                        } else if (this.m_allLinesService) {
                            serviceAmt = this.p_lines[z].getAmtSource();
                            grossAmt = Env.ZERO;
                        }
                        BigDecimal amt = Env.ZERO;
                        if (grossAmt.signum() != 0) {
                            fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
                            amt = grossAmt;
                        }
                        if (serviceAmt.signum() != 0) {
                            fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
                            amt = serviceAmt;
                        }
                        this.log.config("Variable amt = " + amt);
                        if (amt != null && amt.signum() != 0) {
                            fact.createLine(null, MAccount.get(this.getCtx(), charge_IDAcct), this.getC_Currency_ID(), null, amt);
                        }
                    }
                }
                ++z;
            }
        } else if (this.getDocumentType().equals("PTK")) {
            this.log.config("if normal");
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), dAmt, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i8 = 0;
            while (i8 < fLines.length) {
                if (fLines[i8] != null) {
                    fLines[i8].setLocationFromOrg(fLines[i8].getAD_Org_ID(), true);
                    fLines[i8].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i8;
            }
            int z = 0;
            while (z < this.p_lines.length) {
                int receivables_ID = 0;
                int receivablesServices_ID = 0;
                if (this.p_lines[z].m_Payment_ID > 0) {
                    MPayment pay = new MPayment(this.getCtx(), this.p_lines[z].m_Payment_ID, this.getTrxName());
                    if ("L".equals(pay.getTenderType())) {
                        receivables_ID = this.getValidCombination_ID(7, as);
                        receivablesServices_ID = this.getValidCombination_ID(7, as);
                    } else {
                        receivables_ID = this.getValidCombination_ID(6, as);
                        receivablesServices_ID = this.getValidCombination_ID(6, as);
                    }
                } else {
                    receivables_ID = this.getValidCombination_ID(6, as);
                    receivablesServices_ID = this.getValidCombination_ID(6, as);
                }
                if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                    grossAmt = this.p_lines[z].getAmtSource();
                    serviceAmt = Env.ZERO;
                } else if (this.m_allLinesService) {
                    serviceAmt = this.p_lines[z].getAmtSource();
                    grossAmt = Env.ZERO;
                }
                if (grossAmt.signum() != 0) {
                    fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
                }
                if (serviceAmt.signum() != 0) {
                    fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
                }
                ++z;
            }
        } else if (this.getDocumentType().equals("CDC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
                this.log.info("amt cahrge:" + amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), dAmt, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            MInvoiceLine[] lines = invoice.getLines(true);
            int i9 = 0;
            while (i9 < fLines.length) {
                if (fLines[i9] != null) {
                    fLines[i9].setLocationFromOrg(fLines[i9].getAD_Org_ID(), true);
                    fLines[i9].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    fLines[i9].setAD_Org_ID(lines[i9].getAD_Org_ID());
                    if (fLines[i9].getAmtAcctCr().signum() > 0 && i9 < lines.length) {
                        if (lines[i9].get_ValueAsInt("C_Payment_ID") > 0) {
                            MPayment pay = new MPayment(this.getCtx(), lines[i9].get_ValueAsInt("C_Payment_ID"), this.getTrxName());
                            fLines[i9].setC_BPartner_ID(pay.getC_BPartner_ID());
                            this.log.info("payment found");
                        } else if (lines[i9].get_ValueAsInt("C_InvoiceFac_ID") > 0) {
                            MInvoice inv = new MInvoice(this.getCtx(), lines[i9].get_ValueAsInt("C_InvoiceFac_ID"), this.getTrxName());
                            fLines[i9].setC_BPartner_ID(inv.getC_BPartner_ID());
                            this.log.info("invoice found");
                        }
                    }
                }
                ++i9;
            }
            int receivables_ID = 0;
            int receivablesServices_ID = 0;
            receivables_ID = this.getValidCombination_ID(300, as);
            receivablesServices_ID = this.getValidCombination_ID(300, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else if (this.getDocumentType().equals("VDC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal camt = this.getAmount(2);
            if (camt != null && camt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
                this.log.info("amt charge:" + camt);
                this.log.config("fact created");
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                this.log.config("*fact created");
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                DocLine line = this.p_lines[i];
                MAccount expense = line.getAccount(2, as);
                if (line.isItem()) {
                    expense = line.getAccount(10, as);
                }
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                this.log.config("**fact created");
                fact.createLine(line, expense, this.getC_Currency_ID(), amt, dAmt);
                if (!line.isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            MInvoiceLine[] lines = invoice.getLines(true);
            this.log.config("fLines.length:" + fLines.length + "lines.length:" + lines.length);
            int i10 = 0;
            while (i10 < fLines.length) {
                if (fLines[i10] != null) {
                    fLines[i10].setLocationFromOrg(fLines[i10].getAD_Org_ID(), true);
                    fLines[i10].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    fLines[i10].setAD_Org_ID(lines[i10].getAD_Org_ID());
                    if (fLines[i10].getAmtAcctDr().signum() > 0 && i10 < lines.length) {
                        if (lines[i10].get_ValueAsInt("C_Payment_ID") > 0) {
                            MPayment pay = new MPayment(this.getCtx(), lines[i10].get_ValueAsInt("C_Payment_ID"), this.getTrxName());
                            fLines[i10].setC_BPartner_ID(pay.getC_BPartner_ID());
                            this.log.info("payment found");
                        } else if (lines[i10].get_ValueAsInt("C_InvoiceFac_ID") > 0) {
                            MInvoice inv = new MInvoice(this.getCtx(), lines[i10].get_ValueAsInt("C_InvoiceFac_ID"), this.getTrxName());
                            fLines[i10].setC_BPartner_ID(inv.getC_BPartner_ID());
                            this.log.info("invoice found");
                        }
                    }
                }
                ++i10;
            }
            int receivables_ID = 0;
            int receivablesServices_ID = 0;
            receivables_ID = this.getValidCombination_ID(301, as);
            receivablesServices_ID = this.getValidCombination_ID(301, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
        } else if (this.getDocumentType().equals("FAT") && invoice.isSOTrx()) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                MInvoiceLine invl = new MInvoiceLine(this.getCtx(), this.p_lines[i].get_ID(), this.getTrxName());
                MAccount account = null;
                account = invl.get_ValueAsInt("C_Payment_ID") > 0 ? this.getAccount(invl.get_ValueAsInt("C_Payment_ID"), 0) : (invl.get_ValueAsInt("C_InvoiceFac_ID") > 0 ? this.getAccount(0, invl.get_ValueAsInt("C_InvoiceFac_ID")) : this.p_lines[i].getAccount(1, as));
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(this.p_lines[i], account, this.getC_Currency_ID(), null, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i11 = 0;
            while (i11 < fLines.length) {
                if (fLines[i11] != null) {
                    fLines[i11].setLocationFromOrg(fLines[i11].getAD_Org_ID(), true);
                    fLines[i11].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i11;
            }
            int receivables_ID = this.getValidCombination_ID(302, as);
            int receivablesServices_ID = this.getValidCombination_ID(302, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
            if (grossAmt.signum() != 0) {
                this.log.severe("valor antes de fact grossAmt=" + grossAmt);
                fact.createLine(null, MAccount.get(this.getCtx(), this.getValidCombination_ID(217, as)), this.getC_Currency_ID(), grossAmt, null);
                fact.createLine(null, MAccount.get(this.getCtx(), this.getValidCombination_ID(218, as)), this.getC_Currency_ID(), null, grossAmt);
            }
        } else if (this.getDocumentType().equals("FAT") && !invoice.isSOTrx() && !invoice.get_ValueAsBoolean("Extinguir")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), amt, null);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt, null)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                MInvoiceLine invl = new MInvoiceLine(this.getCtx(), this.p_lines[i].get_ID(), this.getTrxName());
                MAccount account = null;
                account = invl.get_ValueAsInt("C_Payment_ID") > 0 ? this.getAccount(invl.get_ValueAsInt("C_Payment_ID"), 0) : (invl.get_ValueAsInt("C_InvoiceFac_ID") > 0 ? this.getAccount(0, invl.get_ValueAsInt("C_InvoiceFac_ID")) : this.p_lines[i].getAccount(1, as));
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(this.p_lines[i], account, this.getC_Currency_ID(), amt, null);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i12 = 0;
            while (i12 < fLines.length) {
                if (fLines[i12] != null) {
                    fLines[i12].setLocationFromOrg(fLines[i12].getAD_Org_ID(), true);
                    fLines[i12].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i12;
            }
            int receivables_ID = this.getValidCombination_ID(302, as);
            int receivablesServices_ID = this.getValidCombination_ID(302, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            if (grossAmt.signum() != 0) {
                this.log.severe("valor antes de fact grossAmt=" + grossAmt);
                fact.createLine(null, MAccount.get(this.getCtx(), this.getValidCombination_ID(217, as)), this.getC_Currency_ID(), null, grossAmt);
                fact.createLine(null, MAccount.get(this.getCtx(), this.getValidCombination_ID(218, as)), this.getC_Currency_ID(), grossAmt, null);
            }
        } else if (this.getDocumentType().equals("FAT") && !invoice.isSOTrx() && invoice.get_ValueAsBoolean("Extinguir")) {
            BigDecimal grossAmt = this.getAmount(0);
            this.log.severe("valor grossAmt=" + grossAmt);
            BigDecimal amt = this.getAmount(2);
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt, null)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            if (grossAmt.signum() != 0) {
                this.log.severe("valor antes de fact grossAmt=" + grossAmt);
                fact.createLine(null, MAccount.get(this.getCtx(), this.getValidCombination_ID(217, as)), this.getC_Currency_ID(), null, grossAmt);
                fact.createLine(null, MAccount.get(this.getCtx(), this.getValidCombination_ID(218, as)), this.getC_Currency_ID(), grossAmt, null);
            }
        } else if (this.getDocumentType().equals("APS")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            int i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i13 = 0;
            while (i13 < fLines.length) {
                if (fLines[i13] != null) {
                    fLines[i13].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i13].setLocationFromOrg(fLines[i13].getAD_Org_ID(), false);
                }
                ++i13;
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            this.updateProductPO(as);
            this.updateProductInfo(as.getC_AcctSchema_ID());
        } else if (this.getDocumentType().equals("PSC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, this.getAmount(2));
            int i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, false);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), dAmt, null);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource().negate(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i14 = 0;
            while (i14 < fLines.length) {
                if (fLines[i14] != null) {
                    fLines[i14].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i14].setLocationFromOrg(fLines[i14].getAD_Org_ID(), false);
                }
                ++i14;
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else if (this.getDocumentType().equals("APA")) {
            int compromiseacct_ID;
            this.log.config("Compromiso");
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            MInvoicePaySchedule[] lines = MInvoicePaySchedule.getInvoicePaySchedule((Properties)invoice.getCtx(), (int)invoice.getC_Invoice_ID(), (int)0, (String)invoice.get_TrxName());
            this.log.config("Cuotas :" + lines.length);
            int i15 = 0;
            while (i15 < lines.length) {
                FactLine fl;
                if (i15 < 12) {
                    fl = fact.createLine(null, this.getAccount(306, as, invoice), invoice.getC_Currency_ID(), null, lines[i15].getDueAmt());
                    this.log.config("Cuotas :" + lines[i15].getDueAmt());
                    fl.setDescription("Cuota Compromiso");
                } else {
                    fl = fact.createLine(null, this.getAccount(305, as, invoice), invoice.getC_Currency_ID(), null, lines[i15].getDueAmt());
                    fl.setDescription("Cuota Compromiso");
                    this.log.config("Cuotas :" + lines[i15].getDueAmt());
                }
                ++i15;
            }
            FactLine[] fLines = fact.getLines();
            int i16 = 0;
            while (i16 < fLines.length) {
                if (fLines[i16] != null) {
                    fLines[i16].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i16].setLocationFromOrg(fLines[i16].getAD_Org_ID(), false);
                }
                ++i16;
            }
            int payables_ID = compromiseacct_ID = this.getValidCombination_ID(303, as, invoice);
            int payablesServices_ID = compromiseacct_ID;
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
            this.updateProductPO(as);
            this.updateProductInfo(as.getC_AcctSchema_ID());
        } else if (this.getDocumentType().equals("APL")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        OFBProductCost.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i17 = 0;
            while (i17 < fLines.length) {
                if (fLines[i17] != null) {
                    fLines[i17].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i17].setLocationFromOrg(fLines[i17].getAD_Org_ID(), false);
                }
                ++i17;
            }
            int payables_ID = this.getValidCombination_ID(304, as);
            int payablesServices_ID = this.getValidCombination_ID(304, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            this.updateProductPO(as);
            this.updateProductInfo(as.getC_AcctSchema_ID());
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    public BigDecimal createFactCash(MAcctSchema as, Fact fact, BigDecimal multiplier) {
        boolean creditMemo = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
        boolean payables = this.getDocumentType().equals("API") || this.getDocumentType().equals("APC");
        BigDecimal acctAmt = Env.ZERO;
        FactLine fl = null;
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            boolean landedCost = false;
            if (payables) {
                landedCost = this.landedCost(as, fact, line, false);
            }
            if (landedCost && as.isExplicitCostAdjustment()) {
                fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                String desc = line.getDescription();
                desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                fl.setDescription(desc);
            }
            if (!landedCost) {
                MAccount acct = line.getAccount(payables ? 2 : 1, as);
                if (payables && line.isItem()) {
                    acct = line.getAccount(10, as);
                }
                BigDecimal amt = line.getAmtSource().multiply(multiplier);
                BigDecimal amt2 = null;
                if (creditMemo) {
                    amt2 = amt;
                    amt = null;
                }
                if ((fl = payables ? fact.createLine(line, acct, this.getC_Currency_ID(), amt, amt2) : fact.createLine(line, acct, this.getC_Currency_ID(), amt2, amt)) != null) {
                    acctAmt = acctAmt.add(fl.getAcctBalance());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_taxes.length) {
            BigDecimal amt = this.m_taxes[i].getAmount();
            BigDecimal amt2 = null;
            if (creditMemo) {
                amt2 = amt;
                amt = null;
            }
            FactLine tl = null;
            tl = payables ? fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), amt, amt2) : fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt2, amt);
            if (tl != null) {
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            ++i;
        }
        FactLine[] fLines = fact.getLines();
        int i2 = 0;
        while (i2 < fLines.length) {
            if (fLines[i2] != null) {
                if (payables) {
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), false);
                } else {
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
            }
            ++i2;
        }
        return acctAmt;
    }

    private boolean landedCost(MAcctSchema as, Fact fact, DocLine line, boolean dr) {
        int C_InvoiceLine_ID = line.get_ID();
        MLandedCostAllocation[] lcas = MLandedCostAllocation.getOfInvoiceLine((Properties)this.getCtx(), (int)C_InvoiceLine_ID, (String)this.getTrxName());
        if (lcas.length == 0) {
            return false;
        }
        double totalBase = 0.0;
        int i = 0;
        while (i < lcas.length) {
            totalBase += lcas[i].getBase().doubleValue();
            ++i;
        }
        MInvoiceLine il = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        int i2 = 0;
        while (i2 < lcas.length) {
            MLandedCostAllocation lca = lcas[i2];
            if (lca.getBase().signum() != 0) {
                double percent = lca.getBase().doubleValue() / totalBase;
                String desc = il.getDescription();
                desc = desc == null ? String.valueOf(percent) + "%" : String.valueOf(desc) + " - " + percent + "%";
                if (line.getDescription() != null) {
                    desc = String.valueOf(desc) + " - " + line.getDescription();
                }
                ProductCost pc = new ProductCost(Env.getCtx(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), this.getTrxName());
                BigDecimal drAmt = null;
                BigDecimal crAmt = null;
                if (dr) {
                    drAmt = lca.getAmt();
                } else {
                    crAmt = lca.getAmt();
                }
                FactLine fl = fact.createLine(line, pc.getAccount(9, as), this.getC_Currency_ID(), drAmt, crAmt);
                fl.setDescription(desc);
                fl.setM_Product_ID(lca.getM_Product_ID());
                BigDecimal allocationAmt = lca.getAmt();
                if (this.getC_Currency_ID() != as.getC_Currency_ID()) {
                    allocationAmt = MConversionRate.convert(this.getCtx(), allocationAmt, this.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                }
                if (allocationAmt.scale() > as.getCostingPrecision()) {
                    allocationAmt = allocationAmt.setScale(as.getCostingPrecision(), 4);
                }
                if (!dr) {
                    allocationAmt = allocationAmt.negate();
                }
                desc = "landedCosts ||" + desc;
                OFBProductCost.createInvoice(as, lca.getAD_Org_ID(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), C_InvoiceLine_ID, lca.getM_CostElement_ID(), allocationAmt, Env.ZERO, desc, this.getTrxName());
            }
            ++i2;
        }
        this.log.config("Created #" + lcas.length);
        return true;
    }

    private void updateProductPO(MAcctSchema as) {
        MClientInfo ci = MClientInfo.get((Properties)this.getCtx(), (int)as.getAD_Client_ID());
        if (ci.getC_AcctSchema1_ID() != as.getC_AcctSchema_ID()) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_PO po SET PriceLastInv = (SELECT currencyConvert(il.PriceActual,i.C_Currency_ID,po.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) FROM C_Invoice i, C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID");
        if (DB.isOracle()) {
            sql.append(" AND ROWNUM=1 ");
        } else {
            sql.append(" AND il.C_InvoiceLine_ID = (SELECT MIN(il1.C_InvoiceLine_ID) FROM C_Invoice i1, C_InvoiceLine il1 WHERE i1.C_Invoice_ID=il1.C_Invoice_ID AND po.M_Product_ID=il1.M_Product_ID AND po.C_BPartner_ID=i1.C_BPartner_ID").append("  AND i1.C_Invoice_ID=").append(this.get_ID()).append(") ");
        }
        sql.append("  AND i.C_Invoice_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM C_Invoice i, C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID AND i.C_Invoice_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.getTrxName());
        this.log.fine("Updated=" + no);
    }

    private void updateProductInfo(int C_AcctSchema_ID) {
        this.log.fine("C_Invoice_ID=" + this.get_ID());
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing pc SET (PriceLastInv, TotalInvAmt,TotalInvQty) = (SELECT currencyConvert(il.PriceActual,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(il.LineNetAmt,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID),il.QtyInvoiced FROM C_Invoice i, C_InvoiceLine il, C_AcctSchema a WHERE i.C_Invoice_ID=il.C_Invoice_ID AND il.c_invoiceline_id = (SELECT MIN(C_InvoiceLine_ID) FROM C_InvoiceLine il2 WHERE  il2.M_PRODUCT_ID=il.M_PRODUCT_ID AND C_Invoice_ID=").append(this.get_ID()).append(") AND pc.M_Product_ID=il.M_Product_ID AND pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND i.C_Invoice_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM C_Invoice i, C_InvoiceLine il, C_AcctSchema a WHERE i.C_Invoice_ID=il.C_Invoice_ID AND pc.M_Product_ID=il.M_Product_ID AND pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND i.C_Invoice_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.getTrxName());
        this.log.fine("M_Product_Costing - Updated=" + no);
    }

    public MAccount getAccount(int payment_ID, int invoice_ID) {
        MAccount account;
        block8: {
            account = null;
            String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID = ? AND Record_ID=? AND AmtAcctDr>0";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                    if (payment_ID > 0) {
                        pstmt.setInt(1, 335);
                        pstmt.setInt(2, payment_ID);
                    } else {
                        pstmt.setInt(1, 318);
                        pstmt.setInt(2, invoice_ID);
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        account = MAccount.get(new X_Fact_Acct(this.getCtx(), rs, this.getTrxName()));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return account;
    }

    private final MAccount getAccount(int AcctType, MAcctSchema as, MInvoice invoice) {
        int C_ValidCombination_ID = this.getValidCombination_ID(AcctType, as, invoice);
        if (C_ValidCombination_ID == 0) {
            return null;
        }
        MAccount acct = MAccount.get(as.getCtx(), C_ValidCombination_ID);
        this.log.config("acct:" + (Object)((Object)acct));
        return acct;
    }

    private int getValidCombination_ID(int AcctType, MAcctSchema as, MInvoice invoice) {
        int para_1 = 0;
        String sql = null;
        if (AcctType == 303) {
            sql = "SELECT C_CompAdq_Acct FROM C_DocType WHERE C_DocType_ID=?";
            para_1 = invoice.getC_DocType_ID();
        } else if (AcctType == 305) {
            sql = "SELECT C_CompAdqLargo_Acct FROM C_DocType WHERE C_DocType_ID=?";
            para_1 = invoice.getC_DocType_ID();
        } else if (AcctType == 306) {
            sql = "SELECT C_CompAdqCorto_Acct FROM C_DocType WHERE C_DocType_ID=?";
            para_1 = invoice.getC_DocType_ID();
        }
        int Account_ID = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, para_1);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Account_ID = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "AcctType=" + AcctType + " - SQL=" + sql, (Throwable)e);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return 0;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (Account_ID == 0) {
            this.log.severe("NO account Type=" + AcctType + ", Record=" + invoice.get_ID());
            return 0;
        }
        this.log.config("Account_ID :" + Account_ID);
        return Account_ID;
    }
}

