/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MElementValue;
import org.compiere.model.MProduct;
import org.compiere.model.X_C_Project;
import org.compiere.model.X_C_ProjectType;
import org.compiere.model.X_C_ValidCombination;
import org.compiere.model.X_DM_Document;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_DMDocument
extends Doc {
    private int m_precision = -1;

    public Doc_DMDocument(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, X_DM_Document.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        X_DM_Document dmd = new X_DM_Document(this.getCtx(), this.getPO().get_ID(), null);
        this.setDateDoc(dmd.getDateTrx());
        this.setDateAcct(dmd.getDateTrx());
        this.setAmount(0, new BigDecimal("0.0"));
        this.setAmount(1, new BigDecimal("0.0"));
        return null;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue);
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact;
        ArrayList<Fact> facts;
        block20: {
            facts = new ArrayList<Fact>();
            String dt = this.p_po.get_Value("DM_DocumentType").toString();
            if (!dt.equals("RS")) {
                return facts;
            }
            MDocType DocType = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"DMR")[0];
            if (!DocType.get_ValueAsBoolean("Posted")) {
                return facts;
            }
            fact = new Fact((Doc)this, as, "B");
            X_DM_Document DMDoc = new X_DM_Document(this.getCtx(), this.p_po.get_ID(), this.getTrxName());
            if (!as.isAccrual()) {
                return facts;
            }
            if (this.getDocumentType().equals("DMR")) {
                ResultSet rs;
                CPreparedStatement pstmt;
                block19: {
                    String sql = "Select dm1.dm_document_id, dl.c_project_id, dl2.c_projectline_id, dl2.amt, dl2.m_product_id from dm_document dm1 inner join dm_documentline dl on (dm1.dm_document_id = dl.dm_document_id) inner join DM_Document dm2 on (dl.DM_DocumentRef_ID = dm2.DM_Document_ID) inner join dm_documentline dl2 on (dm2.DM_Document_ID = dl2.DM_Document_ID) where dm1.DM_Document_ID = ?";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                            pstmt.setInt(1, this.p_po.get_ID());
                            rs = pstmt.executeQuery();
                            FactLine fl = null;
                            while (rs.next()) {
                                String anb;
                                X_C_Project pj = new X_C_Project(this.getCtx(), rs.getInt(2), this.getTrxName());
                                X_C_ProjectType pt = new X_C_ProjectType(this.getCtx(), Integer.parseInt(pj.get_Value("C_ProjectType_ID").toString()), this.getTrxName());
                                MProduct pro = new MProduct(this.getCtx(), rs.getInt(5), this.getTrxName());
                                BigDecimal amt = new BigDecimal("0.0");
                                amt = rs.getBigDecimal(4);
                                String sql2 = "";
                                sql2 = "select MAX(P_Cir33_Acct) from M_Product_Acct where M_Product_ID=? and C_AcctSchema_ID=?";
                                int cvcID = DB.getSQLValue((String)this.getTrxName(), (String)sql2, (int)pro.get_ID(), (int)as.get_ID());
                                X_C_ValidCombination cvc = new X_C_ValidCombination(this.getCtx(), cvcID, this.getTrxName());
                                String alias = String.valueOf(cvc.getAlias()) + pro.get_ValueAsString("AccountNo") + ".";
                                alias = alias.trim();
                                String anS = anb = pj.get_ValueAsString("AccountNo");
                                String aliaspro = String.valueOf(alias) + anS;
                                aliaspro = aliaspro.trim();
                                String sql3 = "select MAX(C_ValidCombination_ID) from C_ValidCombination where alias like ?";
                                int cvcID3 = DB.getSQLValue((String)this.getTrxName(), (String)sql3, (String)aliaspro);
                                if (cvcID3 <= 0) {
                                    String sql4 = "select C_ElementValue_ID from C_ElementValue where Value = ?";
                                    int element_ID = DB.getSQLValue((String)this.getTrxName(), (String)sql4, (String)aliaspro);
                                    this.log.config("element_ID 1:" + element_ID);
                                    if (element_ID <= 0) {
                                        this.log.config("crear elemento");
                                        MElementValue element = new MElementValue(this.getCtx(), aliaspro, aliaspro, "Cuenta Proyecto " + pj.getName(), "E", "N", false, false, this.getTrxName());
                                        element.setC_Element_ID(1000000);
                                        element.save();
                                        this.log.config("elemento guardado");
                                        element_ID = element.getC_ElementValue_ID();
                                        this.log.config("element_ID 2:" + element_ID);
                                    }
                                    MAccount newAccount = new MAccount(this.getCtx(), 0, this.getTrxName());
                                    newAccount.setAD_Org_ID(0);
                                    newAccount.setAlias(aliaspro);
                                    newAccount.setC_AcctSchema_ID(1000000);
                                    newAccount.setAccount_ID(element_ID);
                                    newAccount.save();
                                    cvcID3 = newAccount.getC_ValidCombination_ID();
                                }
                                DB.executeUpdate((String)("Update C_ProjectLine set PJ_Item_Acct=" + cvcID3 + " Where C_Project_ID=" + rs.getInt(2) + " and M_Product_ID=" + rs.getInt(5)), (String)this.getTrxName());
                                fl = fact.createLine(null, MAccount.get(this.getCtx(), cvcID), this.getC_Currency_ID(), amt.multiply(new BigDecimal("-1.0")), null);
                                fact.createLine(null, MAccount.get(this.getCtx(), cvcID3), this.getC_Currency_ID(), amt, null);
                                fl.save();
                            }
                            String isACT = "N";
                            if (DMDoc.isActive()) {
                                isACT = "Y";
                            }
                            String insetC = "INSERT INTO  t_fact_acctgore (fact_acct_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby, ad_table_id,record_id, c_bpartner_id,description,tipo,monto,datetrx,m_product_id,c_project_id,documentno) VALUES (" + fl.get_ID() + "," + DMDoc.getAD_Client_ID() + "," + DMDoc.getAD_Org_ID() + ",'" + isACT + "','" + DMDoc.getCreated() + "'," + DMDoc.getCreatedBy() + ",'" + DMDoc.getUpdated() + "'," + DMDoc.getUpdatedBy() + "," + DMDoc.get_Table_ID() + "," + DMDoc.get_ID() + ",0,'" + DMDoc.getDescription() + "','" + "CAB" + "'," + DMDoc.getAmt() + ",'" + DMDoc.getDateTrx() + "',0,0,'" + DMDoc.getDocumentNo() + "')";
                            DB.executeUpdate((String)insetC, (String)this.getTrxName());
                            String sqlAux1 = "SELECT dl.ad_client_id, dl.ad_org_id, dl.isactive, dl.created, dl.createdby, dl.updated, dl.updatedby, 0 as c_bpartner_id,coalesce(dr.description,'--') as description,'LIN' as tipo, dl.amt AS amt, dr.datetrx, dr.documentno as documentno, dr.c_project_id,0 as M_Product_ID,0 as debito,0 as credito FROM DM_Document doc LEFT JOIN DM_DocumentLine dl ON (doc.DM_Document_ID = dl.DM_Document_ID) LEFT JOIN DM_Document dr ON (dl.DM_DocumentRef_ID = dr.DM_Document_ID) WHERE doc.DM_Document_ID=?";
                            CPreparedStatement pstmtaux = null;
                            ResultSet rsaux = null;
                            try {
                                try {
                                    pstmtaux = DB.prepareStatement((String)sqlAux1, (String)this.getTrxName());
                                    pstmtaux.setInt(1, DMDoc.get_ID());
                                    rsaux = pstmtaux.executeQuery();
                                    while (rsaux.next()) {
                                        String inset = "INSERT INTO  t_fact_acctgore (fact_acct_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby, ad_table_id,record_id, c_bpartner_id,description,tipo,monto,documentno,datetrx,debito,credito,m_product_id,c_project_id) VALUES (" + fl.get_ID() + "," + rsaux.getInt("AD_Client_ID") + "," + rsaux.getInt("ad_org_id") + ",'" + rsaux.getString("isactive") + "','" + rsaux.getTimestamp("Created") + "'," + rsaux.getInt("CreatedBy") + ",'" + rsaux.getTimestamp("Updated") + "'," + rsaux.getInt("UpdatedBy") + "," + DMDoc.get_Table_ID() + "," + DMDoc.get_ID() + "," + rsaux.getInt("c_bpartner_id") + ",'" + rsaux.getString("description") + "','" + rsaux.getString("tipo") + "'," + rsaux.getBigDecimal("amt") + ",'" + rsaux.getString("documentno") + "','" + rsaux.getTimestamp("datetrx") + "'," + rsaux.getBigDecimal("debito") + "," + rsaux.getBigDecimal("credito") + "," + rsaux.getInt("M_Product_ID") + "," + rsaux.getInt("C_Project_ID") + ")";
                                        DB.executeUpdate((String)inset, (String)this.getTrxName());
                                    }
                                }
                                catch (SQLException e) {
                                    this.log.log(Level.SEVERE, sqlAux1, (Throwable)e);
                                    DB.close(rsaux, (Statement)pstmtaux);
                                    rsaux = null;
                                    pstmtaux = null;
                                    break block19;
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close(rsaux, pstmtaux);
                                rsaux = null;
                                pstmtaux = null;
                                throw throwable;
                            }
                            DB.close((ResultSet)rsaux, (Statement)pstmtaux);
                            rsaux = null;
                            pstmtaux = null;
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, sql, (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            } else {
                this.p_Error = "DocumentType unknown: " + this.getDocumentType();
                this.log.log(Level.SEVERE, this.p_Error);
                fact = null;
            }
        }
        facts.add(fact);
        return facts;
    }
}

