/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_Cash;
import org.compiere.model.MCashLine;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.util.Env;

public class DocLine_Cash
extends DocLine {
    private String m_CashType = "";
    public static final String CASHTYPE_CHARGE = "C";
    public static final String CASHTYPE_DIFFERENCE = "D";
    public static final String CASHTYPE_EXPENSE = "E";
    public static final String CASHTYPE_INVOICE = "I";
    public static final String CASHTYPE_RECEIPT = "R";
    public static final String CASHTYPE_TRANSFER = "T";
    private int m_C_BankAccount_ID = 0;
    private int m_C_Invoice_ID = 0;
    private int m_C_Payment_ID = 0;
    private BigDecimal m_Amount = Env.ZERO;
    private BigDecimal m_DiscountAmt = Env.ZERO;
    private BigDecimal m_WriteOffAmt = Env.ZERO;

    public DocLine_Cash(MCashLine line, Doc_Cash doc) {
        super((PO)((Object)line), doc);
        this.m_CashType = line.getCashType();
        this.m_C_BankAccount_ID = line.getC_BankAccount_ID();
        this.m_C_Invoice_ID = line.getC_Invoice_ID();
        this.m_C_Payment_ID = line.getC_Payment_ID();
        if (this.m_C_Invoice_ID != 0) {
            MInvoice invoice = MInvoice.get(line.getCtx(), this.m_C_Invoice_ID);
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        }
        this.m_Amount = line.getAmount();
        this.m_DiscountAmt = line.getDiscountAmt();
        this.m_WriteOffAmt = line.getWriteOffAmt();
        this.setAmount(this.m_Amount);
    }

    public String getCashType() {
        return this.m_CashType;
    }

    public int getC_BankAccount_ID() {
        return this.m_C_BankAccount_ID;
    }

    public int getC_Invoice_ID() {
        return this.m_C_Invoice_ID;
    }

    public BigDecimal getAmount() {
        return this.m_Amount;
    }

    public BigDecimal getDiscountAmt() {
        return this.m_DiscountAmt;
    }

    public BigDecimal getWriteOffAmt() {
        return this.m_WriteOffAmt;
    }

    public int getC_Payment_ID() {
        return this.m_C_Payment_ID;
    }
}

