/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.sql.Timestamp;
import org.blumos.model.BlumosUtilities;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.ofb.utils.DateUtils;

public class ModBlumosValidaTurno
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosValidaTurno.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx() && order.getDeliveryViaRule().compareTo("P") != 0 && order.getDeliveryViaRule().compareTo("V") != 0 && order.getM_Warehouse_ID() == 1000000 && !order.get_ValueAsBoolean("Solutec")) {
            Timestamp newDatePromise = order.getDatePromised();
            if (BlumosUtilities.DameSumarDiasTurno(DateUtils.now(), order.getDatePromised()) > 0) {
                newDatePromise = DateUtils.SumarDias(newDatePromise, BlumosUtilities.DameSumarDiasTurno(DateUtils.now(), order.getDatePromised()));
            }
            order.setDatePromised(newDatePromise);
            order.setPriorityRule(BlumosUtilities.DameTurno(DateUtils.now(), order.getDatePromised()));
            order.save(po.get_TrxName());
            MOrderLine[] lines = order.getLines(true, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                Timestamp date = (Timestamp)line.get_Value("rrstartdate");
                if (date == null) {
                    line.set_CustomColumn("rrstartdate", line.getDatePromised());
                    line.set_CustomColumn("Qty_Original", line.getQtyOrdered());
                    line.save(po.get_TrxName());
                }
                if (line.getDatePromised().compareTo(newDatePromise) <= 0) {
                    line.setDatePromised(newDatePromise);
                    line.save(po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

