/*
 * Decompiled with CFR 0.152.
 */
package org.baskakow.model;

import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModBaskakowUpdateSO_Credit
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBaskakowUpdateSO_Credit.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", (ModelValidator)this);
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == MBPartner.Table_ID && (po.is_ValueChanged("TotalOpenBalanceOFB") || po.is_ValueChanged("SO_CreditUsedOFB") || po.is_ValueChanged("SO_CreditLimit"))) {
            MBPartner bp = (MBPartner)((Object)po);
            BigDecimal usedOFB = Env.ZERO;
            usedOFB = (BigDecimal)bp.get_Value("SO_CreditUsedOFB") == null ? Env.ZERO : (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
            BigDecimal amtOpen = bp.getSO_CreditLimit().subtract(usedOFB);
            bp.setTotalOpenBalance(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.set_CustomColumn("TotalOpenBalanceOFB", amtOpen);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        BigDecimal usedOFB;
        MPayment pay;
        BigDecimal amtTemp;
        BigDecimal amtTax;
        MInOutLine sLine;
        MInOutLine[] fromLines;
        BigDecimal invAmt;
        MBPartner bp;
        MInOut ship;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID) {
            BigDecimal usedOFB2;
            ship = (MInOut)((Object)po);
            bp = new MBPartner(po.getCtx(), ship.getC_BPartner_ID(), po.get_TrxName());
            invAmt = Env.ZERO;
            fromLines = ship.getLines(false);
            int i = 0;
            while (i < fromLines.length) {
                sLine = fromLines[i];
                if (sLine.getC_OrderLine_ID() > 0) {
                    amtTax = Env.ZERO;
                    amtTemp = Env.ZERO;
                    amtTemp = sLine.getQtyEntered().multiply(sLine.getC_OrderLine().getPriceEntered());
                    amtTax = amtTemp.multiply(sLine.getC_OrderLine().getC_Tax().getRate().divide(Env.ONEHUNDRED));
                    amtTemp = amtTemp.add(amtTax);
                    amtTemp = amtTemp.setScale(sLine.getC_OrderLine().getC_Order().getC_Currency().getStdPrecision(), 4);
                    invAmt = invAmt.add(amtTemp);
                }
                ++i;
            }
            if (invAmt == null) {
                invAmt = Env.ZERO;
            }
            if ((usedOFB2 = (BigDecimal)bp.get_Value("SO_CreditUsedOFB")) == null) {
                usedOFB2 = Env.ZERO;
            }
            usedOFB2 = ship.isSOTrx() ? usedOFB2.add(invAmt) : usedOFB2.subtract(invAmt);
            bp.set_CustomColumn("SO_CreditUsedOFB", usedOFB2);
            bp.set_CustomColumn("TotalOpenBalanceOFB", bp.getSO_CreditLimit().subtract(usedOFB2));
            bp.setTotalOpenBalance(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.save();
        }
        if (timing == 2 && po.get_Table_ID() == MInOut.Table_ID) {
            BigDecimal usedOFB3;
            ship = (MInOut)((Object)po);
            bp = new MBPartner(po.getCtx(), ship.getC_BPartner_ID(), po.get_TrxName());
            invAmt = Env.ZERO;
            fromLines = ship.getLines(false);
            int i = 0;
            while (i < fromLines.length) {
                sLine = fromLines[i];
                if (sLine.getC_OrderLine_ID() > 0) {
                    amtTax = Env.ZERO;
                    amtTemp = Env.ZERO;
                    amtTemp = sLine.getQtyEntered().multiply(sLine.getC_OrderLine().getPriceEntered());
                    amtTax = amtTemp.multiply(sLine.getC_OrderLine().getC_Tax().getRate().divide(Env.ONEHUNDRED));
                    amtTemp = amtTemp.add(amtTax);
                    amtTemp = amtTemp.setScale(sLine.getC_OrderLine().getC_Order().getC_Currency().getStdPrecision(), 4);
                    invAmt = invAmt.add(amtTemp);
                }
                ++i;
            }
            if (invAmt == null) {
                invAmt = Env.ZERO;
            }
            if ((usedOFB3 = (BigDecimal)bp.get_Value("SO_CreditUsedOFB")) == null) {
                usedOFB3 = Env.ZERO;
            }
            usedOFB3 = ship.isSOTrx() ? usedOFB3.subtract(invAmt) : usedOFB3.add(invAmt);
            bp.set_CustomColumn("SO_CreditUsedOFB", usedOFB3);
            bp.set_CustomColumn("TotalOpenBalanceOFB", bp.getSO_CreditLimit().subtract(usedOFB3));
            bp.setTotalOpenBalance(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.save();
        }
        if (timing == 9 && po.get_Table_ID() == MPayment.Table_ID) {
            pay = (MPayment)((Object)po);
            bp = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
            usedOFB = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
            if (usedOFB == null) {
                usedOFB = Env.ZERO;
            }
            usedOFB = pay.isReceipt() ? usedOFB.subtract(pay.getPayAmt()) : usedOFB.add(pay.getPayAmt());
            bp.set_CustomColumn("SO_CreditUsedOFB", usedOFB);
            bp.set_CustomColumn("TotalOpenBalanceOFB", bp.getSO_CreditLimit().subtract(usedOFB));
            bp.setTotalOpenBalance(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.save();
        }
        if (timing == 2 && po.get_Table_ID() == MPayment.Table_ID) {
            pay = (MPayment)((Object)po);
            bp = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
            usedOFB = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
            if (usedOFB == null) {
                usedOFB = Env.ZERO;
            }
            usedOFB = pay.isReceipt() ? usedOFB.add(pay.getPayAmt()) : usedOFB.subtract(pay.getPayAmt());
            bp.set_CustomColumn("SO_CreditUsedOFB", usedOFB);
            bp.set_CustomColumn("TotalOpenBalanceOFB", bp.getSO_CreditLimit().subtract(usedOFB));
            bp.setTotalOpenBalance(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.save();
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

