/*
 * Decompiled with CFR 0.152.
 */
package org.andes.model;

import java.math.BigDecimal;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_CD_Header;
import org.compiere.model.X_CD_Line;
import org.compiere.model.X_CD_Summary;
import org.compiere.model.X_CD_Transfer;
import org.compiere.model.X_C_BankAccountBalance;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModAndesCD3
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModAndesCD3.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("CD_Line", (ModelValidator)this);
        engine.addModelChange("CD_Header", (ModelValidator)this);
        engine.addModelChange("CD_Transfer", (ModelValidator)this);
        engine.addModelChange("CD_Summary", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        X_CD_Summary summ;
        X_CD_Transfer trans;
        X_CD_Header cab;
        X_CD_Summary sum;
        BigDecimal amtIN;
        int ID_Summary;
        X_CD_Line line;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Line.Table_ID) {
            line = (X_CD_Line)po;
            ID_Summary = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + line.getCD_Header_ID()));
            amtIN = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + line.getCD_Header_ID() + " AND Type = 'IN'"), (Object[])new Object[0]);
            BigDecimal amtEG = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + line.getCD_Header_ID() + " AND Type = 'EG'"), (Object[])new Object[0]);
            if (amtIN == null) {
                amtIN = Env.ZERO;
            }
            if (amtEG == null) {
                amtEG = Env.ZERO;
            }
            if (ID_Summary > 0) {
                sum = new X_CD_Summary(po.getCtx(), ID_Summary, po.get_TrxName());
                sum.setTotalIncome(amtIN);
                sum.setTotalExpenses(amtEG);
                sum.save();
            } else {
                sum = new X_CD_Summary(po.getCtx(), 0, po.get_TrxName());
                sum.setCD_Header_ID(line.getCD_Header_ID());
                sum.setTotalIncome(amtIN);
                sum.setTotalExpenses(amtEG);
                sum.save();
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Header.Table_ID) {
            String sql;
            X_C_BankAccountBalance balance;
            BigDecimal bBalance;
            cab = (X_CD_Header)po;
            MBankAccount bAccount = new MBankAccount(po.getCtx(), cab.getC_BankAccount_ID(), po.get_TrxName());
            String typeBAccount = bAccount.get_ValueAsString("Type");
            if (typeBAccount == null || typeBAccount.trim().length() < 1) {
                typeBAccount = "H";
            }
            if (typeBAccount.compareTo("M") == 0) {
                bBalance = null;
                if (cab.get_ValueAsInt("C_BankAccountBalance_ID") > 0) {
                    balance = new X_C_BankAccountBalance(po.getCtx(), cab.get_ValueAsInt("C_BankAccountBalance_ID"), po.get_TrxName());
                    bBalance = balance.getAvailableBalance();
                    String sqlChild = "SELECT SUM(AvailableBalance) FROM C_BankAccountBalance  WHERE C_BankAccountBalance_ID IN  (SELECT MIN(C_BankAccountBalance_ID) FROM C_BankAccountBalance WHERE C_BankAccount_ID IN   (SELECT C_BankAccount_ID FROM C_BankAccount  WHERE C_Bank_ID = " + bAccount.getC_Bank_ID() + "  AND (Type IS NULL OR Type IN ('H'))) " + "  AND DateDoc = ? AND IsActive = 'Y')";
                    BigDecimal amountChild = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlChild, (Object[])new Object[]{cab.getDateTrx()});
                    if (amountChild != null) {
                        bBalance = bBalance.add(amountChild);
                    }
                } else {
                    log.config("monto total antes de sql: " + bBalance);
                    sql = "SELECT SUM(AvailableBalance) FROM C_BankAccountBalance WHERE C_BankAccountBalance_ID IN  (SELECT MIN(C_BankAccountBalance_ID)    FROM C_BankAccountBalance    WHERE C_BankAccount_ID IN      (SELECT C_BankAccount_ID FROM C_BankAccount        WHERE IsActive = 'Y' AND C_Bank_ID = " + bAccount.getC_Bank_ID() + "       AND (Type IS NULL OR Type IN ('H')) " + "\t\tOR C_BankAccount_ID = " + bAccount.get_ID() + ") AND DateDoc IS NOT NULL AND DateDoc = ? AND IsActive = 'Y' " + "\tGROUP BY C_BankAccount_ID) ";
                    bBalance = DB.getSQLValueBD((String)po.get_TrxName(), (String)sql, (Object[])new Object[]{cab.getDateTrx()});
                    log.config("SQL SUmatoria de saldos: " + sql);
                    log.config("parametros: banco=" + bAccount.getC_Bank_ID() + ". Account_ID=" + bAccount.get_ID() + ". DateDoc=" + cab.getDateTrx());
                    log.config("monto total: " + bBalance);
                }
                if (bBalance != null) {
                    DB.executeUpdate((String)("UPDATE CD_Header SET BeginningBalance=" + bBalance + " WHERE CD_Header_ID = " + cab.get_ID()), (String)po.get_TrxName());
                }
            } else {
                bBalance = null;
                if (cab.get_ValueAsInt("C_BankAccountBalance_ID") > 0) {
                    balance = new X_C_BankAccountBalance(po.getCtx(), cab.get_ValueAsInt("C_BankAccountBalance_ID"), po.get_TrxName());
                    bBalance = balance.getAvailableBalance();
                } else {
                    sql = "SELECT SUM(AvailableBalance) FROM C_BankAccountBalance  WHERE C_BankAccountBalance_ID IN (  SELECT MIN(C_BankAccountBalance_ID)  FROM C_BankAccountBalance  WHERE IsActive = 'Y' AND C_BankAccount_ID IN (" + bAccount.get_ID() + ") " + " AND DateDoc = ? GROUP BY C_BankAccount_ID)";
                    bBalance = DB.getSQLValueBD((String)po.get_TrxName(), (String)sql, (Object[])new Object[]{cab.getDateTrx()});
                }
                if (bBalance != null) {
                    DB.executeUpdate((String)("UPDATE CD_Header SET BeginningBalance=" + bBalance + " WHERE CD_Header_ID = " + cab.get_ID()), (String)po.get_TrxName());
                }
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Header.Table_ID) {
            cab = (X_CD_Header)po;
            ID_Summary = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + cab.get_ID()));
            if (ID_Summary <= 0) {
                X_CD_Summary sum2 = new X_CD_Summary(po.getCtx(), 0, po.get_TrxName());
                sum2.setCD_Header_ID(cab.get_ID());
                sum2.save();
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Transfer.Table_ID) {
            int ID_Summary2;
            trans = (X_CD_Transfer)po;
            BigDecimal amtTrans = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Transfer  WHERE CD_Header_ID = " + trans.getCD_Header_ID() + " AND IsActive = 'Y'"), (Object[])new Object[0]);
            if (amtTrans == null) {
                amtTrans = Env.ZERO;
            }
            if ((amtIN = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + trans.getCD_Header_ID() + " AND Type = 'IN'"), (Object[])new Object[0])) == null) {
                amtIN = Env.ZERO;
            }
            if ((ID_Summary2 = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + trans.getCD_Header_ID()))) > 0) {
                sum = new X_CD_Summary(po.getCtx(), ID_Summary2, po.get_TrxName());
                sum.setTotalTransfer(trans.getCD_Header().getBeginningBalance().add(amtIN).add(amtTrans));
                sum.save();
            } else {
                sum = new X_CD_Summary(po.getCtx(), 0, po.get_TrxName());
                sum.setCD_Header_ID(trans.getCD_Header_ID());
                sum.setTotalTransfer(trans.getCD_Header().getBeginningBalance().add(amtIN).add(amtTrans));
                sum.save();
            }
        }
        if (type == 2 && po.get_Table_ID() == X_CD_Transfer.Table_ID && (po.is_ValueChanged("Amt") || po.is_ValueChanged("C_BankAccount_ID")) && ((trans = (X_CD_Transfer)po).getDescription() != null && trans.getDescription().contains("Generado desde cuenta") || trans.get_ValueAsInt("CD_TransferRef_ID") > 0)) {
            X_CD_Transfer transFrom = new X_CD_Transfer(po.getCtx(), trans.get_ValueAsInt("CD_TransferRef_ID"), po.get_TrxName());
            if (trans.getAmt().negate().compareTo(transFrom.getAmt()) != 0) {
                return "Error: No se puede modificar movimiento destino. Debe modificar movimiento origen";
            }
        }
        if (type == 3 && po.get_Table_ID() == X_CD_Transfer.Table_ID && ((trans = (X_CD_Transfer)po).getDescription() != null && trans.getDescription().contains("Generado desde cuenta") || trans.get_ValueAsInt("CD_TransferRef_ID") > 0)) {
            return "Error: No se puede eliminar movimiento destino. Debe eliminar movimiento origen";
        }
        if (!(type != 4 && type != 5 || po.get_Table_ID() != X_CD_Transfer.Table_ID || (trans = (X_CD_Transfer)po).getDescription() != null && trans.getDescription().contains("Generado desde cuenta"))) {
            X_CD_Summary sum3;
            int ID_Summary3;
            BigDecimal amtIN2;
            MBankAccount bAccountTo = new MBankAccount(po.getCtx(), trans.getC_BankAccount_ID(), po.get_TrxName());
            int ID_DisponTo = 0;
            ID_DisponTo = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Header_ID) FROM CD_Header  WHERE C_BankAccount_ID = " + bAccountTo.get_ID() + " AND DateTrx = ? "), (Object[])new Object[]{trans.getCD_Header().getDateTrx()});
            if (ID_DisponTo > 0) {
                X_CD_Summary sumDest;
                int ID_SummaryDest;
                BigDecimal amtINDest;
                X_CD_Transfer newTrans;
                X_CD_Header head = new X_CD_Header(po.getCtx(), ID_DisponTo, po.get_TrxName());
                int ID_TransRef = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Transfer_ID) FROM CD_Transfer  WHERE CD_Header_ID =" + ID_DisponTo + " AND IsActive='Y' AND CD_TransferRef_ID = " + trans.get_ID()));
                if (ID_TransRef > 0) {
                    newTrans = new X_CD_Transfer(po.getCtx(), ID_TransRef, po.get_TrxName());
                    newTrans.setAmt(trans.getAmt().negate());
                    newTrans.save();
                } else {
                    newTrans = new X_CD_Transfer(po.getCtx(), 0, po.get_TrxName());
                    newTrans.setCD_Header_ID(head.get_ID());
                    newTrans.setAD_Org_ID(head.getAD_Org_ID());
                    newTrans.setC_Charge_ID(trans.getC_Charge_ID());
                    newTrans.setDescription("Generado desde cuenta " + trans.getCD_Header().getC_BankAccount().getAccountNo() + ". " + trans.getCD_Header().getC_BankAccount().getC_Bank().getName());
                    newTrans.setC_BankAccount_ID(trans.getCD_Header().getC_BankAccount_ID());
                    newTrans.setAmt(trans.getAmt().negate());
                    newTrans.set_CustomColumn("CD_TransferRef_ID", trans.get_ID());
                    newTrans.save();
                }
                BigDecimal amtTransDest = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Transfer  WHERE CD_Header_ID = " + head.get_ID() + " AND IsActive = 'Y'"), (Object[])new Object[0]);
                if (amtTransDest == null) {
                    amtTransDest = Env.ZERO;
                }
                if ((amtINDest = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + head.get_ID() + " AND Type = 'IN'"), (Object[])new Object[0])) == null) {
                    amtINDest = Env.ZERO;
                }
                if ((ID_SummaryDest = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + head.get_ID()))) > 0) {
                    sumDest = new X_CD_Summary(po.getCtx(), ID_SummaryDest, po.get_TrxName());
                    sumDest.setTotalTransfer(head.getBeginningBalance().add(amtINDest).add(amtTransDest));
                    sumDest.save();
                } else {
                    sumDest = new X_CD_Summary(po.getCtx(), 0, po.get_TrxName());
                    sumDest.setCD_Header_ID(head.get_ID());
                    sumDest.setTotalTransfer(head.getBeginningBalance().add(amtINDest).add(amtTransDest));
                    sumDest.save();
                }
            } else {
                return "Error: No existe disponibilidad destino";
            }
            BigDecimal amtTrans = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Transfer  WHERE CD_Header_ID = " + trans.getCD_Header_ID() + " AND IsActive = 'Y'"), (Object[])new Object[0]);
            if (amtTrans == null) {
                amtTrans = Env.ZERO;
            }
            if ((amtIN2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + trans.getCD_Header_ID() + " AND Type = 'IN'"), (Object[])new Object[0])) == null) {
                amtIN2 = Env.ZERO;
            }
            if ((ID_Summary3 = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + trans.getCD_Header_ID()))) > 0) {
                sum3 = new X_CD_Summary(po.getCtx(), ID_Summary3, po.get_TrxName());
                sum3.setTotalTransfer(trans.getCD_Header().getBeginningBalance().add(amtIN2).add(amtTrans));
                sum3.save();
            } else {
                sum3 = new X_CD_Summary(po.getCtx(), 0, po.get_TrxName());
                sum3.setCD_Header_ID(trans.getCD_Header_ID());
                sum3.setTotalTransfer(trans.getCD_Header().getBeginningBalance().add(amtIN2).add(amtTrans));
                sum3.save();
            }
        }
        if (!(type != 3 || po.get_Table_ID() != X_CD_Transfer.Table_ID || (trans = (X_CD_Transfer)po).getDescription() != null && trans.getDescription().contains("Generado desde cuenta"))) {
            int ID_HeadDes = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT CD_Header_ID FROM CD_Transfer WHERE IsActive = 'Y' AND CD_TransferRef_ID =" + trans.get_ID()));
            DB.executeUpdate((String)("DELETE FROM CD_Transfer WHERE CD_TransferRef_ID = " + trans.get_ID()), (String)po.get_TrxName());
            if (ID_HeadDes > 0) {
                int ID_SummaryDest;
                BigDecimal amtINDest;
                X_CD_Header head = new X_CD_Header(po.getCtx(), ID_HeadDes, po.get_TrxName());
                BigDecimal amtTransDest = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Transfer  WHERE CD_Header_ID = " + head.get_ID() + " AND IsActive = 'Y'"), (Object[])new Object[0]);
                if (amtTransDest == null) {
                    amtTransDest = Env.ZERO;
                }
                if ((amtINDest = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + head.get_ID() + " AND Type = 'IN'"), (Object[])new Object[0])) == null) {
                    amtINDest = Env.ZERO;
                }
                if ((ID_SummaryDest = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + head.get_ID()))) > 0) {
                    X_CD_Summary sumDest = new X_CD_Summary(po.getCtx(), ID_SummaryDest, po.get_TrxName());
                    sumDest.setTotalTransfer(head.getBeginningBalance().add(amtINDest).add(amtTransDest));
                    sumDest.save();
                }
            }
        }
        if (!(type != 6 || po.get_Table_ID() != X_CD_Transfer.Table_ID || (trans = (X_CD_Transfer)po).getDescription() != null && trans.getDescription().contains("Generado desde cuenta"))) {
            int ID_SummaryOrg;
            BigDecimal amtINOrg;
            X_CD_Header headOrg = new X_CD_Header(po.getCtx(), trans.getCD_Header_ID(), po.get_TrxName());
            BigDecimal amtTransOrg = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Transfer  WHERE CD_Header_ID = " + headOrg.get_ID() + " AND IsActive = 'Y'"), (Object[])new Object[0]);
            if (amtTransOrg == null) {
                amtTransOrg = Env.ZERO;
            }
            if ((amtINOrg = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + headOrg.get_ID() + " AND Type = 'IN'"), (Object[])new Object[0])) == null) {
                amtINOrg = Env.ZERO;
            }
            if ((ID_SummaryOrg = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + headOrg.get_ID()))) > 0) {
                X_CD_Summary sumOrg = new X_CD_Summary(po.getCtx(), ID_SummaryOrg, po.get_TrxName());
                sumOrg.setTotalTransfer(headOrg.getBeginningBalance().add(amtINOrg).add(amtTransOrg));
                sumOrg.save();
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Transfer.Table_ID) {
            trans = (X_CD_Transfer)po;
            int ID_Summary4 = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + trans.getCD_Header_ID()));
            if (ID_Summary4 > 0) {
                X_CD_Summary sum4 = new X_CD_Summary(po.getCtx(), ID_Summary4, po.get_TrxName());
                DB.executeUpdate((String)("UPDATE CD_Transfer SET Amt2 = " + sum4.getGrandTotal() + " WHERE CD_Transfer_ID = " + trans.get_ID()), (String)po.get_TrxName());
                DB.executeUpdate((String)("UPDATE CD_Transfer SET Amt3 = " + sum4.getGrandTotal().subtract(trans.getAmt()) + " WHERE CD_Transfer_ID = " + trans.get_ID()), (String)po.get_TrxName());
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_CD_Summary.Table_ID) {
            summ = (X_CD_Summary)po;
            BigDecimal amtTrans = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Transfer  WHERE CD_Header_ID = " + summ.getCD_Header_ID() + " AND IsActive = 'Y'"), (Object[])new Object[0]);
            if (amtTrans == null) {
                amtTrans = Env.ZERO;
            }
            BigDecimal amtIN3 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + summ.getCD_Header_ID() + " AND Type = 'IN'"), (Object[])new Object[0]);
            BigDecimal amtEG = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM CD_Line  WHERE CD_Header_ID = " + summ.getCD_Header_ID() + " AND Type = 'EG'"), (Object[])new Object[0]);
            if (amtIN3 == null) {
                amtIN3 = Env.ZERO;
            }
            if (amtEG == null) {
                amtEG = Env.ZERO;
            }
            summ.setTotalIncome(amtIN3);
            summ.setTotalExpenses(amtEG);
            summ.setTotalBanks(summ.getCD_Header().getBeginningBalance().add(amtIN3));
            String sqlCLine = "SELECT SUM(AvailableBalance) FROM C_BankAccountBalance WHERE C_BankAccountBalance_ID IN (SELECT MIN(C_BankAccountBalance_ID)    FROM C_BankAccountBalance WHERE C_BankAccount_ID IN       (SELECT C_BankAccount_ID FROM C_BankAccount        WHERE C_Bank_ID = " + summ.getCD_Header().getC_Bank_ID() + " AND IsCreditLine = 'Y') " + "   AND DateDoc = ? AND IsActive = 'Y' GROUP BY C_BankAccount_ID)";
            BigDecimal amtCLine = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlCLine, (Object[])new Object[]{summ.getCD_Header().getDateTrx()});
            if (amtCLine == null) {
                amtCLine = Env.ZERO;
            }
            summ.setCreditLine(amtCLine);
            BigDecimal amtATrans = summ.getCD_Header().getBeginningBalance().add(amtIN3).add(amtTrans);
            summ.setTotalTransfer(amtATrans);
            BigDecimal excedente = summ.getCD_Header().getBeginningBalance().subtract(amtEG);
            excedente = excedente.add(amtTrans);
            excedente = excedente.add(amtIN3);
            summ.setSurplus(excedente);
            BigDecimal invest2 = (BigDecimal)summ.get_Value("InvestmentAmount2");
            if (invest2 == null) {
                invest2 = Env.ZERO;
            }
            BigDecimal totalAmt = excedente.subtract(summ.getInvestmentAmount());
            totalAmt = totalAmt.subtract(invest2);
            summ.setGrandTotal(totalAmt);
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Summary.Table_ID) {
            summ = (X_CD_Summary)po;
            DB.executeUpdate((String)("UPDATE CD_Header SET EndingBalance=" + summ.getGrandTotal() + " WHERE CD_Header_ID = " + summ.getCD_Header_ID()), (String)po.get_TrxName());
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CD_Line.Table_ID) {
            line = (X_CD_Line)po;
            int ID_Summary5 = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(CD_Summary_ID)  FROM CD_Summary WHERE IsActive = 'Y' AND CD_Header_ID = " + line.getCD_Header_ID()));
            if (ID_Summary5 > 0) {
                X_CD_Summary sum5 = new X_CD_Summary(po.getCtx(), ID_Summary5, po.get_TrxName());
                DB.executeUpdate((String)("UPDATE CD_Line SET Amt2 = " + sum5.getGrandTotal() + " WHERE CD_Line_ID = " + line.get_ID()), (String)po.get_TrxName());
                if (line.get_ValueAsString("Type").compareTo("IN") == 0) {
                    DB.executeUpdate((String)("UPDATE CD_Line SET Amt3 = " + sum5.getGrandTotal().subtract(line.getAmt()) + " WHERE CD_Line_ID = " + line.get_ID()), (String)po.get_TrxName());
                } else if (line.get_ValueAsString("Type").compareTo("EG") == 0) {
                    DB.executeUpdate((String)("UPDATE CD_Line SET Amt3 = " + sum5.getGrandTotal().add(line.getAmt()) + " WHERE CD_Line_ID = " + line.get_ID()), (String)po.get_TrxName());
                } else {
                    DB.executeUpdate((String)("UPDATE CD_Line SET Amt3 = " + sum5.getGrandTotal().subtract(line.getAmt()) + " WHERE CD_Line_ID = " + line.get_ID()), (String)po.get_TrxName());
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

