/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.gui.MainFrame;
import java.util.ArrayList;
import java.util.List;

public class TextFieldReportElement
extends TextReportElement
implements HyperLinkableReportElement {
    public static final String PATTERN = "PATTERN";
    public static final String DEFAULT_PATTERN = "";
    private String classExpression;
    private String group;
    private String evaluationTime;
    private boolean blankWhenNull;
    private boolean stretchWithOverflow;
    private String anchorNameExpression = "";
    private String hyperlinkAnchorExpression = "";
    private String hyperlinkPageExpression = "";
    private String hyperlinkReferenceExpression = "";
    private String hyperlinkType = "None";
    private String tooltip = "";
    private int bookmarkLevel = 0;
    private List linkParameters = new ArrayList();
    private static List acceptedTextfieldClasses = null;
    protected String hyperlinkTarget = "Self";

    public TextFieldReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setText("$F{Field}");
        this.stretchWithOverflow = false;
        this.blankWhenNull = false;
        this.group = DEFAULT_PATTERN;
        this.evaluationTime = "Now";
        this.classExpression = "java.lang.String";
        this.hyperlinkType = "None";
        this.anchorNameExpression = DEFAULT_PATTERN;
        this.setKey("textField");
    }

    public boolean isBlankWhenNull() {
        return this.blankWhenNull;
    }

    public void setBlankWhenNull(boolean blankWhenNull) {
        this.blankWhenNull = blankWhenNull;
    }

    public String getClassExpression() {
        return this.classExpression;
    }

    public void setClassExpression(String classExpression) {
        this.classExpression = classExpression;
    }

    public void setMatchingClassExpression(String newClassName, boolean adjustExpression) {
        if (!acceptedTextfieldClasses.contains(newClassName)) {
            try {
                Class newClass = MainFrame.getMainInstance().getReportClassLoader().loadClass(newClassName);
                this.setMatchingClassExpression(newClass, adjustExpression);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.setClassExpression(newClassName);
        }
    }

    private void setMatchingClassExpression(Class newClass, boolean adjustExpression) {
        Class superClass = newClass.getSuperclass();
        if (superClass == null) {
            this.classExpression = this.classExpression;
            if (adjustExpression) {
                this.setText("\"\"+" + this.getText());
            }
        } else {
            this.setMatchingClassExpression(superClass.getName(), adjustExpression);
        }
    }

    public String getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(String evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPattern() {
        if (this.getPropertyValue(PATTERN) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("pattern", DEFAULT_PATTERN, true);
        }
        return this.getStringValue(PATTERN, DEFAULT_PATTERN);
    }

    public void setPattern(String pattern) {
        this.setPropertyValue(PATTERN, pattern);
    }

    public boolean isStretchWithOverflow() {
        return this.stretchWithOverflow;
    }

    public void setStretchWithOverflow(boolean stretchWithOverflow) {
        this.stretchWithOverflow = stretchWithOverflow;
    }

    public String getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(String anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public String getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(String hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public String getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(String hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    public String getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(String hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public String getHyperlinkType() {
        return this.hyperlinkType;
    }

    public void setHyperlinkType(String hyperlinkType) {
        this.hyperlinkType = hyperlinkType;
    }

    public ReportElement cloneMe() {
        TextFieldReportElement newReportElement = new TextFieldReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof TextFieldReportElement && source instanceof TextFieldReportElement) {
            destination.setPropertyValue(PATTERN, source.getPropertyValue(PATTERN));
            ((TextFieldReportElement)destination).setBlankWhenNull(((TextFieldReportElement)source).isBlankWhenNull());
            ((TextFieldReportElement)destination).setClassExpression(new String(((TextFieldReportElement)source).getClassExpression()));
            ((TextFieldReportElement)destination).setEvaluationTime(new String(((TextFieldReportElement)source).getEvaluationTime()));
            ((TextFieldReportElement)destination).setGroup(new String(((TextFieldReportElement)source).getGroup()));
            ((TextFieldReportElement)destination).setStretchWithOverflow(((TextFieldReportElement)source).isStretchWithOverflow());
            ((HyperLinkableReportElement)((Object)destination)).setAnchorNameExpression(new String(((HyperLinkableReportElement)((Object)source)).getAnchorNameExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkAnchorExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkAnchorExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkPageExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkPageExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkReferenceExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkReferenceExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkType(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkType()));
        }
    }

    public String getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(String hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            this.setBlankWhenNull(style.getAttributeBoolean("isBlankWhenNull", this.isBlankWhenNull(), true));
        }
    }

    public List getLinkParameters() {
        return this.linkParameters;
    }

    public void setLinkParameters(List linkParameters) {
        this.linkParameters = linkParameters;
    }

    public String getTooltipExpression() {
        return this.tooltip;
    }

    public void setTooltipExpression(String s) {
        this.tooltip = s;
    }

    static {
        acceptedTextfieldClasses = new ArrayList();
        acceptedTextfieldClasses.add("java.lang.Boolean");
        acceptedTextfieldClasses.add("java.lang.Byte");
        acceptedTextfieldClasses.add("java.util.Date");
        acceptedTextfieldClasses.add("java.sql.Timestamp");
        acceptedTextfieldClasses.add("java.sql.Time");
        acceptedTextfieldClasses.add("java.lang.Double");
        acceptedTextfieldClasses.add("java.lang.Float");
        acceptedTextfieldClasses.add("java.lang.Integer");
        acceptedTextfieldClasses.add("java.lang.Long");
        acceptedTextfieldClasses.add("java.lang.Short");
        acceptedTextfieldClasses.add("java.math.BigDecimal");
        acceptedTextfieldClasses.add("java.lang.Number");
        acceptedTextfieldClasses.add("java.lang.String");
    }
}

