/*
 * Decompiled with CFR 0.152.
 */
package test.performance;

import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.compiere.Adempiere;
import org.compiere.model.MProduct;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Ini;

public class SingleMProductTest
extends TestCase {
    private Properties testProperties = null;
    private Properties m_Ctx = null;
    private String fileName_DefaultValue = "J:/Trifon-CD-0.3/workspace/adempiere-trunk/adempiere/Adempiere/Adempiere.properties";
    private String fileName_Key = "AdempiereProperties";
    private String fileName_Value = "";
    private String isClient_DefaultValue = "Y";
    private String isClient_Key = "isClient";
    private boolean isClient_Value = true;
    private String AD_User_ID_DefaultValue = "0";
    private String AD_User_ID_Key = "AD_User_ID";
    private int AD_User_ID_Value = 0;
    private MProduct product = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.testProperties = new Properties();
        this.testProperties.load(new FileInputStream("test.properties"));
        this.fileName_Value = this.testProperties.getProperty(this.fileName_Key, this.fileName_DefaultValue);
        this.isClient_Value = "Y".equals(this.testProperties.getProperty(this.isClient_Key, this.isClient_DefaultValue));
        this.AD_User_ID_Value = Integer.parseInt(this.testProperties.getProperty(this.AD_User_ID_Key, this.AD_User_ID_DefaultValue));
        this.m_Ctx = new Properties();
        this.m_Ctx.setProperty("#AD_User_ID", new Integer(this.AD_User_ID_Value).toString());
        System.out.println("m_Ctx: " + this.m_Ctx);
        if (this.fileName_Value.length() < 1) {
            SingleMProductTest.assertEquals((String)"Please specify path to Adempiere.properties file!", (boolean)true, (boolean)false);
        }
        System.setProperty("PropertyFile", this.fileName_Value);
        Ini.setClient(this.isClient_Value);
        Adempiere.startup(this.isClient_Value);
        CLogMgt.setLevel(Level.OFF);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testProperties = null;
        this.m_Ctx = null;
    }

    public void testMProductCreation() {
        boolean singleCommit = true;
        String trxName = "test";
        this.m_Ctx.setProperty("#AD_Client_ID", Integer.valueOf(11).toString());
        long startTime = System.currentTimeMillis();
        System.out.println("Start Time(ms) = " + startTime);
        System.out.println("Start Time     = " + new Date(startTime));
        int startCount = 5;
        int count = 1;
        for (int idx = startCount; idx < startCount + count; ++idx) {
            this.product = new MProduct(this.m_Ctx, 0, trxName);
            this.product.setAD_Org_ID(0);
            this.product.setValue("Test-Single-Product-" + idx);
            this.product.setName("Test-Single-Product-" + idx);
            int M_Product_Category_ID = 105;
            this.product.setM_Product_Category_ID(M_Product_Category_ID);
            int C_TaxCategory_ID = 107;
            this.product.setC_TaxCategory_ID(C_TaxCategory_ID);
            int C_UOM_ID = 100;
            this.product.setC_UOM_ID(C_UOM_ID);
            String ProductType = "I";
            this.product.setProductType(ProductType);
            boolean saveResult = this.product.save();
            if (!saveResult) {
                SingleMProductTest.assertEquals((String)"Product not updated!", (boolean)true, (boolean)saveResult);
                continue;
            }
            if (!singleCommit) continue;
            try {
                DB.commit(true, trxName);
                continue;
            }
            catch (Exception e) {
                SingleMProductTest.assertEquals((String)"Product not updated!", (boolean)true, (boolean)false);
            }
        }
        if (!singleCommit) {
            try {
                DB.commit(true, trxName);
            }
            catch (Exception e) {
                SingleMProductTest.assertEquals((String)"Product not updated!", (boolean)true, (boolean)false);
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("End Time(ms) = " + endTime);
        System.out.println("End Time     = " + new Date(endTime));
        long time = endTime - startTime;
        System.out.println("Duration(ms) = " + time);
        System.out.println("Duration(sec.) = " + (time /= 1000L));
        if (time > 0L) {
            System.out.println("Duration(min.) = " + time / 60L);
        }
        System.out.println("Count = " + count + "; Time(seconds) = " + time + "; Produsts/Second = " + (float)count / (float)time + "; ");
        SingleMProductTest.assertTrue((String)((Object)((Object)this)).getClass().getName(), (boolean)true);
    }
}

