/*
 * Decompiled with CFR 0.152.
 */
package test.functional.mrp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.I_M_Product;
import org.compiere.model.I_M_Warehouse;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MLocation;
import org.compiere.model.MProduct;
import org.compiere.model.MResource;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.I_PP_MRP;
import org.eevolution.model.I_PP_Product_Planning;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPProductPlanning;

public class MRPUtil {
    public static int getFirst_Org_ID() {
        String sql = "SELECT MIN(AD_Org_ID) FROM AD_Org WHERE AD_Client_ID=?";
        return DB.getSQLValueEx(null, sql, Env.getAD_Client_ID(Env.getCtx()));
    }

    public static I_M_Warehouse getCreateWarehouse(int AD_Org_ID, String value) {
        Properties ctx = Env.getCtx();
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String whereClause = "AD_Client_ID=? AND AD_Org_ID=? AND Value=?";
        MWarehouse wh = (MWarehouse)new Query(ctx, "M_Warehouse", whereClause, null).setParameters(AD_Client_ID, AD_Org_ID, value).firstOnly();
        if (wh != null) {
            return wh;
        }
        wh = new MWarehouse(ctx, 0, null);
        wh.setAD_Org_ID(AD_Org_ID);
        wh.setValue(value);
        wh.setName(value);
        MLocation loc = new MLocation(ctx, 0, null);
        loc.saveEx();
        wh.setC_Location_ID(loc.get_ID());
        wh.saveEx();
        return wh;
    }

    public static I_S_Resource getCreatePlant(String value, int M_Warehouse_ID, int PlanningHorizon) {
        Properties ctx = Env.getCtx();
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String whereClause = "Value=? AND AD_Client_ID=?";
        MResource r = (MResource)new Query(ctx, "S_Resource", whereClause, null).setParameters(value, AD_Client_ID).firstOnly();
        if (r == null) {
            r = new MResource(ctx, 0, null);
            int S_ResourceType_ID = DB.getSQLValueEx(null, "SELECT MIN(S_ResourceType_ID) FROM S_Resource WHERE AD_Client_ID=? AND IsAvailable=?", AD_Client_ID, true);
            r.setS_ResourceType_ID(S_ResourceType_ID);
        }
        r.setValue(value);
        r.setName(value);
        r.setIsManufacturingResource(true);
        r.setManufacturingResourceType("PT");
        r.setIsAvailable(true);
        r.setM_Warehouse_ID(M_Warehouse_ID);
        r.setPlanningHorizon(PlanningHorizon);
        r.setPercentUtilization(Env.ONEHUNDRED);
        r.saveEx();
        return r;
    }

    public static I_M_Product getCreateProduct(Properties ctx, String value, boolean isPurchased) {
        MProduct[] arr = MProduct.get(ctx, "Value='" + value + "'", null);
        if (arr.length > 0) {
            return arr[0];
        }
        MProduct p2 = new MProduct(ctx, 0, null);
        p2.setValue(value);
        p2.setName(value);
        p2.setAD_Org_ID(0);
        p2.setProductType("I");
        p2.setIsBOM(false);
        p2.setIsInvoicePrintDetails(false);
        p2.setIsPickListPrintDetails(false);
        p2.setIsPurchased(isPurchased);
        p2.setIsSold(true);
        p2.setIsStocked(true);
        p2.setIsSummary(false);
        p2.setIsVerified(false);
        p2.setIsWebStoreFeatured(false);
        p2.setIsSelfService(true);
        p2.setIsExcludeAutoDelivery(false);
        p2.setProcessing(false);
        p2.setC_UOM_ID(100);
        p2.saveEx();
        return p2;
    }

    public static I_PP_Product_Planning getPlanning(String productValue, String Order_Policy, int Order_Min, int Order_Max, int Order_Pack, int SafetyStock, int Order_Period, int LeadTime) {
        boolean isPurchased = true;
        int PlanningHorizon = 365;
        Properties ctx = Env.getCtx();
        int AD_Org_ID = MRPUtil.getFirst_Org_ID();
        I_M_Warehouse wh = MRPUtil.getCreateWarehouse(AD_Org_ID, productValue);
        I_S_Resource plant = MRPUtil.getCreatePlant(productValue, wh.getM_Warehouse_ID(), PlanningHorizon);
        I_M_Product product = MRPUtil.getCreateProduct(ctx, productValue, isPurchased);
        MPPProductPlanning pp = new MPPProductPlanning(ctx, 0, null);
        pp.setIsCreatePlan(true);
        pp.setIsRequiredMRP(true);
        pp.setIsRequiredDRP(false);
        pp.setM_Product_ID(product.getM_Product_ID());
        pp.setAD_Org_ID(AD_Org_ID);
        pp.setM_Warehouse_ID(wh.getM_Warehouse_ID());
        pp.setS_Resource_ID(plant.getS_Resource_ID());
        pp.setOrder_Policy(Order_Policy);
        pp.setOrder_Min(BigDecimal.valueOf(Order_Min));
        pp.setOrder_Max(BigDecimal.valueOf(Order_Max));
        pp.setOrder_Pack(BigDecimal.valueOf(Order_Pack));
        pp.setSafetyStock(BigDecimal.valueOf(SafetyStock));
        pp.setOrder_Period(BigDecimal.valueOf(Order_Period));
        pp.setDeliveryTime_Promised(BigDecimal.valueOf(LeadTime));
        return pp;
    }

    public static I_PP_MRP createMRP(I_PP_Product_Planning planning, String TypeMRP, String DocStatus, BigDecimal Qty, Timestamp DatePromised, Timestamp DateStartSchedule) {
        Properties ctx = Env.getCtx();
        MPPMRP mrp = new MPPMRP(ctx, 0, null);
        mrp.setAD_Org_ID(planning.getAD_Org_ID());
        mrp.setName("MRP");
        mrp.setTypeMRP(TypeMRP);
        mrp.setDocStatus(DocStatus);
        mrp.setQty(Qty);
        mrp.setDatePromised(DatePromised);
        mrp.setDateStartSchedule(DateStartSchedule);
        mrp.setDateFinishSchedule(DatePromised);
        mrp.setDateOrdered(DatePromised);
        mrp.setM_Product_ID(planning.getM_Product_ID());
        mrp.setM_Warehouse_ID(planning.getM_Warehouse_ID());
        return mrp;
    }

    public static String toString(Object[] arr) {
        if (arr == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int i = 1;
        sb.append("(size=" + arr.length + ")");
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append("[" + i + ":" + o + "]");
            ++i;
            ++n2;
        }
        return sb.toString();
    }
}

