/*
 * Decompiled with CFR 0.152.
 */
package test.functional.inventory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;
import test.functional.inventory.MMDocument;
import test.functional.inventory.MMScenario;

public class CSVFactory {
    public static final DateFormat s_dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private ICsvListReader reader;

    public Collection<MMScenario> read(InputStream in) throws Exception {
        ArrayList<MMScenario> tests = new ArrayList<MMScenario>();
        this.reader = new CsvListReader((Reader)new InputStreamReader(in), CsvPreference.STANDARD_PREFERENCE);
        String[] header = this.getCSVHeader();
        int last_lineNo = -1;
        MMScenario scenario = null;
        try {
            List line;
            while ((line = this.reader.read()) != null) {
                if (last_lineNo == -1 || last_lineNo + 1 < this.reader.getLineNumber()) {
                    if (scenario != null) {
                        tests.add(scenario);
                    }
                    scenario = new MMScenario("junit-test-line_" + new DecimalFormat("000").format(this.reader.getLineNumber()));
                }
                this.readDocument(scenario, header, line);
                last_lineNo = this.reader.getLineNumber();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error on line " + this.reader.getLineNumber() + ": " + e.getLocalizedMessage(), e);
        }
        if (scenario != null) {
            tests.add(scenario);
        }
        return tests;
    }

    private String[] getCSVHeader() throws IOException {
        String[] header = this.reader.getCSVHeader(true);
        for (int i2 = 0; i2 < header.length; ++i2) {
            header[i2] = header[i2].trim().replaceAll("\\s", "");
        }
        return header;
    }

    private void readDocument(MMScenario scenario, String[] header, List<String> line) {
        MMDocument doc = new MMDocument(scenario);
        doc.csvLineNo = this.reader.getLineNumber();
        doc.DocBaseType = CSVFactory.getValue("DocType", String.class, header, line);
        doc.DocumentNo = CSVFactory.getValue("DocumentNo", String.class, header, line);
        doc.LocatorValue = CSVFactory.getValue("LocatorValue", String.class, header, line);
        doc.LocatorValueTo = CSVFactory.getValue("LocatorValueTo", String.class, header, line);
        doc.ProductValue = CSVFactory.getValue("ProductValue", String.class, header, line);
        doc.Price = CSVFactory.getValue("Price", BigDecimal.class, header, line);
        doc.Qty = CSVFactory.getValue("Qty", BigDecimal.class, header, line);
        doc.QtyOrdered = CSVFactory.getValue("QtyOrdered", BigDecimal.class, header, line);
        doc.QtyReserved = CSVFactory.getValue("QtyReserved", BigDecimal.class, header, line);
        doc.ASI = CSVFactory.getValue("ASI", String.class, header, line);
        doc.Date = CSVFactory.getValue("MovementDate", Timestamp.class, header, line);
        doc.PODocumentNo = CSVFactory.getValue("PODocumentNo", String.class, header, line);
        doc.IsReversal = CSVFactory.getValue("IsReversal", Boolean.class, header, line);
        scenario.docs.add(doc);
    }

    public static <T> T getValue(String name, Class<T> clazz, String[] headers, List<String> values) {
        String value = null;
        for (int i2 = 0; i2 < headers.length; ++i2) {
            if (!name.equalsIgnoreCase(headers[i2])) continue;
            if (values.size() <= i2) break;
            value = values.get(i2);
            break;
        }
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        if (String.class == clazz) {
            return (T)value;
        }
        if (BigDecimal.class == clazz) {
            if (value == null) {
                return (T)BigDecimal.ZERO;
            }
            return (T)new BigDecimal(value);
        }
        if (Integer.class == clazz) {
            if (value == null) {
                return (T)Integer.valueOf(0);
            }
            return (T)Integer.valueOf(Integer.parseInt(value));
        }
        if (Timestamp.class == clazz) {
            if (value == null) {
                return null;
            }
            try {
                Date date = s_dateFormat.parse(value);
                return (T)new Timestamp(date.getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (Boolean.class == clazz) {
            if (value == null) {
                return (T)Boolean.FALSE;
            }
            if ("Y".equals(value)) {
                return (T)Boolean.TRUE;
            }
            if ("N".equals(value)) {
                return (T)Boolean.FALSE;
            }
            throw new IllegalStateException("Invalid boolean value '" + value + "'");
        }
        throw new IllegalArgumentException("clazz not supported - " + clazz);
    }
}

