/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MTable;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import test.AdempiereTestCase;

public class QueryTest
extends AdempiereTestCase {
    public void testQuery_NoTable() throws Exception {
        this.assertExceptionThrown("", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                new Query(QueryTest.this.getCtx(), "NO_TABLE_DEFINED", null, QueryTest.this.getTrxName());
            }
        });
    }

    public void testList() throws Exception {
        List list = new Query(this.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").list();
        QueryTest.assertEquals((String)"Invalid list size", (int)2, (int)list.size());
        QueryTest.assertEquals((String)"Invalid object 1", (String)((MTable)list.get(0)).getTableName(), (String)"C_Invoice");
        QueryTest.assertEquals((String)"Invalid object 2", (String)((MTable)list.get(1)).getTableName(), (String)"M_InOut");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScroll() throws Exception {
        POResultSet rs = new Query(this.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").scroll();
        try {
            int i2 = 0;
            while (rs.hasNext()) {
                MTable t = (MTable)rs.next();
                if (i2 == 0) {
                    QueryTest.assertEquals((String)("Invalid object " + i2), (String)"C_Invoice", (String)t.getTableName());
                } else if (i2 == 1) {
                    QueryTest.assertEquals((String)("Invalid object " + i2), (String)"M_InOut", (String)t.getTableName());
                } else {
                    QueryTest.assertFalse((String)"More objects retrived than expected", (boolean)true);
                }
                ++i2;
            }
        }
        finally {
            DB.close(rs);
            rs = null;
        }
    }

    public void testIterate() throws Exception {
        Iterator it = new Query(this.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").iterate();
        int i2 = 0;
        while (it.hasNext()) {
            MTable t = (MTable)it.next();
            if (i2 == 0) {
                QueryTest.assertEquals((String)("Invalid object " + i2), (String)"C_Invoice", (String)t.getTableName());
            } else if (i2 == 1) {
                QueryTest.assertEquals((String)("Invalid object " + i2), (String)"M_InOut", (String)t.getTableName());
            } else {
                QueryTest.assertFalse((String)"More objects retrived than expected", (boolean)true);
            }
            ++i2;
        }
    }

    public void testCount() throws Exception {
        int count = new Query(this.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").count();
        QueryTest.assertEquals((String)"Invalid count", (int)2, (int)count);
    }

    public void testCount_BadSQL() throws Exception {
        this.assertExceptionThrown(null, DBException.class, new Runnable(){

            @Override
            public void run() {
                new Query(QueryTest.this.getCtx(), "AD_Table", "TableName IN (?,?) AND BAD_SQL", QueryTest.this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").count();
            }
        });
    }

    public void testCount_NoValues() throws Exception {
        int count = new Query(this.getCtx(), "AD_Table", "1=2", this.getTrxName()).count();
        QueryTest.assertEquals((String)"Counter should be ZERO", (int)0, (int)count);
    }

    public void testFirst() throws Exception {
        MTable t = (MTable)new Query(this.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").first();
        QueryTest.assertEquals((String)"Invalid object", (String)"C_Invoice", (String)t.getTableName());
    }

    public void testFirstId() throws Exception {
        int id = new Query(this.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").firstId();
        int expectedId = 318;
        QueryTest.assertEquals((String)"Invalid ID", (int)expectedId, (int)id);
    }

    public void testFirstOnly() throws Exception {
        MTable t = (MTable)new Query(this.getCtx(), "AD_Table", "AD_Table_ID=?", this.getTrxName()).setParameters(318).firstOnly();
        QueryTest.assertEquals((String)"Invalid table ID", (int)318, (int)t.get_ID());
        this.assertExceptionThrown(null, DBException.class, new Runnable(){

            @Override
            public void run() {
                new Query(QueryTest.this.getCtx(), "AD_Table", "TableName IN (?,?)", QueryTest.this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").firstOnly();
            }
        });
    }

    public void testFirstIdOnly() throws Exception {
        int expectedId = 318;
        int id = new Query(this.getCtx(), "AD_Table", "AD_Table_ID=?", this.getTrxName()).setParameters(expectedId).firstIdOnly();
        QueryTest.assertEquals((String)"Invalid table ID", (int)expectedId, (int)id);
        this.assertExceptionThrown(null, DBException.class, new Runnable(){

            @Override
            public void run() {
                new Query(QueryTest.this.getCtx(), "AD_Table", "TableName IN (?,?)", QueryTest.this.getTrxName()).setParameters("C_Invoice", "M_InOut").setOrderBy("TableName").firstIdOnly();
            }
        });
    }

    public void testSetClient_ID() throws Exception {
        int AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        String sql = "SELECT COUNT(*) FROM C_Invoice WHERE IsActive='Y' AND AD_Client_ID=" + AD_Client_ID;
        int targetCount = DB.getSQLValue(null, sql);
        int count = new Query(this.getCtx(), "C_Invoice", "1=1", this.getTrxName()).setOnlyActiveRecords(true).setClient_ID().count();
        QueryTest.assertEquals((String)"Invoice # not match", (int)targetCount, (int)count);
    }

    public void testGet_IDs() throws Exception {
        String whereClause = "AD_Element_ID IN (101, 102)";
        int[] ids = new Query(this.getCtx(), "AD_Element", "AD_Element_ID IN (101, 102)", this.getTrxName()).setOrderBy("AD_Element_ID").getIDs();
        QueryTest.assertNotNull((Object)ids);
        QueryTest.assertEquals((int)2, (int)ids.length);
        QueryTest.assertEquals((int)101, (int)ids[0]);
        QueryTest.assertEquals((int)102, (int)ids[1]);
    }

    public void testAggregate() throws Exception {
        int AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        String sqlFrom = "FROM C_InvoiceLine WHERE IsActive='Y' AND AD_Client_ID=" + AD_Client_ID;
        final Query query = new Query(this.getCtx(), "C_InvoiceLine", null, this.getTrxName()).setOnlyActiveRecords(true).setClient_ID();
        QueryTest.assertEquals((String)"COUNT not match", (Object)DB.getSQLValueBDEx(this.getTrxName(), "SELECT COUNT(*) " + sqlFrom, new Object[0]), (Object)query.aggregate(null, "COUNT"));
        QueryTest.assertEquals((String)"SUM not match", (Object)DB.getSQLValueBDEx(this.getTrxName(), "SELECT SUM(LineNetAmt+TaxAmt) " + sqlFrom, new Object[0]), (Object)query.aggregate("LineNetAmt+TaxAmt", "SUM"));
        QueryTest.assertEquals((String)"MIN not match", (Object)DB.getSQLValueBDEx(this.getTrxName(), "SELECT MIN(LineNetAmt) " + sqlFrom, new Object[0]), (Object)query.aggregate("LineNetAmt", "MIN"));
        QueryTest.assertEquals((String)"MAX not match", (Object)DB.getSQLValueBDEx(this.getTrxName(), "SELECT MAX(LineNetAmt) " + sqlFrom, new Object[0]), (Object)query.aggregate("LineNetAmt", "MAX"));
        QueryTest.assertEquals((String)"MAX not match (String)", (String)DB.getSQLValueStringEx(this.getTrxName(), "SELECT MAX(Description) " + sqlFrom, new Object[0]), (String)query.aggregate("Description", "MAX", String.class));
        QueryTest.assertEquals((String)"MAX not match (Timestamp)", (Object)DB.getSQLValueTSEx(this.getTrxName(), "SELECT MAX(Updated) " + sqlFrom, new Object[0]), (Object)query.aggregate("Updated", "MAX", Timestamp.class));
        this.assertExceptionThrown("No Aggregate Function defined", DBException.class, new Runnable(){

            @Override
            public void run() {
                query.aggregate("*", null);
            }
        });
        this.assertExceptionThrown("No Expression defined", DBException.class, new Runnable(){

            @Override
            public void run() {
                query.aggregate(null, "SUM");
            }
        });
    }

    public void testOnlySelection() throws Exception {
        int AD_PInstance_ID = DB.getSQLValueEx(null, "SELECT MAX(AD_PInstance_ID) FROM AD_PInstance", new Object[0]);
        QueryTest.assertTrue((AD_PInstance_ID > 0 ? 1 : 0) != 0);
        ArrayList<Integer> elements = new ArrayList<Integer>();
        elements.add(102);
        elements.add(104);
        DB.executeUpdateEx("DELETE FROM T_Selection WHERE AD_PInstance_ID=" + AD_PInstance_ID, this.getTrxName());
        DB.createT_Selection(AD_PInstance_ID, elements, this.getTrxName());
        String whereClause = "1=1";
        int[] ids = new Query(this.getCtx(), "AD_Element", whereClause, this.getTrxName()).setOnlySelection(AD_PInstance_ID).setOrderBy("AD_Element_ID").getIDs();
        QueryTest.assertEquals((String)"Resulting number of elements differ", (int)elements.size(), (int)ids.length);
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            int expected = (Integer)elements.get(i2);
            QueryTest.assertEquals((String)("Element " + i2 + " not equals"), (int)expected, (int)ids[i2]);
        }
    }
}

